using UnityEngine;
using System.Collections;
using System.Collections.Generic;

namespace Verse{
public class Projectile_Explosive : Projectile
{
	private int ticksToDetonation = 0;

	public override void ExposeData()
	{
		base.ExposeData();

		Scribe_Values.LookValue(ref ticksToDetonation, "ticksToDetonation");
	}


	public override void Tick()
	{
		base.Tick();
		
		if( ticksToDetonation > 0 )
		{
			ticksToDetonation--;
			
			if( ticksToDetonation <= 0 )
				Explode();
		}
	}
	
	protected override void Impact(Thing hitThing)
	{
		if( def.projectile.explosionDelay == 0 )
		{
			Explode();
			return;
		}
		else
		{
			landed = true;
			ticksToDetonation = def.projectile.explosionDelay;
			GenExplosion.NotifyNearbyPawnsOfDangerousExplosive(this, def.projectile.damageDef, launcher.Faction);
		}
	}	
	
	protected virtual void Explode()
	{
		Destroy();

		GenExplosion.DoExplosion(Position, def.projectile.explosionRadius, def.projectile.damageDef, launcher,
			explosionSound: def.projectile.soundExplode,
			projectile: def,
			source: equipmentDef,
			postExplosionSpawnThingDef: def.projectile.postExplosionSpawnThingDef,
			postExplosionSpawnChance: def.projectile.explosionSpawnChance,
			preExplosionSpawnThingDef: def.projectile.preExplosionSpawnThingDef,
			preExplosionSpawnChance: def.projectile.explosionSpawnChance);
	}
}
}