﻿using System;
using RimWorld;
using Verse;
using System.Collections.Generic;
using System.Linq;

namespace CultOfCthulhu
{
    public class Dialog_RenameCult : Dialog_Rename
    {

        public Dialog_RenameCult()
        {
            if (Find.AnyPlayerHomeMap != null)
            {
                this.curName = Find.AnyPlayerHomeMap.GetComponent<MapComponent_LocalCultTracker>().Get.CultName;
            }
            else
            {
                Log.Error("Missing map to declare as home area");
            }
        }

        protected override AcceptanceReport NameIsValid(string name)
        {
            AcceptanceReport result = base.NameIsValid(name);
            if (!result.Accepted)
            {
                return result;
            }
            if (name.Length == 0 || (!CultUtility.CheckValidCultName(name)))
            {
                return "NameIsInvalid".Translate();
            }
            return true;
        }

        protected override void SetName(string name)
        {
            if (Find.AnyPlayerHomeMap != null)
            {
                Find.AnyPlayerHomeMap.GetComponent<MapComponent_LocalCultTracker>().Get.CultName = name;
            }
            else
            {
                Log.Error("Oh no!");
            }
        }
    }
}
