﻿// ----------------------------------------------------------------------
// These are basic usings. Always let them be here.
// ----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

// ----------------------------------------------------------------------
// These are RimWorld-specific usings. Activate/Deactivate what you need:
// ----------------------------------------------------------------------
using UnityEngine;         // Always needed
//using VerseBase;         // Material/Graphics handling functions are found here
using Verse;               // RimWorld universal objects are here (like 'Building')
using Verse.AI;          // Needed when you do something with the AI
using Verse.AI.Group;
using Verse.Sound;       // Needed when you do something with Sound
using Verse.Noise;       // Needed when you do something with Noises
using RimWorld;            // RimWorld specific functions are found here (like 'Building_Battery')
using RimWorld.Planet;   // RimWorld specific functions for world creation
using CultOfCthulhu;
//using RimWorld.SquadAI;  // RimWorld specific functions for squad brains 

namespace CultOfCthulhu
{
    [StaticConstructorOnStartup]
    public class ITab_AltarWorshipCardUtility
    {
        public static Vector2 TempleCardSize = new Vector2(500f, 250f);

        public static void DrawTempleCard(Rect rect, Building_SacrificialAltar altar)
        {
            GUI.BeginGroup(rect);
            //            Rect rect2 = new Rect(rect.x, rect.y + 20f, 570f, 55f);

            float cultLabelWidth = Text.CalcSize(altar.Map.GetComponent<MapComponent_LocalCultTracker>().Get.CultName).x + 15;

            Rect rect1 = new Rect(rect);
            rect1 = rect.ContractedBy(14f);
            rect1.height = 30f;

            Text.Font = GameFont.Medium;
            Widgets.Label(rect1, altar.RoomName);
            Text.Font = GameFont.Small;

            ITab_CardUtility.DrawRename(altar);

            Rect rect2 = new Rect(rect1);
            rect2.yMin = rect1.yMax + 10;
            rect2.height = 25f;
            //rect2.xMin += 5f;
            rect2.width = cultLabelWidth + 5;
            //rect2.yMax -= 38f;
            Widgets.Label(rect2, altar.Map.GetComponent<MapComponent_LocalCultTracker>().Get.CultName);
            if (Mouse.IsOver(rect2))
            {
                Widgets.DrawHighlight(rect2);
            }
            if (Mouse.IsOver(rect2) && Event.current.type == EventType.MouseDown)
            {
                Find.WindowStack.Add(new Dialog_RenameCult());
            }

            Widgets.DrawLineHorizontal(rect2.x - 10, rect2.yMax, rect.width - 15f);

            Rect rectMain = new Rect(0 + 15f, 0 + 30f, 535f, 55f);
            
            Rect rect4 = rectMain;
            //rect4.y += 35f;
            rect4.yMin = rectMain.yMax + 5f;
            rect4.y = rectMain.yMax + 20f;
            rect4.x += 5f;
            //rect4.x -= (rectMain.x - 5);
            rect4.width = 200f;
            rect4.height = 25f;
            Widgets.Label(rect4, "Deity".Translate() + ": ");
            rect4.xMin = rect4.center.x;
            string label4 = DeityLabel(altar);
            if (Widgets.ButtonText(rect4, label4, true, false, true))
            {
                ITab_AltarWorshipCardUtility.OpenDeitySelectMenu(altar);
            }
            TooltipHandler.TipRegion(rect4, "DeityDesc".Translate());


            ITab_CardUtility.DrawDeity(altar.tempCurrentWorshipDeity, rect4, null, -30f);
            
            Rect rect5 = rect4;
            rect5.y += 35f;
            //rect5.y = rect4.yMax + 30f;
            rect5.x -= (rect4.x - 5);
            rect5.x += 15f;
            rect5.width = 200f;
            //rect5.height = 25f;
            Widgets.Label(rect5, "Preacher".Translate() + ": ");
            rect5.xMin = rect5.center.x;
            string label2 = PreacherLabel(altar);
            if (Widgets.ButtonText(rect5, label2, true, false, true))
            {
                ITab_AltarWorshipCardUtility.OpenPreacherSelectMenu(altar);
            }
            TooltipHandler.TipRegion(rect5, "PreacherDesc".Translate());

            Rect rect6 = rect5;
            rect6.y += 35;
            rect6.width = 200f;
            rect6.x -= (rect5.x - 5);
            rect6.x += 15f;
            bool disabled = (altar.tempCurrentWorshipDeity == null);
            Widgets.CheckboxLabeled(rect6, "MorningSermons".Translate(), ref altar.OptionMorning, disabled);
            if (Mouse.IsOver(rect6) && Event.current.type == EventType.MouseDown && !disabled)
            {
                altar.TryChangeWorshipValues(Building_SacrificialAltar.ChangeWorshipType.MorningWorship, altar.OptionMorning);
            }
            Rect rect7 = rect6;
            rect7.y += 30f;
            Widgets.CheckboxLabeled(rect7, "EveningSermons".Translate(), ref altar.OptionEvening, disabled);
            if (Mouse.IsOver(rect7) && Event.current.type == EventType.MouseDown && !disabled)
            {
                altar.TryChangeWorshipValues(Building_SacrificialAltar.ChangeWorshipType.EveningWorship, altar.OptionEvening);
            }

            TooltipHandler.TipRegion(rect6, "MorningSermonsDesc".Translate());
            TooltipHandler.TipRegion(rect7, "EveningSermonsDesc".Translate());
            GUI.EndGroup();
        }
        

        private static string PreacherLabel(Building_SacrificialAltar altar)
        {
            if (altar.tempPreacher == null)
            {
                altar.tempPreacher = CultUtility.DetermineBestPreacher(altar.Map);
                if (altar.tempPreacher == null) return "None";
                return altar.tempPreacher.NameStringShort;
            }
            else
            {
                return altar.tempPreacher.NameStringShort;
            }
        }

        private static string DeityLabel(Building_SacrificialAltar altar)
        {
            if (altar.tempCurrentWorshipDeity == null)
            {
                return "None";
            }
            else
            {
                return altar.tempCurrentWorshipDeity.LabelCap;
            }
        }

        private static string DeityDescription(Building_SacrificialAltar altar)
        {
            if (altar.tempCurrentWorshipDeity == null)
            {
                return "None";
            }
            else
            {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.Append(altar.tempCurrentWorshipDeity.def.description);
                return stringBuilder.ToString();
            }
        }
        
        public static void OpenPreacherSelectMenu(Building_SacrificialAltar altar)
        {
            List<FloatMenuOption> list = new List<FloatMenuOption>();
            list.Add(new FloatMenuOption("(" + "Auto".Translate() + ")", delegate
            {
                altar.tempPreacher = CultUtility.DetermineBestPreacher(altar.Map);
            }, MenuOptionPriority.Default, null, null, 0f, null));

            foreach (Pawn current in altar.Map.GetComponent<MapComponent_LocalCultTracker>().Get.CultMembers)
            {
                if (current.health.capacities.CapableOf(PawnCapacityDefOf.Talking) &&
                    current.health.capacities.CapableOf(PawnCapacityDefOf.Moving))
                {
                    Action action;
                    Pawn localCol = current;
                    action = delegate
                    {

                        //Map.GetComponent<MapComponent_SacrificeTracker>().lastUsedAltar = altar;
                        altar.tempPreacher = localCol;
                    };
                    list.Add(new FloatMenuOption(localCol.LabelShort, action, MenuOptionPriority.Default, null, null, 0f, null));
                }
            }
            Find.WindowStack.Add(new FloatMenu(list));
        }


        public static void OpenDeitySelectMenu(Building_SacrificialAltar altar)
        {
            List<FloatMenuOption> list = new List<FloatMenuOption>();
            list.Add(new FloatMenuOption("(" + "NoneLower".Translate() + ")", delegate
            {
                //Map.GetComponent<MapComponent_SacrificeTracker>().lastUsedAltar = altar;
                altar.tempCurrentWorshipDeity = null;
            }, MenuOptionPriority.Default, null, null, 0f, null));

            foreach (CosmicEntity current in Cthulhu.UtilityWorldObjectManager.GetUtilityWorldObject<UtilityWorldObject_CosmicDeities>().DeityCache.Keys)
            {
                if (!current.discovered) continue;
                Action action;
                CosmicEntity localDeity = current;
                action = delegate
                {

                    //Map.GetComponent<MapComponent_SacrificeTracker>().lastUsedAltar = altar;
                    altar.tempCurrentWorshipDeity = localDeity;
                    //altar.tempCurrentSpell = null;
                };
                list.Add(new FloatMenuOption(localDeity.LabelCap, action, MenuOptionPriority.Default, null, null, 0f, null));
            }
            Find.WindowStack.Add(new FloatMenu(list));
        }

    }
}
