﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;

namespace CultOfCthulhu
{
    class ITab_CardUtility
    {
        public static void DrawRename(Building_SacrificialAltar altar)
        {
            Rect rectRename = new Rect(ITab_AltarWorshipCardUtility.TempleCardSize.x - 85f, 0f, 30f, 30f);
            TooltipHandler.TipRegion(rectRename, "RenameTemple".Translate());
            if (Widgets.ButtonImage(rectRename, Buttons.RenameTex))
            {
                Find.WindowStack.Add(new Dialog_RenameTemple(altar));
            }
        }

        public static void DrawDeity(CosmicEntity entity, Rect rect3, string spellDescription=null, float offset=0f)
        {
            string entityLabel = "";
            string entityDescrip = "";
            if (entity != null)
            {
                entityLabel = entity.LabelCap;
                entityDescrip = entity.def.description;
            }

            Rect secondBox = rect3;
            secondBox.x += rect3.x + 10f + 30f + offset;
            secondBox.xMax += 125f;
            secondBox.height = 35f;
            Text.Font = GameFont.Medium;
            Widgets.Label(secondBox, entityLabel);
            Text.Font = GameFont.Small;
            Rect secondBoxUnder = secondBox;
            secondBoxUnder.y += 40f;
            secondBoxUnder.width -= 15f;
            secondBoxUnder.height = 70f;
            Widgets.Label(secondBoxUnder, entityDescrip);
            ITab_CardUtility.DrawTier(entity, new Vector2(secondBoxUnder.x, secondBoxUnder.y + 35f));
            Rect secondBoxUnder2 = secondBoxUnder;
            secondBoxUnder2.y += 70;
            secondBoxUnder2.height = 250f;
            if (spellDescription != null)
                Widgets.Label(secondBoxUnder2, spellDescription);

        }

        // RimWorld.SkillUI//
        public static void DrawTier(CosmicEntity entity, Vector2 topLeft)
        {
            if (entity == null) return;
            string tierLabel = entity.PlayerTier.ToString();
            string standingLabel = "Standing".Translate() + ":";
            float tierLabelWidth = Text.CalcSize(standingLabel).x;
            float tierCurrentVal = entity.PlayerFavor;
            float tierCurrentMax = entity.currentTierMax;
            float tierPrevMax = entity.prevTierMax;
            Rect rect = new Rect(topLeft.x, topLeft.y, 150f, 24f);
            if (Mouse.IsOver(rect))
            {
                GUI.DrawTexture(rect, TexUI.HighlightTex);
            }
            GUI.BeginGroup(rect);
            Text.Anchor = TextAnchor.MiddleLeft;
            Rect rect2 = new Rect(0f, 0f, tierLabelWidth + 5f, rect.height);
            Widgets.Label(rect2, standingLabel);
            Rect position = new Rect(rect2.xMax, 0f, 10f, 24f);
            Rect rect3 = new Rect(position.xMax, 0f, rect.width - position.xMax, rect.height);
            Widgets.FillableBar(rect3, (tierCurrentVal - tierPrevMax) / (tierCurrentMax - tierPrevMax), Buttons.TierBarFillTex, null, false);
            Rect rect4 = new Rect(position.xMax + 4f, 0f, 999f, rect.height);
            //rect4.yMin += 10f;
            rect4.yMax += 18f;
            string label = entity.TierString;
            GenUI.SetLabelAlign(TextAnchor.MiddleLeft);
            Widgets.Label(rect4, label);
            GenUI.ResetLabelAlign();
            GUI.color = Color.white;
            GUI.EndGroup();
            TooltipHandler.TipRegion(rect, new TipSignal(GetFavorDescription(entity), entity.def.GetHashCode() * 397945));
        }

        // RimWorld.SkillUI
        private static string GetFavorDescription(CosmicEntity entity)
        {
            StringBuilder stringBuilder = new StringBuilder();
            if (entity == null)
            {
                stringBuilder.Append("DisabledLower".Translate().CapitalizeFirst());
            }
            else
            {
                stringBuilder.AppendLine(string.Concat(new object[]
                {
            "Tier".Translate(),
            " ",
            entity.PlayerTier,
            ": ",
            entity.TierString
                }));
                if (Current.ProgramState == ProgramState.Playing)
                {
                    string text = (entity.PlayerTier != CosmicEntity.Tier.Final) ? "ProgressToNextLevel".Translate() : "Favor".Translate();
                    stringBuilder.AppendLine(string.Concat(new object[]
                    {
                text,
                ": ",
                entity.PlayerFavor.ToString("F"),
                " / ",
                entity.currentTierMax.ToString("F")
                    }));
                }
            }
            stringBuilder.AppendLine();
            stringBuilder.AppendLine();
            stringBuilder.Append("FavorDescription".Translate());
            return stringBuilder.ToString();
        }


    }
}
