﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using Verse;
using Verse.AI;

namespace CultOfCthulhu
{
    class IncidentWorker_CultSeed_NightmareTree : IncidentWorker
    {
        protected override bool CanFireNowSub(IIncidentTarget target)
        {
            Map map = target as Map;
            if (map.GetComponent<MapComponent_LocalCultTracker>().Get.CurrentSeedState > CultSeedState.NeedSeed) return false;
            else return true;
        }

        public override bool TryExecute(IncidentParms parms)
        {
            Map map = parms.target as Map;
            //Create a spawn point for our nightmare Tree
            IntVec3 intVec;
            if (!ShipChunkDropCellFinder.TryFindShipChunkDropCell(map.Center, map, 999999, out intVec))
            {
                return false;
            }

            //Spawn in the nightmare tree.
            Plant thing = (Plant)ThingMaker.MakeThing(CultDefOfs.PlantTreeNightmare, null);
            thing.Growth = 1f;
            GenPlace.TryPlaceThing(thing, intVec.RandomAdjacentCell8Way(), map, ThingPlaceMode.Near);

            //Find the best researcher
            Pawn researcher = CultUtility.DetermineBestResearcher(map);

            //Clear all jobs for the researcher.
            //Give them a new job to investigate the nightmare tree.
            Job J = new Job(CultDefOfs.Investigate, researcher, thing);
            researcher.QueueJob(J);
            researcher.jobs.EndCurrentJob(JobCondition.InterruptForced);

            Cthulhu.UtilityWorldObjectManager.GetUtilityWorldObject<UtilityWorldObject_GlobalCultTracker>().currentSeedState = CultSeedState.NeedSeeing;
            map.GetComponent<MapComponent_LocalCultTracker>().Get.CurrentSeedPawn = researcher;
            map.GetComponent<MapComponent_LocalCultTracker>().Get.CurrentSeedTarget = thing;
            
            return true;
        }
    }
}
