﻿using System;
using Verse;
using RimWorld;
using System.Collections.Generic;

namespace CultOfCthulhu
{
    /// <summary>
    /// Cultist shares ideas with a non-cultist for massive failure.
    /// </summary>
    public class InteractionWorker_SafePreach : InteractionWorker
    {

        //How great the effect is on the cultminded values.
        public const float CULTMINDED_EFFECT_MIN = 0.025f;
        public const float CULTMINDED_EFFECT_MAX = 0.05f;

        //Very common interaction
        private const float BaseSelectionWeight = 1f;

        public override void Interacted(Pawn initiator, Pawn recipient, List<RulePackDef> extraSentencePacks)
        {
            base.Interacted(initiator, recipient, extraSentencePacks);
            CultUtility.AffectCultMindedness(recipient, Rand.Range(CULTMINDED_EFFECT_MIN, CULTMINDED_EFFECT_MAX));
            CultUtility.AffectCultMindedness(initiator, Rand.Range(CULTMINDED_EFFECT_MIN, CULTMINDED_EFFECT_MAX));
        }

        public override float RandomSelectionWeight(Pawn initiator, Pawn recipient)
        {
            if (!initiator.IsColonist) return 0f;
            if (!recipient.IsColonist) return 0f;
            if (CultUtility.IsCultMinded(recipient)) return 0f;
            if (!CultUtility.IsCultMinded(initiator)) return 0f;
            if (initiator.relations.OpinionOf(recipient) > 0) return Rand.Range(0.8f, 1f);
            return 0f;
        }
    }
}
