﻿// ----------------------------------------------------------------------
// These are basic usings. Always let them be here.
// ----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

// ----------------------------------------------------------------------
// These are RimWorld-specific usings. Activate/Deactivate what you need:
// ----------------------------------------------------------------------
using UnityEngine;         // Always needed
//using VerseBase;         // Material/Graphics handling functions are found here
using Verse;               // RimWorld universal objects are here (like 'Building')
using Verse.AI;          // Needed when you do something with the AI
using Verse.AI.Group;
using Verse.Sound;       // Needed when you do something with Sound
using Verse.Noise;       // Needed when you do something with Noises
using RimWorld;            // RimWorld specific functions are found here (like 'Building_Battery')
using RimWorld.Planet;   // RimWorld specific functions for world creation
//using RimWorld.SquadAI;  // RimWorld specific functions for squad brains 

namespace CultOfCthulhu
{
    public class JobDriver_AttendSacrifice : JobDriver
    {

        private TargetIndex Executioner = TargetIndex.A;
        private TargetIndex Build = TargetIndex.B;
        private TargetIndex Spot = TargetIndex.C;

        protected Building_SacrificialAltar Altar
        {
            get
            {
                return (Building_SacrificialAltar)base.CurJob.GetTarget(TargetIndex.B).Thing;
            }
        }


        protected Pawn ExecutionerPawn
        {
            get
            {
                return (Pawn)base.CurJob.GetTarget(TargetIndex.A).Thing;
            }
        }

        public override void ExposeData()
        {
            base.ExposeData();
        }


        private string report = "";
        public override string GetReport()
        {
            if (report != "")
            {
                return base.ReportStringProcessed(report);
            }
            return base.GetReport();
        }

        //protected Building_SacrificialAltar ClosestAltar()
        //{
        //    Building_SacrificialAltar result = null;
        //    IntVec3 thisPosition = pawn.Position;

        //    Predicate<Thing> predicate = delegate (Thing t) {
        //        if (t == null) return false;
        //        if (!t.Spawned) return false;
        //        Building_SacrificialAltar altar = t as Building_SacrificialAltar;
        //        if (altar == null) return false;
        //        if (altar.Faction == null) return false;
        //        if (altar.Faction != null && this.pawn.Faction != null)
        //        {
        //            if (this.pawn.Faction != altar.Faction) return false;
        //        }
        //        return true;
        //    };
        //    Thing thing2 = GenClosest.ClosestThingReachable(thisPosition, this.pawn.Map, ThingRequest.ForGroup(ThingRequestGroup.Everything), PathEndMode.OnCell, TraverseParms.For(this.pawn, Danger.Deadly, TraverseMode.PassDoors, false), 15, predicate, null, 50, true);
        //    if (thing2 != null)
        //    {
        //        if (thing2 is Building_SacrificialAltar)
        //        {
        //            Building_SacrificialAltar foundAltar = thing2 as Building_SacrificialAltar;
        //            result = foundAltar;
        //        }
        //    }
        //    return result;
        //}

        protected override IEnumerable<Toil> MakeNewToils()
        {
            this.EndOnDespawnedOrNull(Executioner, JobCondition.Incompletable);
            this.EndOnDespawnedOrNull(Spot, JobCondition.Incompletable);
            this.EndOnDespawnedOrNull(Build, JobCondition.Incompletable);
            yield return Toils_Reserve.Reserve(Spot, this.CurJob.def.joyMaxParticipants);

            //Toil 1: Go to the area.
            Toil gotoExecutioner;
            if (this.TargetC.HasThing)
            {
                gotoExecutioner = Toils_Goto.GotoThing(Spot, PathEndMode.OnCell);
            }
            else
            {
                gotoExecutioner = Toils_Goto.GotoCell(Spot, PathEndMode.OnCell);
            }
            yield return gotoExecutioner;


            //Toil 2: 'Attend'
            var altarToil = new Toil();
            altarToil.defaultCompleteMode = ToilCompleteMode.Delay;
            altarToil.defaultDuration = this.CurJob.def.joyDuration;
            altarToil.AddPreTickAction(() =>
            {
                this.pawn.GainComfortFromCellIfPossible();
                if (report == "") report = "Attending sacrifice.";
            });
            altarToil.tickAction = delegate
            {
                //this.pawn.Drawer.rotator.Face(this.TargetA.CenterVector3);
                this.pawn.Drawer.rotator.FaceCell(this.TargetLocA);
            };
            yield return altarToil;
            yield return Toils_Jump.JumpIf(altarToil, () => ExecutionerPawn.CurJob.def.defName == "HoldSacrifice");

            //ToDo -- Add random Ia! Ia!
            yield return new Toil
            {
                initAction = delegate
                {
                    //Do something? Ia ia!
                },
                defaultCompleteMode = ToilCompleteMode.Instant
            };

            //Toil 3 Reflect on worship
            Toil reflectingTime = new Toil();
            reflectingTime.defaultCompleteMode = ToilCompleteMode.Delay;
            reflectingTime.defaultDuration = CultUtility.reflectDuration;
            //chantingTime.PlaySustainerOrSound(DefDatabase<SoundDef>.GetNamed("Estate_GramophoneWindup"));
            reflectingTime.AddPreTickAction(() =>
            {
                report = "Reflecting on sacrifice.";
            });
            yield return reflectingTime;

            //Toil 3 Reset the altar and clear variables.
            yield return new Toil
            {
                initAction = delegate
                {
                    if (Altar != null)
                    {
                        if (Altar.currentSacrificeState != Building_SacrificialAltar.SacrificeState.finished)
                        {
                            Altar.ChangeState(Building_SacrificialAltar.State.sacrificing, Building_SacrificialAltar.SacrificeState.finished);
                            //Map.GetComponent<MapComponent_SacrificeTracker>().ClearVariables();
                        }
                    }
                },
                defaultCompleteMode = ToilCompleteMode.Instant
            };


            this.AddFinishAction(() =>
            {
                //When the ritual is finished -- then let's give the thoughts
                if (Altar.currentSacrificeState == Building_SacrificialAltar.SacrificeState.finished)
                {
                    if (this.pawn == null) return;
                    CultUtility.AttendSacrificeTickCheckEnd(this.pawn);
                }
                if (this.TargetC.HasThing)
                {
                    if (this.pawn.Map.reservationManager.IsReserved(this.CurJob.targetC.Thing, Faction.OfPlayer))
                        this.pawn.Map.reservationManager.Release(this.CurJob.targetC.Thing, pawn);
                }
                else
                {
                    if (this.pawn.Map.reservationManager.IsReserved(this.CurJob.targetC.Cell, Faction.OfPlayer))
                        this.pawn.Map.reservationManager.Release(this.CurJob.targetC.Cell, this.pawn);
                }


            });
        }
    }
}
