﻿// ----------------------------------------------------------------------
// These are basic usings. Always let them be here.
// ----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

// ----------------------------------------------------------------------
// These are RimWorld-specific usings. Activate/Deactivate what you need:
// ----------------------------------------------------------------------
using UnityEngine;         // Always needed
//using VerseBase;         // Material/Graphics handling functions are found here
using Verse;               // RimWorld universal objects are here (like 'Building')
using Verse.AI;          // Needed when you do something with the AI
using Verse.AI.Group;
using Verse.Sound;       // Needed when you do something with Sound
using Verse.Noise;       // Needed when you do something with Noises
using RimWorld;            // RimWorld specific functions are found here (like 'Building_Battery')
using RimWorld.Planet;   // RimWorld specific functions for world creation
//using RimWorld.SquadAI;  // RimWorld specific functions for squad brains 

namespace CultOfCthulhu
{
    public class JobDriver_AttendWorship : JobDriver
    {
        private TargetIndex Preacher = TargetIndex.A;
        private TargetIndex Build = TargetIndex.B;
        private TargetIndex Spot = TargetIndex.C;

        protected Building_SacrificialAltar Altar
        {
            get
            {
                return (Building_SacrificialAltar)base.CurJob.GetTarget(TargetIndex.B).Thing;
            }
        }

        protected Pawn PreacherPawn
        {
            get
            {
                return (Pawn)base.CurJob.GetTarget(TargetIndex.A).Thing;
            }
        }

        public override void ExposeData()
        {
            base.ExposeData();
        }

        

        protected override IEnumerable<Toil> MakeNewToils()
        {

            this.AddEndCondition(delegate
            {
                if (PreacherPawn.CurJob.def.defName == "ReflectOnWorship")
                {
                    return JobCondition.Succeeded;
                }
                if (PreacherPawn.CurJob.def.defName != "HoldWorship")
                {
                    return JobCondition.Incompletable;
                }
                return JobCondition.Ongoing;
            });
            this.EndOnDespawnedOrNull(Preacher, JobCondition.Incompletable);
            this.EndOnDespawnedOrNull(Spot, JobCondition.Incompletable);
            this.EndOnDespawnedOrNull(Build, JobCondition.Incompletable);
            yield return Toils_Reserve.Reserve(Spot, this.CurJob.def.joyMaxParticipants);
            Toil gotoPreacher;
            if (this.TargetC.HasThing)
            {
                gotoPreacher = Toils_Goto.GotoThing(Spot, PathEndMode.OnCell);
            }
            else
            {
                gotoPreacher = Toils_Goto.GotoCell(Spot, PathEndMode.OnCell);
            }
            yield return gotoPreacher;
            
            var altarToil = new Toil();
            altarToil.defaultCompleteMode = ToilCompleteMode.Delay;
            altarToil.defaultDuration = this.CurJob.def.joyDuration;
            altarToil.AddPreTickAction(() =>
            {
                this.pawn.GainComfortFromCellIfPossible();
            });
            altarToil.tickAction = delegate
            {
                //this.pawn.Drawer.rotator.Face(this.TargetA.CenterVector3);
                this.pawn.Drawer.rotator.FaceCell(this.TargetLocA);
            };
            yield return altarToil;
            yield return Toils_Jump.JumpIf(altarToil, () => PreacherPawn.CurJob.def.defName == "HoldWorship");


            this.AddFinishAction(() =>
            {
                //When the ritual is finished -- then let's give the thoughts
                if (Altar.currentWorshipState == Building_SacrificialAltar.WorshipState.finishing ||
                    Altar.currentWorshipState == Building_SacrificialAltar.WorshipState.finished)
                {
                        CultUtility.AttendWorshipTickCheckEnd(PreacherPawn, this.pawn);
                        Cthulhu.Utility.DebugReport("Called end tick check");
                    }
                if (this.TargetC.HasThing)
                {
                    if (Map.reservationManager.IsReserved(this.CurJob.targetC.Thing, Faction.OfPlayer))
                        Map.reservationManager.Release(this.CurJob.targetC.Thing, pawn);
                }
                else
                {
                    if (Map.reservationManager.IsReserved(this.CurJob.targetC.Cell, Faction.OfPlayer))
                        Map.reservationManager.Release(this.CurJob.targetC.Cell, this.pawn);
                }


            });
        }
    }
}
