﻿// ----------------------------------------------------------------------
// These are basic usings. Always let them be here.
// ----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

// ----------------------------------------------------------------------
// These are RimWorld-specific usings. Activate/Deactivate what you need:
// ----------------------------------------------------------------------
using UnityEngine;         // Always needed
//using VerseBase;         // Material/Graphics handling functions are found here
using Verse;               // RimWorld universal objects are here (like 'Building')
using Verse.AI;          // Needed when you do something with the AI
using Verse.AI.Group;
using Verse.Sound;       // Needed when you do something with Sound
using Verse.Noise;       // Needed when you do something with Noises
using RimWorld;            // RimWorld specific functions are found here (like 'Building_Battery')
using RimWorld.Planet;   // RimWorld specific functions for world creation
//using RimWorld.SquadAI;  // RimWorld specific functions for squad brains 


namespace CultOfCthulhu
{
    public class SpellWorker_Reincarnation : SpellWorker
    {
        protected Corpse corpse(Map map)
        {
                Corpse c = map.thingGrid.ThingAt<Corpse>(altar(map).Position);
                return c;
        }

        protected override bool CanFireNowSub(IIncidentTarget target)
        {

            //Cthulhu.Utility.DebugReport("
            //: " + this.def.defName);
            return true;
        }

        public override bool TryExecute(IncidentParms parms)
        {
            Map map = parms.target as Map;
            IntVec3 pos = altar(map).Position;
            Pawn exSacrifice = corpse(map).InnerPawn;
            Corpse deadBody = corpse(map);

            //Deconstruct the altar
            altar(map).Destroy(DestroyMode.Deconstruct);

            //Throw some smoke
            MoteMaker.ThrowDustPuff(pos, map, 2f);

            Building_TreeOfMadness tree = (Building_TreeOfMadness)ThingMaker.MakeThing(CultDefOfs.PlantTreeNightmare);
            tree.Growth = 1;
            tree.Age = exSacrifice.ageTracker.AgeBiologicalYears;
            deadBody.Strip();
            GenSpawn.Spawn(tree, pos, map);
            deadBody.DeSpawn();
            Cthulhu.Utility.ApplyTaleDef("SpellReincarnation", deadBody.InnerPawn);
            return true;
        }
    }
}
