﻿using RimWorld.Planet;
using System;
using System.Collections.Generic;
using System.Reflection;
using Verse;

namespace RimFridge
{
    internal class CompFrosty : ThingComp
    {
        public float Temp = 21f;

        public CompProperties_Frosty Props
        {
            get
            {
                return (CompProperties_Frosty)this.props;
            }
        }

        public override void PostIngested(Pawn ingester)
        {
            base.PostIngested(ingester);
            bool flag = this.Temp < 5f;
            if (flag)
            {
                ingester.needs.mood.thoughts.memories.TryGainMemoryThought(this.Props.thought, null);
            }
        }

        public override void PostSplitOff(Thing piece)
        {
            ThingWithComps thingWithComps = piece as ThingWithComps;
            bool flag = ThingCompUtility.TryGetComp<CompFrosty>(thingWithComps) == null;
            if (flag)
            {
                CompFrosty compFrosty = new CompFrosty();
                thingWithComps.AllComps.Add(compFrosty);
                compFrosty.props = CompProperties_Frosty.Beer;
                compFrosty.parent = thingWithComps;
                compFrosty.Temp = this.Temp;
                ((TickList)typeof(TickManager).GetField("tickListRare", BindingFlags.Instance | BindingFlags.NonPublic).GetValue(Find.TickManager)).RegisterThing(thingWithComps);
            }
        }

        public override void CompTickRare()
        {
            base.CompTickRare();
            float num;
            List<Thing> list;
            if (this.parent.Spawned)
            {
                // On map
                num = GridsUtility.GetTemperature(this.parent.Position, this.parent.Map);
                list = this.parent.Map.thingGrid.ThingsListAtFast(this.parent.PositionHeld);
            }
            else
            {
                if (this.parent.holdingContainer == null)/* ERROR */ return;
                Pawn owner = this.parent.holdingContainer.owner as Pawn;
                if (owner == null)/* ERROR */return;
                if (!GenTemperature.TryGetTemperatureAtCellOrCaravanTile(owner, out num))
                {
                    /* ERROR */
                    return;
                }
                list = new List<Thing>();
            }
            for (int i = 0; i < list.Count; i++)
            {
                bool flag = list[i] is Building_Refrigerator;
                if (flag)
                {
                    Building_Refrigerator building_Refrigerator = list[i] as Building_Refrigerator;
                    num = building_Refrigerator.Temp;
                    break;
                }
            }
            this.Temp += (num - this.Temp) * 0.05f;
        }

        public override string CompInspectStringExtra()
        {
            return (this.Temp < 5f) ? "Frosty\n".Trim() : "".Trim();
        }
    }
}
