﻿using System.Linq;
using System.Reflection;
using Verse;

namespace ImprovedIncreasedStack
{
    [StaticConstructorOnStartup]
    internal static class ImprovedIncreasedStack
    {
        static ImprovedIncreasedStack()
        {
            LongEventHandler.QueueLongEvent(Inject, "Initializing", true, null);
        }

        private static Assembly Assembly
        {
            get { return Assembly.GetAssembly(typeof (ImprovedIncreasedStack)); }
        }

        private static string AssemblyName
        {
            get { return Assembly.FullName.Split(',').First(); }
        }

        private static void Inject()
        {
            InjectDefs();
            Log.Message(AssemblyName + " injected.");
        }

        private static void InjectDefs()
        {
            var defs = DefDatabase<ThingDef>.AllDefs.Where(IsNeedIncreaedStack).ToList();
            foreach (var thingDef in defs)
            {
                thingDef.stackLimit = thingDef.stackLimit*10;
                //Log.Warning(thingDef.defName + ":" + thingDef.stackLimit);
            }
        }

        public static bool IsNeedIncreaedStack(ThingDef d)
        {
            return d.IsStuff || d.category == ThingCategory.Item && !d.isUnfinishedThing && !d.IsCorpse && !d.destroyOnDrop && !d.IsRangedWeapon && !d.IsApparel && d.stackLimit > 1;
        }
    }
}