﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using System.IO;
using Verse;



namespace RimWorld{
public class Apparel : ThingWithComps
{
	//Links
	public Pawn wearer;

	//Working vars
	private bool	wornByCorpseInt = false;

	//Properties
	public bool WornByCorpse{get{return wornByCorpseInt;}}


	public void Notify_Stripped(Pawn pawn)
	{
		if( pawn.Dead && def.apparel.careIfWornByCorpse )
			wornByCorpseInt = true;
	}

	public override void ExposeData()
	{
		base.ExposeData();
		Scribe_Values.LookValue( ref wornByCorpseInt, "wornByCorpse" );
	}

	public virtual void DrawWornExtras()
	{
	}

	public virtual bool CheckPreAbsorbDamage(DamageInfo dinfo)
	{
		return false;
	}

	public virtual bool AllowVerbCast(IntVec3 root, TargetInfo targ)
	{
		return true;
	}

	public virtual IEnumerable<Gizmo> GetWornGizmos()
	{
		yield break;
	}

	public override void Destroy(DestroyMode mode = DestroyMode.Vanish)
	{
		base.Destroy(mode);

		if( Destroyed && wearer != null )
			wearer.apparel.Notify_WornApparelDestroyed(this);
	}

	public override string GetInspectString()
	{
		string s = base.GetInspectString();
		if( WornByCorpse )
			s += "WasWornByCorpse".Translate();
		return s;
	}

	public virtual float GetSpecialApparelScoreOffset()
	{
		return 0;
	}
}
}
