﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;

namespace Verse.AI{
public class JobDriver_CastVerbOnce : JobDriver
{
	public override string GetReport()
	{
		string targetLabel;
		if( TargetA.HasThing )
			targetLabel = TargetThingA.LabelCap;
		else
			targetLabel = "AreaLower".Translate();

		return "UsingVerb".Translate(CurJob.verbToUse.verbProps.label,  targetLabel);
	}

	protected override IEnumerable<Toil> MakeNewToils()
	{
		yield return Toils_Combat.GotoCastPosition( TargetIndex.A );

		yield return Toils_Combat.CastVerb( TargetIndex.A );
	}

}}

