﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using UnityEngine;
using Verse;
using static static_quality.MapComponent_SQ;

namespace static_quality
{
    internal class static_quality_Config_Tab : MainTabWindow
    {

        public override Vector2 InitialSize
        {
            get
            {
                return new Vector2(380, 600);
            }
        }

        public override void DoWindowContents(Rect canvas)
        {
            Listing_Standard listing_Standard = new Listing_Standard(canvas);
            //            listing_Standard.
            //            listing_Standard.set_ColumnWidth(rect.get_width() - 4f);
            listing_Standard.Label("物品品质设置:");
            listing_Standard.Gap(12f);
            bool[] qs = new bool[4];
            qs[0] = listing_Standard.RadioButton("默认品质", (settings.quality_switch == 0), 0f);
            qs[1] = listing_Standard.RadioButton("稳定品质", (settings.quality_switch == 1), 0f);
            qs[2] = listing_Standard.RadioButton("稳定品质 +/- 1", (settings.quality_switch == 2), 0f);
            qs[3] = listing_Standard.RadioButton("稳定品质 +/- 2", (settings.quality_switch == 3), 0f);
            listing_Standard.Gap(24f);
            bool[] ss = new bool[4];
            listing_Standard.Label("技能退化设置:");
            listing_Standard.Gap(12f);
            ss[0] = listing_Standard.RadioButton("默认退化速度", (settings.skill_switch == 0), 0f);
            ss[1] = listing_Standard.RadioButton("一半退化速度", (settings.skill_switch == 1), 0f);
            ss[2] = listing_Standard.RadioButton("缓慢退化速度", (settings.skill_switch == 2), 0f);
            ss[3] = listing_Standard.RadioButton("不会退化", (settings.skill_switch == 3), 0f);
            listing_Standard.Gap(12f);
            string text_nd = "技能等级不降低";
            listing_Standard.CheckboxLabeled(text_nd, ref settings.no_delevel, "技能等级不会因技能退化而降低");
            listing_Standard.Gap(12f);
            string text_ls = "每日学习经验上限";
            listing_Standard.CheckboxLabeled(text_ls, ref settings.learning_saturation_tweak, "每日学习经验上限从固定的4000改为 技能等级*500 + 1000");
            listing_Standard.Gap(24f);
            listing_Standard.Label("技能兴趣设置:");
            listing_Standard.Gap(12f);
            string text_pt = "技能兴趣调整";
            listing_Standard.CheckboxLabeled(text_pt, ref settings.passion_tweak, "技能学习速度从0.33、1、1.5改为1、1.25、1.5");
            //listing_Standard.Gap(12f);
            string text_pg = "技能兴趣升级";
            listing_Standard.CheckboxLabeled(text_pg, ref settings.passion_gain, "技能升级可能会提升对此技能的兴趣");
            //listing_Standard.Gap(12f);
            string text_pc = "技能兴趣限额";
            listing_Standard.CheckboxLabeled(text_pc, ref settings.passion_cap, "一个单位最多可以有4个特别感兴趣的技能，在一个技能中提升兴趣会降低随机技能的兴趣");
            listing_Standard.Gap(12f);
            listing_Standard.Label("杂项设定:");
            listing_Standard.Gap(12f);
            string text_pr = "植物休息开启";
            listing_Standard.CheckboxLabeled(text_pr, ref settings.plant_rest, "关闭此选项，植物会24小时不停生长");
            listing_Standard.Gap(12f);


            for (int i = 0; i < (qs.Length); ++i)
            {
                if (qs[i])
                {
                    settings.quality_switch = i;
                    break;
                }
            }
            for (int i = 0; i < (ss.Length); ++i)
            {
                if (ss[i])
                {
                    settings.skill_switch = i;
                    break;
                }
            }

            listing_Standard.End();
            //listing_Standard.RadioButton(string label, bool active, [float tabIn]);
            //            return listing_Standard.get_CurHeight();
        }

        public override void PostClose()
        {
            base.PostClose();
            this.forcePause = false;
        }

        public override void PostOpen()
        {
            base.PostOpen();
        }

        public override void PreClose()
        {
            base.PreClose();
        }

        public override void PreOpen()
        {
            base.PreOpen();
            this.forcePause = true;
        }

    }
}