#include "skse64/NiRTTI.h"
#include "skse64/NiObjects.h"

NiObject * DoNiRTTICast(NiObject * src, const NiRTTI * typeInfo)
{
	uintptr_t typeAddr = uintptr_t(typeInfo) + RelocationManager::s_baseAddr;
	if (src)
		for (NiRTTI * iter = src->GetRTTI(); iter; iter = iter->parent)
			if (iter == (NiRTTI *)typeAddr)
				return src;

	return nullptr;
}

const NiRTTI *	NiRTTI_BSDismemberSkinInstance = (NiRTTI *)0x02F88350;
#ifdef FIXME
const NiRTTI *	NiRTTI_BGSDecalNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSAnimGroupSequence = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSplatterExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BGSAddonNodeSoundHandleExtra = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_REFRSyncController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCartTether = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkTiltPreventAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkWheelAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenAnimationData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenModelExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenBaseMorphExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenMorphData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHead = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHair = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFaceGenNiNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffect = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffectDebris = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffectGeometryDecal = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffectParticle = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffectSimpleDecal = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempEffectSPG = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAutoWater = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_ModelReferenceEffect = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_ReferenceEffect = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_ShaderReferenceEffect = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_SummonPlacementEffect = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_SceneGraph = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDoorHavokController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPlayerDistanceCheckController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSimpleScaleController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_DebugTextExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiControllerManager = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiControllerSequence = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiMultiTargetTransformController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiInterpController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiTargetTreadTransfController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiColorData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiColorInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiGeomMorpherController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPathInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTransformInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSingleInterpController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendTransformInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendFloatInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatExtraDataController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendAccumTransformInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTransformController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBlendTreadTransfInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiKeyBasedInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiMorphData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPosData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTransformData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFrustumFOVController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTreadTransfInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSRotAccumTransfInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLookIKNote = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSGrabIKNote = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSAnimNote = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSAnimNotes = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiVisController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiUVData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiUVController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTextKeyExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiStringPalette = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSequenceStreamHelper = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSequence = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRotData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRollController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiQuaternionInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPoint3Interpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPathController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLookAtInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLookAtController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLightDimmerController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLightColorController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiKeyframeManager = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatsExtraDataPoint3Controller = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatsExtraDataController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiColorExtraDataController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineTransformInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplinePoint3Interpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineFloatInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineCompTransformInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineCompPoint3Interpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineCompFloatInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineCompColorInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineColorInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineBasisData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBoolTimelineInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBoolInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBoolData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBoneLODController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendQuaternionInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendPoint3Interpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendColorInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBlendBoolInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiExtraDataController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatInterpController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBoolInterpController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPoint3InterpController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSplineInterpolator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAVObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiObjectNET = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSwitchNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiStringsExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRenderer = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiCamera = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriStrips = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAlphaProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLight = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAdditionalGeometryData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSourceTexture = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDismemberSkinInstance = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiStringExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFlattenedBoneTree = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTimeController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiGeometryData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPointLight = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriShapeData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPackedAdditionalGeometryData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLines = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTexture = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDefaultAVObjectPalette = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBillboardNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDirectionalLight = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPixelData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiCullingProcess = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSkinPartition = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSkinInstance = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSkinData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriStripsData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSegmentedTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSegmentedLandTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiParticles = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiScreenElementsData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiScreenElements = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAVObjectPalette = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiGeometry = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatsExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiColorExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriBasedGeom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiVertWeightsExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriBasedGeomData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiLinesData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPalette = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiParticlesData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLODTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiVectorExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriStripsDynamicData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiTriShapeDynamicData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSwitchStringExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSpotLight = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiSourceCubeMap = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiShadeProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPersistentSrcTextureRendererData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiParticleMeshesData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiParticleMeshes = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiIntegersExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiIntegerExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFogProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiFloatExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSPNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBooleanExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBinaryExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAmbientLight = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAlphaAccumulator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBackToFrontAccumulator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiAccumulator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBound = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundOBB = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundAABB = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundRoom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSXFlags = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSValueNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempNodeManager = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTempNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSRangeNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSOcclusionShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSWindModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBlastNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDebrisNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDamageStage = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysArrayEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_PArrayPoint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSCullingProcess = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiStreamInstanceTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundSphere = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSOcclusionPlane = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSOcclusionBox = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPortal = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPortalSharedNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBehaviorGraphExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBodyMorphOffsetsExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiBSBoneLODController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParticleSystemManager = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFurnitureMarkerNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBound = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSAnimInteractionMarker = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBoneMap = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysMultiTargetEmitterCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSceneGraph = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSGeometryListCullingProcess = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSProceduralLightningController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSInvMarker = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSReference = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSNodeReferences = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSNonUniformScaleExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLagBoneController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBoneLODExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysScaleModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysSubTexModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysStripUpdateModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiBoundCapsule = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMasterParticleSystem = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSWArray = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParentVelocityModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDecalPlacementVectorExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSNiNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSInstanceTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSMultiIndexTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLODMultiIndexTriShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFadeNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTreeNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLeafAnimNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_ShadowSceneNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLightingShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSGrassShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSShaderAccumulator = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSGrassShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSEffectShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSWaterShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBloodSplatterShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSBloodSplatterShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParticleShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParticleShaderGeometry = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLightingShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTextureSet = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSShaderTextureSet = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSkyShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSSkyShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFadeNodeCuller = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSEffectShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDistantTreeShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSDistantTreeShaderProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSWaterShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSCubeMapCamera = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSClearZNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSFogProperty = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSUtilityShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParticleShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSOrderedNode = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysLODModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysSimpleColorModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSNiAlphaPropertyTestRefController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyColorController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyFloatController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyColorController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyUShortController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyFloatController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSImagespaceShader = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9Renderer = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX92DBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9TextureBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9DepthStencilBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9ImplicitDepthStencilBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9Direct3DDepthStencilBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9AdditionalDepthStencilBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9OnscreenBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9ImplicitBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9SwapChainBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9SwapChainDepthStencilBufferData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9Direct3DTexture = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDX9PersistentSrcTextureRendererData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiParticleSystem = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysGravityModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysHavokUpdateModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiMeshParticleSystem = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysCylinderEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSStripParticleSystem = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysVolumeEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysModifierCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSStripPSysData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysMeshUpdateModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiMeshPSysData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysUpdateCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysMeshEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysInheritVelocityModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSPSysRecycleBoundModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysVortexFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysTurbulenceFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysSphericalCollider = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysSphereEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysSpawnModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysRotationModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysResetOnLoopCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysRadialFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysPositionModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysPlanarCollider = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysModifierActiveCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedVarCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleVarCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysGrowFadeModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysGravityStrengthCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysGravityFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysFieldMaxDistanceCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysFieldMagnitudeCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysFieldAttenuationCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterSpeedCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleVarCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterLifeSpanCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterInitialRadiusCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationVarCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlrData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysDragModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysDragFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysColorModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysColliderManager = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysBoxEmitter = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysBoundUpdateModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysBombModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysAgeDeathModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysAirFieldSpreadCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysAirFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysAirFieldInheritVelocityCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysAirFieldAirFrictionCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysFieldModifier = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysCollider = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysModifierBoolCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiPSysModifierFloatCtlr = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkWorldObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkWorld = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkNiCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAttachmentCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_WeaponObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRigidBody = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkWorldM = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRefObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSerializable = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkEntity = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPhantom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAabbPhantom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSphereRepShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConvexShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkShapePhantom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSimpleShapePhantom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_hkPackedNiTriStripsData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBvTreeShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPackedNiTriStripsShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkNiTriStripsShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCapsuleShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRigidBodyT = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBlendCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBoxShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSphereShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAvoidBox = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkMalleableConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkLimitedHingeConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPrismaticConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkUnaryAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkTriSampledHeightFieldBvTreeShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCachingShapePhantom = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSPCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRagdollTemplateData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRagdollTemplate = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkMouseSpringAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkHingeConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkGroupConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPoseArray = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkExtraData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBlendController = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSpringAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkOrientHingedBodyAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkMotorAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkLiquidAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkDashpotAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkAngularDashpotAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBreakableConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkWheelConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkStiffSpringConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRagdollLimitsConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkRagdollConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkFixedConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkHingeLimitsConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBallSocketConstraintChain = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBallAndSocketConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkListShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkTransformShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkMoppBvTreeShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkTriangleShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPlaneShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkMultiSphereShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCylinderShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConvexVerticesShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConvexTranslateShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConvexTransformShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConvexSweepShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCompressedMeshShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCompressedMeshShapeData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkGenericConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCollisionBox = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkShapeCollection = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCharControllerShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPositionConstraintMotor = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkVelocityConstraintMotor = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkSpringDamperConstraintMotor = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCharacterProxy = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkCharacterRigidBody = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkBinaryAction = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkConstraintChain = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkHeightFieldShape = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_bhkPointToPathConstraint = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiCollisionData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiDepthStencilBuffer = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRenderedCubeMap = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRenderTargetGroup = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiRenderedTexture = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiShaderDeclaration = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_Ni2DBuffer = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_NiCollisionObject = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSTextureData = (NiRTTI *)0x00000000;
const NiRTTI *	NiRTTI_BSParabolicCullingProcess = (NiRTTI *)0x00000000;
#endif
