﻿# This file is in the public domain. Feel free to modify it as a basis
# for your own screens.

# Note that many of these screens may be given additional arguments in the
# future. The use of **kwargs in the parameter list ensures your code will
# work in the future.

image chara:
    "gui/chara.png"
    alpha 0.0 
    linear 3.0 alpha 1.0
    
image logo:
    "gui/title.png"
    xanchor -1000
    easein 4.0 xanchor 0
    
image border:
    "gui/border.png"
    alpha 0.0
    linear 1.0 alpha 1.0

image opt:
    "gui/options_header.png"
    xanchor -1000
    easein 4.0 xanchor 0
    
image opt1:
    "gui/options_titles1.png"
    alpha 0.0
    linear 4.0 alpha 1.0
    
image opt2:
    "gui/options_titles2.png"
    xanchor -1000
    easein 4.0 xanchor 0
    
image sl1:
    "gui/save_title.png"
    xanchor -1000
    easein 4.0 xanchor 0
    
image sl2:
    "gui/load_title.png"
    xanchor -1000
    easein 4.0 xanchor 0


##############################################################################
# Say
#
# Screen that's used to display adv-mode dialogue.
# http://www.renpy.org/doc/html/screen_special.html#say
screen say(who, what, side_image=None, two_window=False):

    # Decide if we want to use the one-window or two-window variant.
    if not two_window:

        # The one window variant.
        window:
            id "window"

            has vbox:
                style "say_vbox"

            if who:
                text who id "who"

            text what id "what"

    else:

        # The two window variant.
        vbox:
            style "say_two_window_vbox"

            if who:
                window:
                    style "say_who_window"

                    text who:
                        id "who"

            window:
                id "window"

                has vbox:
                    style "say_vbox"

                text what id "what"

    # If there's a side image, display it above the text.
    if side_image:
        add side_image
    else:
        add SideImage() xalign 0.0 yalign 1.0

    # Use the quick menu.
    use quick_menu


##############################################################################
# Choice
#
# Screen that's used to display in-game menus.
# http://www.renpy.org/doc/html/screen_special.html#choice

screen choice:

    window: 
        style "menu_window"        
        
        vbox:
            style "menu"
            spacing 2
            
            for caption, action, chosen in items:
                
                if action:  
                    
                    button:
                        action action
                        style "menu_choice_button"                        

                        text caption style "menu_choice" at pref_eff
                    
                else:
                    text caption style "menu_caption" at pref_eff

init -2 python:
    config.narrator_menu = False
    
#    style.menu_window.set_parent(style.default)
#    style.menu_choice.set_parent(style.button_text)
#    style.menu_choice.clear()
#    style.menu_choice_button.set_parent(style.button)
#    style.menu_choice_button.xminimum = int(config.screen_width * 0.75)
#    

##############################################################################
# Input
#
# Screen that's used to display renpy.input()
# http://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):

    window style "input_window":
        has vbox

        text prompt style "input_prompt"
        input id "input" style "input_text"

    use quick_menu

##############################################################################
# Nvl
#
# Screen used for nvl-mode dialogue and menus.
# http://www.renpy.org/doc/html/screen_special.html#nvl

screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            style "nvl_vbox"

        # Display dialogue.
        for who, what, who_id, what_id, window_id in dialogue:
            window:
                id window_id

                has hbox:
                    spacing 10

                if who is not None:
                    text who id who_id

                text what id what_id

        # Display a menu, if given.
        if items:

            vbox:
                id "menu"

                for caption, action, chosen in items:

                    if action:

                        button:
                            style "nvl_menu_choice_button"
                            action action

                            text caption style "nvl_menu_choice"

                    else:

                        text caption style "nvl_dialogue"

    add SideImage() xalign 0.0 yalign 1.0

    use quick_menu

##############################################################################
# Main Menu
#
# Screen that's used to display the main menu, when Ren'Py first starts
# http://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    # This ensures that any other menu screen is replaced.
    tag menu
    add "gui/mmbg.png"
    add "chara" 
    add "logo" 
    
    imagebutton auto "gui/play_%s.png" xpos 1571 ypos 306 focus_mask True action Start() at main_eff
    imagebutton auto "gui/load_%s.png" xpos 1538 ypos 469 focus_mask True action ShowMenu('load')  at main_eff
    imagebutton auto "gui/opt_%s.png" xpos 1510 ypos 614 focus_mask True action ShowMenu('preferences') at main_eff
    
    imagebutton auto "gui/quit_%s.png" xpos 1424 ypos 905 focus_mask True action Quit(confirm=False) at main_eff
    
    add "border"
    
init -2:
    transform main_eff:
        alpha 0.0 xpos 2000
        linear 4.0 alpha 1.0 xanchor 1.0 xpos 1920
        on idle:
            alpha 1.0
        on hover:
            alpha 0.5
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
                                                                                    



##############################################################################
# Navigation
#
# Screen that's included in other screens to display the game menu
# navigation and background.
# http://www.renpy.org/doc/html/screen_special.html#navigation
screen navigation():
    imagebutton auto "gui/nav_return_%s.png" xpos 328 ypos 499 xanchor 1.0 focus_mask True action Return() at nav_eff
    imagebutton auto "gui/nav_save_%s.png" xpos 328 ypos 588 xanchor 1.0 focus_mask True action ShowMenu('save') at nav_eff
    imagebutton auto "gui/nav_load_%s.png" xpos 327 ypos 680 xanchor 1.0 focus_mask True action ShowMenu('load') at nav_eff
    imagebutton auto "gui/nav_options_%s.png" xpos 328 ypos 774 xanchor 1.0 focus_mask True action ShowMenu('preferences') at nav_eff
    imagebutton auto "gui/nav_menu_%s.png" xpos 328 ypos 868 xanchor 1.0 focus_mask True action MainMenu() at nav_eff
    
init -2:
    transform nav_eff:
        alpha 0.0 xpos -500
        linear 4.0 alpha 1.0 xpos 0 xanchor 0
        on idle:
            alpha 1.0
        on hover:
            alpha 0.5
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat


##############################################################################
# Save, Load
#
# Screens that allow the user to save and load the game.
# http://www.renpy.org/doc/html/screen_special.html#save
# http://www.renpy.org/doc/html/screen_special.html#load

# Since saving and loading are so similar, we combine them into
# a single screen, file_picker. We then use the file_picker screen
# from simple load and save screens.
init python:
    config.thumbnail_width = 284
    config.thumbnail_height = 160

init -2 python: #we initialize x and y, so the load_save_slot screen below works at startup
    x=0
    y=0
screen load_save_slot:
    $ file_text = "% s\n  %s" % (FileTime(number, empty="Empty Slot."), FileSaveName(number))
    $x1=x+880
    $y1=y+25
    add FileScreenshot(number) xpos x1 ypos y1 at quick_eff3
    $x2=x+1200
    $y2=y+40
    text file_text xpos x2 ypos y2 size 36 at quick_eff3
    
    key "save_delete" action FileDelete(number)
    
screen save:
    tag menu 
    add "gui/bg.png"
    add "sl1"
    use file_picker 
    add "border"
    
screen load:
    tag menu
    add "gui/bg.png"
    add "sl2"
    use file_picker
    add "border"
    
screen file_picker:
    use navigation 
    imagebutton auto "gui/sl_next_%s.png" xpos 1711 ypos 888 focus_mask True action FilePageNext() at pref_eff
    imagebutton auto "gui/sl_prev_%s.png" xpos 1003 ypos 885 focus_mask True action FilePagePrevious() at pref_eff
    imagebutton auto "gui/sl_1_%s.png" xpos 1315 ypos 889 focus_mask True action FilePage(1) at pref_eff
    imagebutton auto "gui/sl_2_%s.png" xpos 1385 ypos 891 focus_mask True action FilePage(2) at pref_eff
    imagebutton auto "gui/sl_3_%s.png" xpos 1448 ypos 891 focus_mask True action FilePage(3) at pref_eff
    imagebutton auto "gui/sl_4_%s.png" xpos 1505 ypos 889 focus_mask True action FilePage(4) at pref_eff
    imagebutton auto "gui/sl_5_%s.png" xpos 1570 ypos 890 focus_mask True action FilePage(5) at pref_eff
    imagebutton auto "gui/sl_6_%s.png" xpos 1634 ypos 890 focus_mask True action FilePage(6) at pref_eff
    
    $ y=244 # ypos for the first save slot
    for i in range(0, 3): # This repeats the block below 3 times (counts from 0 to 2), for the 3 save slots. We could also copy/paste the block below 3 times, but we are too lazy to do that.
        imagebutton auto "gui/sl_box_%s.png" xpos 999 ypos y focus_mask True action FileAction(i) at main_eff
        use load_save_slot(number=i, x=195, y=y) # This calls the load_save_slot screen defined above. We pass variable i as the slot number and x, y coordinates.
        $ y+=209 # We increase the y variable so every next save slot is moved 124px lower.

##############################################################################
# Preferences
#
# Screen that allows the user to change the preferences.
# http://www.renpy.org/doc/html/screen_special.html#prefereces

screen preferences():

    tag menu
    add "gui/bg.png"
    use navigation
    add "opt"
    add "opt2"
    add "opt1"
    add "border"
    
    imagebutton auto "gui/windowed_%s.png" xpos 693 ypos 325 focus_mask True action Preference('display', 'window') at pref_eff
    imagebutton auto "gui/fullscreen_%s.png" xpos 1005 ypos 324 focus_mask True action Preference('display', 'fullscreen') at pref_eff
    
    imagebutton auto "gui/disabled_%s.png" xpos 739 ypos 481 focus_mask True action Preference('transitions', 'none') at pref_eff
    imagebutton auto "gui/enabled_%s.png" xpos 1008 ypos 484 focus_mask True action Preference('transitions', 'all') at pref_eff
    
    imagebutton auto "gui/cskip_%s.png" xpos 704 ypos 647 focus_mask True action Preference('after choices', 'stop') at pref_eff
    imagebutton auto "gui/sskip_%s.png" xpos 1010 ypos 647 focus_mask True action Preference('after choices', 'skip') at pref_eff
    
    imagebutton auto "gui/read_%s.png" xpos 722 ypos 809 focus_mask True action Preference('skip', 'seen') at pref_eff
    imagebutton auto "gui/all_%s.png" xpos 1014 ypos 809 focus_mask True action Preference('skip', 'all') at pref_eff
    
    frame xpos 1340 ypos 322:
        style_group "pref"
        has vbox
        bar value Preference("music volume")
        at bar_eff
    frame xpos 1340 ypos 482:
        style_group "pref"
        has vbox
        bar value Preference("sound volume") 
        at bar_eff
    frame xpos 1340 ypos 639:
        style_group "pref"
        has vbox
        bar value Preference("voice volume") 
        at bar_eff
    frame xpos 1340 ypos 801:
        style_group "pref"
        has vbox
        bar value Preference("text speed")
        at bar_eff
    frame xpos 1340 ypos 961:
        style_group "pref"
        has vbox
        bar value Preference("auto-forward time")
        at bar_eff
      
init -2 python: 
    style.pref_frame.background = None
    style.pref_slider.left_bar = "gui/bar_full.png"
    style.pref_slider.right_bar = "gui/bar_empty.png"
    style.pref_slider.thumb = "gui/thumb.png"
    style.pref_slider.thumb_shadow = None
    style.pref_slider.thumb_offset = 15
    style.pref_slider.xmaximum = 542
    style.pref_slider.ymaximum = 53

init -2:
    transform pref_eff:
        alpha 0.0
        linear 4.0 alpha  1.0
        on idle:
            alpha 1.0
        on hover:
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
    transform bar_eff:
        xpos 2000
        linear 4.0 xpos 0

##############################################################################
# Yes/No Prompt
#
# Screen that asks the user a yes or no question.
# http://www.renpy.org/doc/html/screen_special.html#yesno-prompt

screen yesno_prompt:
    modal True 
    add "gui/sure_bg.png"
    imagebutton auto "gui/yes_%s.png" xpos 699 ypos 578 action yes_action 
    imagebutton auto "gui/no_%s.png" xpos 1086 ypos 584 action no_action 
    
    if message == layout.ARE_YOU_SURE:
        add "gui/sure_menu.png"
    elif message == layout.DELETE_SAVE:
        add "gui/sure_delete.png"
    elif message == layout.OVERWRITE_SAVE:
        add "gui/sure_overwrite.png"
    elif message == layout.LOADING:
        add "gui/sure_load.png"
    elif message == layout.QUIT:
        add "gui/sure_quit.png"
    elif message == layout.MAIN_MENU:
        add "gui/sure_menu.png"

##############################################################################
# Quick Menu
#
# A screen that's included by the default say screen, and adds quick access to
# several useful functions.
screen quick_menu():
    imagebutton auto "gui/qm_save_%s.png" xpos 1718 ypos 802 focus_mask True action ShowMenu('save') at quick_eff
    imagebutton auto "gui/qm_load_%s.png" xpos 1697  ypos 893 focus_mask True action ShowMenu('load') at quick_eff
    imagebutton auto "gui/qm_menu_%s.png" xpos 1674 ypos 986 focus_mask True action MainMenu() at quick_eff
    imagebutton auto "gui/qm_skip_%s.png" xpos 248 ypos 800 xanchor 1.0 focus_mask True action Skip() at quick_eff2
    imagebutton auto "gui/qm_auto_%s.png" xpos 226 ypos 892 xanchor 1.0 focus_mask True action Preference("auto-forward", "toggle") at quick_eff2
    imagebutton auto "gui/qm_options_%s.png" xpos 204 ypos 982 xanchor 1.0 focus_mask True action ShowMenu('preferences') at quick_eff2
init -2:
    transform quick_eff:
     
        on idle:
            alpha 1.0
        on hover:
            alpha 0.5
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
        on selected_idle:
            alpha 1.0
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
    transform quick_eff2:
       
        on idle:
            alpha 1.0
        on hover:
            alpha 0.5
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
        on selected_idle:
            alpha 1.0
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
    
    transform quick_eff3:
       
        on idle:
            alpha 1.0
        on hover:
            alpha 0.5
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat
        on selected_idle:
            alpha 1.0
            linear 0.8 alpha 1.0
            linear 0.8 alpha 0.5
            repeat        
            
###extras
screen extras:
    tag menu
    add "gui/bg.png"
    use navigation
    add "border"

  
