#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <psp2/types.h>
#include <psp2/ctrl.h>
#include <psp2/io/fcntl.h>
#include <psp2/kernel/processmgr.h>
#include <psp2/io/stat.h>

#include "sqlite3.h"
#include "graphics.h"
#include "installer_sqlite.h"
#include "utils.h"
#include "vita_net.h"

#define printf psvDebugScreenPrintf

#define MAIL_DB "ux0:email/message/mail.db"
#define EXPLOIT_HTML "ux0:email/message/00/00/exploit.html"
#define HENKAKU_BIN "ux0:picture/henkaku.bin"

#define TAI_SWTYPE "ux0:data/switchkaku/tai.swtype"
#define HENKAKU_SWTYPE "ux0:data/switchkaku/henkaku.swtype"

void resetEmail() {
	remove_exploit_files();

	delete_file("ux0:email/message/mail.db");
	copy_file("ux0:app/SWKK00001/data/switchkaku/exploits/mail.db","ux0:email/message/mail.db");

	return;
}

int uninstall_exploit(const char *mode) {
	int ret = 0;
    sqlite3 *db;
	char *cmd = "SELECT AccountID FROM mt_account WHERE AccountName=\"HENkaku Offline\"";
	const char *def = "uninstall";

	ret = sqlite3_open(MAIL_DB, &db);

    printf("Uninstalling the exploit...\n");

	if (ret) {
		printf("Failed to open the mail.db database: %s\n", sqlite3_errmsg(db));
		goto fail;
	}

	sqlite3_stmt *stmt;

	if (file_exists(TAI_SWTYPE) > 0)
		cmd = "SELECT AccountID FROM mt_account WHERE AccountName=\"TaiHENkaku Offline\"";

	ret = sqlite3_prepare_v2(db, cmd, -1, &stmt, 0);

	if (ret != SQLITE_OK) {
		psvDebugScreenSetFgColor(COLOR_RED);
		printf("Failed to execute select accountid stmt: %s\n", sqlite3_errmsg(db));
		psvDebugScreenSetFgColor(COLOR_WHITE);
		goto fail;
	}

	if (sqlite3_step(stmt) == SQLITE_ROW) {
		int aid = sqlite3_column_int(stmt, 0);

		printf("Deleting email account #%d...\n");

		for (const char **table = &tables[0]; *table; ++table) {
			char sql[256] = {0};
			char *error = NULL;

			printf("Deleting from %s...\n", *table);
			snprintf(sql, sizeof(sql), "DELETE FROM %s WHERE AccountID = %d", *table, aid);
			sqlite3_exec(db, sql, NULL, NULL, &error);

			if (error) {
				psvDebugScreenSetFgColor(COLOR_RED);
				printf("Error deleting from table %s: %s\n", *table, error);
				psvDebugScreenSetFgColor(COLOR_WHITE);
				sqlite3_free(error);
				goto fail;
			}
		}
	}

	sqlite3_finalize(stmt);
    remove_exploit_files();
	sqlite3_close(db);

	return 0;

fail:
	sqlite3_close(db);
    remove_exploit_files();

	if (mode != def) {
		resetEmail();
		printf("Please try again.\n\n");
		pause();
	} else {
		press_exit();
	}

	return 1;
}

void install_exploit(const char *mode) {
	int ret;
	int tempts = 0;
	char sql[0x1000];
	char *error = NULL;
	const char *def = "offline";

	const char *select_max_aid_sql = "SELECT MAX(AccountID) FROM mt_account";
	const char *select_max_fid_sql = "SELECT MAX(FolderUID) FROM dt_folder";
	const char *select_max_mid_sql = "SELECT MAX(MessageID) FROM dt_message_list";
	const char *select_max_muid_sql = "SELECT MAX(MessageUID) FROM dt_message_list";
	const char *select_max_setting_sql = "SELECT MAX(SettingID) FROM dt_setting";
	const char *mt_account_sql = "INSERT INTO mt_account (AccountID, Enable, Type, AccountName, Name, Address, HostName, Port, EncryptedUserID, EncryptedPassword, UseSSL, AuthType, ViewOrder, UnreadCount, PrimarySmtpID, LeaveMessageFlag, IMAPPathPrefix, UpdateDate) VALUES (%d, 1, 0, 'TaiHENkaku Offline', 'TaiHen', 'taihen@taihen.xyz', '127.0.0.1', 123, X'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', X'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', 0, 0, 0, 0, 0, 0, NULL, NULL)";
	const char *dt_folder_sql = "INSERT INTO dt_folder (AccountID, FolderID, FolderUID, FolderName, ParentFolderID, FolderPath, UnreadCount, UnreadCountDisplayFlag, Flag, MaxMessageUID, UpdateDate) VALUES(%d, -1, %d, 'EXPLOIT', 0, 'EXPLOIT', 0, 1, 0, NULL, NULL)";
	const char *dt_message_list_sql = "INSERT INTO dt_message_list (AccountID, FolderID, MessageID, MessageUID, MessageIDHeader, 'From', OriginalFrom, 'To', OriginalTo, Cc, OriginalCc, Bcc, OriginalBcc, ReplyTo, OriginalReplyTo, InReplyTo, 'References', Subject, OriginalSubject, SentDate, ReceiveDate, Priority, PreviewBody, AttachmentCount, Flag, DownloadedFlag, MessageSize, StatusFlag, ReplyMessageID, ForwardMessageID, Boundary) VALUES(%d, -1, %d, %d, '<taihen@taihen.xyz>', 'TaiHENkaku <taihen@taihen.xyz>', 'TaiHENkaku <taihen@taihen.xyz>', 'TaiHENkaku <taihen@taihen.xyz>', 'TaiHENkaku <taihen@taihen.xyz>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'TaiHENkaku Offline', 'TaiHENkaku Offline', '2016-07-29 09:00:00', '2016-07-29 09:00:00', 3, '', 0, 1, 1, 0, 0, 0, 0, NULL)";
	const char *dt_message_part_sql = "INSERT INTO dt_message_part (AccountID, FolderID, MessageID, PartIndex, Type, OriginalHeader, MimeType, Charset, Encoding, FileName, CID, Section, FilePath, DownloadedFlag, StatusFlag) VALUES (%d, -1, %d, %d, %d, NULL, '%s', 'utf-8', '7BIT', NULL, NULL, %d, '%s', %d, 0)";
	const char *dt_setting_sql = "INSERT INTO dt_setting (SettingID, AutoFetch, Signature, BccMe, DefaultAccountID, NewMessageTemplate, ReplyMessageTemplate, ForwardMessageTemplate, BgReceivedFlag, UpdateDate) VALUES (1, NULL, NULL, NULL, -1, NULL, NULL, NULL, 0, NULL)";

	printf("Installing the exploit\n");

	sqlite3 *db;
	ret = sqlite3_open(MAIL_DB, &db);

	do {
		if (ret) {
			resetEmail();
			ret = sqlite3_open(MAIL_DB, &db);
		}

		tempts++;
	} while (!ret && tempts < 3);

	if (ret) {
		psvDebugScreenSetFgColor(COLOR_RED);
		printf("\n\nFailed to open the mail.db database: %s\nMake sure unsafe mode is on!!\n\n", sqlite3_errmsg(db));
		psvDebugScreenSetFgColor(COLOR_WHITE);
		goto fail;
	}

	// make account: mt_account
	int aid = sql_get_max(db, select_max_aid_sql);
	printf("Creating account ID %d\n", aid);
	snprintf(sql, sizeof(sql), mt_account_sql, aid);
	sql_simple_exec(db, sql);

	// make folder: dt_folder
	int fid = sql_get_max(db, select_max_fid_sql);
	printf("Creating exploit folder %d\n", fid);
	snprintf(sql, sizeof(sql), dt_folder_sql, aid, fid);
	sql_simple_exec(db, sql);

	// make message: dt_message_list
	int mid = sql_get_max(db, select_max_mid_sql);
	int muid = sql_get_max(db, select_max_muid_sql);
	printf("Creating message %d:%d\n", mid, muid);
	snprintf(sql, sizeof(sql), dt_message_list_sql, aid, mid, muid);
	sql_simple_exec(db, sql);

	// make message: dt_message_part
	printf("Creating message part2\n");
	snprintf(sql, sizeof(sql), dt_message_part_sql, aid, mid, 1, 0, "TEXT/PLAIN", 1, "ux0:email/message/00/00/exploit.txt", 0);
	sql_simple_exec(db, sql);
	snprintf(sql, sizeof(sql), dt_message_part_sql, aid, mid, 2, 1, "TEXT/HTML", 2, EXPLOIT_HTML, 1);
	sql_simple_exec(db, sql);

	// install dummy settings: dt_setting
	int sid = sql_get_max(db, select_max_setting_sql);
	if (sid == 1) {
		printf("Installing email settings\n");
		sql_simple_exec(db, dt_setting_sql);
	}

	sqlite3_close(db);
	db = NULL;

	// Create dirs
	mkdirs("ux0:/email/message/00/00/");
	mkdirs("ux0:/picture");
	mkdirs("ux0:/data/switchkaku/exploits/tai");
	mkdirs("ux0:/data/switchkaku/exploits/henkaku");

	if (mode != def) {
		// Download henkaku and tai
		const char *files[4] = {"http://go.henkaku.xyz/offline/henkaku.bin",
		                        "http://go.henkaku.xyz/offline/exploit.html",
								"ux0:/data/switchkaku/exploits/tai/henkaku.bin",
								"ux0:/data/switchkaku/exploits/tai/exploit.html" };

		for (int i=0, j=2; i<2; i++, j++) {
			if (download_file(files[i], files[j]) < 0) {
				psvDebugScreenSetFgColor(COLOR_RED);
				printf("\nDownload failed for: %s\n", files[i]);
				psvDebugScreenSetFgColor(COLOR_WHITE);

				goto fail;
			}
		}
	}

	// Set Tai as default
	if (mode == def && file_exists("ux0:/data/switchkaku/exploits/tai/henkaku.bin") < 0) {
		copy_file("ux0:app/SWKK00001/data/switchkaku/exploits/tai/henkaku.bin", HENKAKU_BIN);
        copy_file("ux0:app/SWKK00001/data/switchkaku/exploits/tai/exploit.html", EXPLOIT_HTML);
	} else {
		copy_file("ux0:/data/switchkaku/exploits/tai/henkaku.bin", HENKAKU_BIN);
		copy_file("ux0:/data/switchkaku/exploits/tai/exploit.html", EXPLOIT_HTML);
	}

	// Create the swtype file (Tai is default)
	int fd = sceIoOpen(TAI_SWTYPE, SCE_O_WRONLY|SCE_O_CREAT, 0777);
	if (fd < 0) {
		psvDebugScreenSetFgColor(COLOR_RED);
		printf("\nCannot create swtype!\n");
		psvDebugScreenSetFgColor(COLOR_WHITE);
		goto fail;
    }
	sceIoClose(fd);

	psvDebugScreenSetFgColor(COLOR_GREEN);
	printf("TaiHen Offline was installed successfully!\n");

	return;

fail:
	if (db)
		sqlite3_close(db);

    remove_exploit_files();
    psvDebugScreenSetFgColor(COLOR_RED);
	printf("\n\nInstall error!\n\n");
	psvDebugScreenSetFgColor(COLOR_WHITE);
	pause();
}

void drawHead(void) {
	psvDebugScreenClear(COLOR_BLACK);

	psvDebugScreenSetFgColor(COLOR_CYAN);
	printf("SwitchKaKu\n\n\n");
	psvDebugScreenSetFgColor(COLOR_WHITE);

	printf("SwitchKaku will let you install and manage the offline version of TaiHen and Henkaku.\n");
	printf("This application will install TaiHen into the Email app by default.\n");
	printf("Back up all your email data (ux0:/email/ directory) if you have anything important there.\n");
	printf("Make sure the Email app is closed, otherwise the installation may fail.\n\n\n");
	printf("\n\n");

	if (file_exists("ux0:email/message/mail.db") < 0)
        copy_file("ux0:/data/switchkaku/exploits/mail.db","ux0:email/message/mail.db");
}

void drawCredits() {
    int key=0;

credits:
    psvDebugScreenClear(COLOR_BLACK);

    psvDebugScreenSetFgColor(COLOR_CYAN);
    printf("SwitchKaKu 1.6  -  by luck\n\n\n");
    psvDebugScreenSetFgColor(COLOR_WHITE);

    printf("Credits:\n\n");
    printf("xyzz: OfflineInstaller\n");
    printf("Team Molecule: Henkaku & TaiHen\n");
    printf("marek256: BG Graphics\n");
    printf("\n\n\n\n> Press () to go back\n");

    key = get_key();
    if (key == SCE_CTRL_CIRCLE)
        return;

    goto credits;
}

void doSwitch(const char *selType, const char *curInst) {
	// Don t do heavy stuff if already set
	if (selType == curInst)
		return;

	const char *cmd1 = "UPDATE dt_message_list SET MessageIDHeader = '<henkaku@henkaku.xyz>', 'From' = 'HENkaku <henkaku@henkaku.xyz>', OriginalFrom = 'HENkaku <henkaku@henkaku.xyz>', 'To' =  'HENkaku <henkaku@henkaku.xyz>', OriginalTo = 'HENkaku <henkaku@henkaku.xyz>', Subject = 'HENkaku Offline', OriginalSubject = 'HENkaku Offline' WHERE Subject=\"TaiHENkaku Offline\"";
	const char *cmd2 = "UPDATE mt_account SET AccountName = 'HENkaku Offline', Name = 'Henkaku', Address = 'henkaku@henkaku.xyz' WHERE AccountName=\"TaiHENkaku Offline\"";
	sqlite3 *db;
	sqlite3_open(MAIL_DB, &db);

	delete_file(EXPLOIT_HTML);
	delete_file(HENKAKU_BIN);

	if (selType == "TaiHen") {
		cmd1 = "UPDATE dt_message_list SET MessageIDHeader = '<taihen@taihen.xyz>', 'From' = 'TaiHENkaku <taihen@taihen.xyz>', OriginalFrom = 'TaiHENkaku <taihen@taihen.xyz>', 'To' =  'TaiHENkaku <taihen@taihen.xyz>', OriginalTo = 'TaiHENkaku <taihen@taihen.xyz>', Subject = 'TaiHENkaku Offline', OriginalSubject = 'TaiHENkaku Offline' WHERE Subject=\"HENkaku Offline\"";
		cmd2 = "UPDATE mt_account SET AccountName = 'TaiHENkaku Offline', Name = 'TaiHen', Address = 'taihen@taihen.xyz' WHERE AccountName=\"HENkaku Offline\"";
		copy_file("ux0:/data/switchkaku/exploits/tai/henkaku.bin", HENKAKU_BIN);
		copy_file("ux0:/data/switchkaku/exploits/tai/exploit.html", EXPLOIT_HTML);
		delete_file(HENKAKU_SWTYPE);
		int fd = sceIoOpen(TAI_SWTYPE, SCE_O_WRONLY|SCE_O_CREAT, 0777);
        sceIoClose(fd);
	} else {
		copy_file("ux0:/data/switchkaku/exploits/henkaku/henkaku.bin", HENKAKU_BIN);
		copy_file("ux0:/data/switchkaku/exploits/henkaku/exploit.html", EXPLOIT_HTML);
		delete_file(TAI_SWTYPE);
		int fd = sceIoOpen(HENKAKU_SWTYPE, SCE_O_WRONLY|SCE_O_CREAT, 0777);
        sceIoClose(fd);
	}

	sql_simple_exec(db, cmd1);
	sql_simple_exec(db, cmd2);
	sqlite3_close(db);
	db = NULL;
}

int main(void) {
	int key = 0;
    int ret = 0;
	int isInstalled = 0;
	char *expl = "Unknown";

	netInit();
	httpInit();
	psvDebugScreenInit();

menu:
	drawHead();

	expl = "Unknown";
	isInstalled = 0;
    ret = 0;

	if (file_exists(TAI_SWTYPE) > 0) {
		expl = "TaiHen";
		isInstalled = 1;
	} else if (file_exists(HENKAKU_SWTYPE) > 0) {
		expl = "Henkaku";
		isInstalled = 1;
	}

	printf("Current Offline exploit: %s\n\n\n\n", expl);
	printf("#### Install Options ####\n\n");

	if (!isInstalled) {
		printf("> Press START to install TaiHen - [Offline]\n");
		printf("> Press /\\ to install/update TaiHen - [Online].\n");
	}

	if (isInstalled)
		printf("> Press () to uninstall TaiHen/Henkaku.\n");

	printf("\n\n\n");
	printf("#### SwitchKaKu Options ####\n\n");

	if (isInstalled) {
		printf("> Press X to set TaiHen as default\n");
		printf("> Press [] to set Henkaku as default - ");
		psvDebugScreenSetFgColor(COLOR_RED);
		printf("Deprecated\n");
		psvDebugScreenSetFgColor(COLOR_WHITE);
	} else {
		printf("> No offline exploit found!\n");
	}

	printf("\n\n\n");
	printf("#### Extra Options ####\n\n");
	printf("> Press SELECT to reset your Email app\n");
	printf("> Press L to show credits\n");
	printf("> Press R to reboot\n");
	printf("\n");

	key = get_key();
	switch (key) {
		case SCE_CTRL_TRIANGLE:
			if (!isInstalled) {
				ret = uninstall_exploit("online");

				if (ret == 0)
					install_exploit("online");
			}
			break;
		case SCE_CTRL_CIRCLE:
			if (isInstalled == 1)
				uninstall_exploit("uninstall");
			break;
		case SCE_CTRL_CROSS:
			doSwitch("TaiHen", expl);
			break;
		case SCE_CTRL_SQUARE:
			doSwitch("Henkaku", expl);
			break;
		case SCE_CTRL_RTRIGGER:
			scePowerRequestColdReset();
			break;
		case SCE_CTRL_LTRIGGER:
			drawCredits();
			break;
		case SCE_CTRL_SELECT:
			resetEmail();
			break;
		case SCE_CTRL_START:
			ret = uninstall_exploit("offline");

			if (ret == 0)
				install_exploit("offline");
			break;
		default:
			psvDebugScreenSetFgColor(COLOR_RED);
			printf("Invalid input, try again.\n\n");
			goto menu;
	}

	goto menu;
}
