-- ===========================================================================
--	Gamecore Event
-- ===========================================================================
function OnLocalPlayerTurnBegin()
	print("MasterBalance OnLocalPlayerTurnBegin!");
end

-- ===========================================================================
function OnPlayerTurnActivated( ePlayer:number, isFirstTimeThisTurn:boolean )
	if ePlayer == Game.GetLocalPlayer() then
		print("MasterBalance OnPlayerTurnActivated ePlayer: " .. tostring(ePlayer));
		Refresh(ePlayer);
	end
end

function Refresh( ePlayer:number )
	if (MapConfiguration.GetValue("map_position") == 2) then
		local iNumMajorCivs = PlayerManager.GetAliveMajorsCount();
		local teamOneNum = math.floor(iNumMajorCivs / 2);
		local teamTwoNum = iNumMajorCivs - teamOneNum;
		
		if (teamOneNum < 0 or teamTwoNum < 0) then
			return;
		end

		local pLocalPlayerVis = PlayersVisibility[ePlayer];
		if (pLocalPlayerVis ~= nil) then
			local isTeamOne = false;
			local iNumMajorCivs = PlayerManager.GetAliveMajorsCount();
			local majorList = PlayerManager.GetAliveMajorIDs();
			for i = 1, iNumMajorCivs do
				if (majorList[i] == ePlayer) then
					if (i <= teamOneNum) then
						isTeamOne = true;
					end
					break;
				end
			end	

			local iCount = Map.GetPlotCount();
			if (isTeamOne) then
				for plotIndex = 0, iCount-1, 1 do
					for i = 1, teamOneNum do
						if (majorList[i] ~= ePlayer) then
							local playerVis = PlayersVisibility[majorList[i]];
							if (playerVis:GetVisibilityCount(plotIndex) > 1) then
								local pPlot = Map.GetPlotByIndex(plotIndex);
								if (pPlot:GetOwner() == majorList[i]) then
									pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 1);
								elseif (not pLocalPlayerVis:IsRevealed(plotIndex)) then
									pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 0);
								end
							elseif (playerVis:IsRevealed(plotIndex) and (not pLocalPlayerVis:IsRevealed(plotIndex))) then
								pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 0);
							end
						end
					end
				end
			else
				for plotIndex = 0, iCount-1, 1 do
					for i = iNumMajorCivs - teamTwoNum + 1, iNumMajorCivs do
						if (majorList[i] ~= ePlayer) then
							local playerVis = PlayersVisibility[majorList[i]];
							if (playerVis:GetVisibilityCount(plotIndex) > 1) then
								local pPlot = Map.GetPlotByIndex(plotIndex);
								if (pPlot:GetOwner() == majorList[i]) then
									pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 1);
								elseif (not pLocalPlayerVis:IsRevealed(plotIndex)) then
									pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 0);
								end
							elseif (playerVis:IsRevealed(plotIndex) and (not pLocalPlayerVis:IsRevealed(plotIndex))) then
								pLocalPlayerVis:ChangeVisibilityCount(plotIndex, 0);
							end
						end
					end
				end
			end
		end
	end
end

function Initialize()
	print("MasterBalance Initialize!");

	Events.LocalPlayerTurnBegin.Add( OnLocalPlayerTurnBegin );
	Events.PlayerTurnActivated.Add(	OnPlayerTurnActivated );
end
Initialize();