// Filters section --- Customize filters here!

// --- No Accidental Stealing Filter
function AL_NoAccidentalStealing(container : W3Container ) : bool
{
	// Loots EVERYTHING as long as taking from the container is NOT considered stealing
	if( container.disableStealing || container.HasQuestItem() || (W3Herb)container || (W3ActorRemains)container )
		return true;
	
	return false;
}

// --- Numbers of items in container filter:
function AL_NumberOfItemsInContainerFilter( length : int ) : bool
{
	// Checks if container has more or less or exactly X items.
	//  *replace == with < if you want to have more than X items.
	//  *replace == with > if you want less than X itemStats
	//  *replace the 1 with any other non-negative number!
	if( 1 == length )
		return true;
	
	return false;
}

// --- Weight Filter:
function AL_WeightFilter( container : W3Container, ItemID : SItemUniqueId ) : bool
{
	// Checks if item has a certain weight
	//  replace the == with < or > sign to check if the item is lighter than / heavier than the weight.
	//  replace 0 with whatever weight you want
	//  0 is a real number: it could be 1.2, 222.561, 3.1415 etc.
	if( container.GetInventory().GetItemEncumbrance( ItemID ) == 0 )
		return true;
	
	return false;
}

function AL_PriceFilter( container : W3Container, ItemID : SItemUniqueId ) : bool
{
	// --- Price Filter:
	// Checkss if item has a certain price
	//  Replace < with == to autoloot items of an exact price.
	//  Replace < with == to autoloot items that are less expensive than X
	//   Replace 100 with any integer number.
	if( 100 < container.GetInventory().GetItemPrice( ItemID ) )
		return true;

	return false;
}

// --- Herbs filter
function AL_Herb( container : W3Container ) : bool
{
	// Only autoloots herbs
	if( (W3Herb)container )
		return true;

	return false;
}

 function AL_Armor( container : W3Container, ItemID : SItemUniqueId ) : bool
{
	// --- Armor filter
	// Only autoloots armor
	if( container.GetInventory().IsItemAnyArmor( ItemID ) )
		return true;

	return false;
}

function AL_Weapon( container : W3Container, ItemID : SItemUniqueId ) : bool
{
	// --- Weapon filter
	// Only autoloots weapons
	if( container.GetInventory().IsItemWeapon( ItemID ) )
		return true;

	return false;
}

// --- Food and drinks filter
function AL_Foodstuff( container : W3Container, ItemID : SItemUniqueId ) : bool
{	
	// Only autoloots edible things
	if( container.GetInventory().IsItemFood( ItemID ) )
		return true;
	
	return false;
}

function AL_ItemQuality( container : W3Container, ItemID : SItemUniqueId  ) : bool
{
	// Check if an item has at least a certain quality level
	// this version checks if item is at least at quality 2 (not common)
	// Quality of items can be:
	// 1 = common
	// 2 = masterwork
	// 3 = magical
	// 4 = relic
	// 5 = Witcher Gear
	if( 2 <= container.GetInventory().GetItemQuality( ItemID )  )
		return true;

	return false;
}
