/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.jetpacks.item;

import de.intektor.jetpacks.JetPacks;
import de.intektor.jetpacks.client.ClientProxy;
import de.intektor.jetpacks.helpers.ColorHelper;
import de.intektor.jetpacks.helpers.Inventories;
import de.intektor.jetpacks.helpers.NBTTagCompounds;
import de.intektor.jetpacks.method.handles.CommonMethodHandles;
import de.intektor.jetpacks.network.JetParticleMessageToClient;
import de.intektor.jetpacks.registry.JetPackRegistry;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public abstract class ItemJetPack
extends ItemArmor {
    public ItemJetPack(String name, ItemArmor.ArmorMaterial material) {
        super(material, 2, EntityEquipmentSlot.CHEST);
        this.func_77625_d(1);
        this.func_77655_b("jet_packs_" + name);
        this.func_77637_a(JetPacks.jet_packs_tab);
        this.setRegistryName("jet_packs_" + name);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = NBTTagCompounds.createGetTag(stack);
        if ((nbt.func_74767_n("particle") || nbt.func_74767_n("HoverMode")) && nbt.func_74762_e("RemainingJetBoost") > 0 && !player.field_70122_E && !world.field_72995_K) {
            JetPacks.network.sendToAllAround((IMessage)new JetParticleMessageToClient(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, JetPackRegistry.getJetPackRegistryID(this)), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 30.0));
        }
        if (nbt.func_74767_n("particle") && !player.func_70093_af()) {
            if (nbt.func_74762_e("RemainingJetBoost") <= 0 && !world.field_72995_K && (player.field_71075_bZ.field_75098_d || Inventories.consumeItem((IInventory)player.field_71071_by, Items.field_151137_ax))) {
                nbt.func_74768_a("RemainingJetBoost", this.getMaxFuel());
            }
            if (!player.field_71075_bZ.field_75100_b && nbt.func_74762_e("RemainingJetBoost") > 0) {
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    try {
                        CommonMethodHandles.floatingTickCountSetter.invokeExact(playerMP.field_71135_a, 0);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (!world.field_72995_K) {
                    nbt.func_74768_a("RemainingJetBoost", nbt.func_74762_e("RemainingJetBoost") - this.getRemoveFuelPerTick());
                }
                if (player.field_70181_x < (double)this.getMotionUp()) {
                    player.field_70181_x += (double)0.2f;
                }
                player.field_70143_R = 0.0f;
                player.func_70060_a(player.field_70702_br, player.field_70701_bs, this.getMotionForward());
                if (!player.field_71075_bZ.field_75098_d) {
                    int i;
                    if (this instanceof WoodenJetPack) {
                        int i2 = player.func_70681_au().nextInt(300);
                        if (i2 < 5) {
                            player.field_70170_p.func_72876_a(null, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 7.0f, true);
                            player.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                        }
                    } else if (this instanceof StoneJetPack && (i = player.func_70681_au().nextInt(1000)) < 5) {
                        player.field_70170_p.func_72876_a(null, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 7.0f, true);
                        player.func_70097_a(DamageSource.field_76379_h, Float.MAX_VALUE);
                    }
                }
            }
        }
        if (this.canHover() && nbt.func_74767_n("HoverMode") && !player.field_70122_E) {
            if (nbt.func_74762_e("RemainingJetBoost") <= 0 && (player.field_71075_bZ.field_75098_d || Inventories.consumeItem((IInventory)player.field_71071_by, Items.field_151137_ax))) {
                nbt.func_74768_a("RemainingJetBoost", this.getMaxFuel());
            }
            if (nbt.func_74762_e("RemainingJetBoost") > 0) {
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    try {
                        CommonMethodHandles.floatingTickCountSetter.invokeExact(playerMP.field_71135_a, 0);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                player.field_70143_R = 0.0f;
                boolean used = false;
                if (!player.func_70093_af() && !nbt.func_74767_n("particle")) {
                    player.field_70181_x = -this.hoverAccuracy();
                    player.func_70060_a(player.field_70702_br, player.field_70701_bs, this.getMotionForward());
                    used = true;
                }
                if (player.func_70093_af()) {
                    player.field_70181_x = -0.1;
                    used = true;
                }
                if (nbt.func_74767_n("particle")) {
                    player.field_70181_x = 0.1;
                    used = true;
                }
                if (used) {
                    nbt.func_74768_a("RemainingJetBoost", nbt.func_74762_e("RemainingJetBoost") - this.getRemoveFuelPerTick());
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = NBTTagCompounds.createGetTag(stack);
        if (nbt.func_74767_n("HoverChanged")) {
            if (worldIn.field_72995_K) {
                String s = nbt.func_74767_n("HoverMode") ? I18n.func_135052_a((String)"tooltip.jet_packs.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltip.jet_packs.off", (Object[])new Object[0]);
                entityIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.jet_packs.hover_toggle", (Object[])new Object[]{s})));
            }
            nbt.func_74757_a("HoverChanged", false);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbt = NBTTagCompounds.createGetTag(stack);
        tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.fuel_information", (Object[])new Object[]{nbt.func_74762_e("RemainingJetBoost"), this.getMaxFuel()}));
        tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.forward_information", (Object[])new Object[]{Float.valueOf(this.getMotionForward())}));
        tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.upwards_information", (Object[])new Object[]{Float.valueOf(this.getMotionUp())}));
        tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.efficiency_information", (Object[])new Object[]{this.getRemoveFuelPerTick()}));
        if (this.canHover()) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.can_hover_information", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.hover_accuracy_information", (Object[])new Object[]{Float.valueOf(this.hoverAccuracy())}));
            String s = nbt.func_74767_n("HoverMode") ? I18n.func_135052_a((String)"tooltip.jet_packs.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"tooltip.jet_packs.off", (Object[])new Object[0]);
            tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.hover_information", (Object[])new Object[]{s}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.hover_binding_information", (Object[])new Object[]{Keyboard.getKeyName((int)ClientProxy.switch_hover_jet_pack.func_151463_i())}));
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.jet_packs.hover_redstone_information", (Object[])new Object[0]));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return this.getTexture(entity, entity.field_70170_p, stack);
    }

    public int getMaxFuel() {
        return 50000;
    }

    public abstract int getRemoveFuelPerTick();

    public abstract float getMotionUp();

    public abstract float getMotionForward();

    public abstract Color getColor();

    public abstract boolean canHover();

    public abstract float hoverAccuracy();

    public abstract String getTexture(Entity var1, World var2, ItemStack var3);

    public static class CreativeJetPack
    extends ItemJetPack {
        public CreativeJetPack() {
            super("creative_jet_pack", ItemArmor.ArmorMaterial.DIAMOND);
        }

        @Override
        public int getMaxFuel() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 1;
        }

        @Override
        public float getMotionUp() {
            return 2.0f;
        }

        @Override
        public float getMotionForward() {
            return 0.1f;
        }

        @Override
        public Color getColor() {
            return new Color(7, 50, 51);
        }

        @Override
        public boolean canHover() {
            return true;
        }

        @Override
        public float hoverAccuracy() {
            return 0.0f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/creative_jet_pack_armor.png";
        }
    }

    public static class RainbowJetPack
    extends ItemJetPack {
        public RainbowJetPack() {
            super("rainbow_jet_pack", ItemArmor.ArmorMaterial.DIAMOND);
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 50;
        }

        @Override
        public float getMotionUp() {
            return 1.5f;
        }

        @Override
        public float getMotionForward() {
            return 0.075f;
        }

        @Override
        public Color getColor() {
            return ColorHelper.getRandColorFromPool(JetPacks.wooden_jet_pack.getColor(), JetPacks.diamond_jet_pack.getColor(), JetPacks.creative_jet_pack.getColor(), Color.RED, Color.GREEN, Color.YELLOW, Color.BLUE, Color.MAGENTA);
        }

        @Override
        public boolean canHover() {
            return true;
        }

        @Override
        public float hoverAccuracy() {
            return 0.005f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/rainbow_jet_pack_armor.png";
        }
    }

    public static class DiamondJetPack
    extends ItemJetPack {
        public DiamondJetPack() {
            super("diamond_jet_pack", ItemArmor.ArmorMaterial.DIAMOND);
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 200;
        }

        @Override
        public float getMotionUp() {
            return 1.0f;
        }

        @Override
        public float getMotionForward() {
            return 0.05f;
        }

        @Override
        public Color getColor() {
            return Color.cyan;
        }

        @Override
        public boolean canHover() {
            return true;
        }

        @Override
        public float hoverAccuracy() {
            return 0.02f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/diamond_jet_pack_armor.png";
        }
    }

    public static class GoldenJetPack
    extends ItemJetPack {
        public GoldenJetPack() {
            super("golden_jet_pack", ItemArmor.ArmorMaterial.GOLD);
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 500;
        }

        @Override
        public float getMotionUp() {
            return 1.5f;
        }

        @Override
        public float getMotionForward() {
            return 0.01f;
        }

        @Override
        public Color getColor() {
            return Color.yellow;
        }

        @Override
        public boolean canHover() {
            return true;
        }

        @Override
        public float hoverAccuracy() {
            return 0.01f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/gold_jet_pack_armor.png";
        }
    }

    public static class IronJetPack
    extends ItemJetPack {
        public IronJetPack() {
            super("iron_jet_pack", ItemArmor.ArmorMaterial.IRON);
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 1000;
        }

        @Override
        public float getMotionUp() {
            return 0.5f;
        }

        @Override
        public float getMotionForward() {
            return 0.03f;
        }

        @Override
        public Color getColor() {
            return Color.lightGray;
        }

        @Override
        public boolean canHover() {
            return false;
        }

        @Override
        public float hoverAccuracy() {
            return 0.0f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/iron_jet_pack_armor.png";
        }
    }

    public static class StoneJetPack
    extends ItemJetPack
    implements ISpecialArmor {
        public StoneJetPack() {
            super("stone_jet_pack", ItemArmor.ArmorMaterial.LEATHER);
        }

        public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }

        public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
            return 0;
        }

        public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 2500;
        }

        @Override
        public float getMotionUp() {
            return 0.2f;
        }

        @Override
        public float getMotionForward() {
            return 0.02f;
        }

        @Override
        public Color getColor() {
            return Color.gray;
        }

        @Override
        public boolean canHover() {
            return false;
        }

        @Override
        public float hoverAccuracy() {
            return 0.0f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/stone_jet_pack_armor.png";
        }
    }

    public static class WoodenJetPack
    extends ItemJetPack
    implements ISpecialArmor {
        public WoodenJetPack() {
            super("wooden_jet_pack", ItemArmor.ArmorMaterial.LEATHER);
        }

        public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }

        public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
            return 0;
        }

        public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        }

        @Override
        public int getRemoveFuelPerTick() {
            return 5000;
        }

        @Override
        public float getMotionUp() {
            return 0.2f;
        }

        @Override
        public float getMotionForward() {
            return 0.01f;
        }

        @Override
        public Color getColor() {
            return new Color(139, 69, 19);
        }

        @Override
        public boolean canHover() {
            return false;
        }

        @Override
        public float hoverAccuracy() {
            return 0.0f;
        }

        @Override
        public String getTexture(Entity player, World world, ItemStack stack) {
            return "jet_packs:textures/armor/wooden_jet_pack_armor.png";
        }
    }
}

