/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.jetpacks.network;

import de.intektor.jetpacks.client.ClientProxy;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class JetParticleMessageToClient
implements IMessage {
    public double x;
    public double y;
    public double z;
    public double rotationYaw;
    public int jetID;

    public JetParticleMessageToClient(double x, double y, double z, double rotationYaw, int jetID) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotationYaw = rotationYaw;
        this.jetID = jetID;
    }

    public JetParticleMessageToClient() {
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.rotationYaw = buf.readDouble();
        this.jetID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.rotationYaw);
        buf.writeInt(this.jetID);
    }

    public static class JetParticleMessageToClientHandler
    implements IMessageHandler<JetParticleMessageToClient, IMessage> {
        public IMessage onMessage(JetParticleMessageToClient message, MessageContext ctx) {
            ClientProxy.handleJetParticleMessage(message);
            return null;
        }
    }
}

