/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.jetpacks.client;

import de.intektor.jetpacks.JetPacks;
import de.intektor.jetpacks.client.JPSettings;
import de.intektor.jetpacks.client.gui.GuiSettings;
import de.intektor.jetpacks.client.gui.JPGuiIngame;
import de.intektor.jetpacks.item.ItemJetPack;
import de.intektor.jetpacks.network.HoverPressedMessageToServer;
import de.intektor.jetpacks.network.JetParticleMessageToClient;
import de.intektor.jetpacks.network.KeyPressMessageToServer;
import de.intektor.jetpacks.network.KeyReleaseMessageToServer;
import de.intektor.jetpacks.registry.JetPackRegistry;
import de.intektor.jetpacks.server.ServerProxy;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientProxy
extends ServerProxy {
    public static final KeyBinding switch_hover_jet_pack = new KeyBinding("jet_packs_switch_hover", 35, "Jet Packs");
    public static final KeyBinding open_settings = new KeyBinding("jet_packs_open_settings", 25, "Jet Packs");
    public static JPSettings settings;
    Minecraft mc = Minecraft.func_71410_x();
    boolean spacePressed;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new JPGuiIngame());
        ClientRegistry.registerKeyBinding((KeyBinding)switch_hover_jet_pack);
        ClientRegistry.registerKeyBinding((KeyBinding)open_settings);
        try {
            FileInputStream fileIn = new FileInputStream("Settings.jetpacks");
            ObjectInputStream objectIn = new ObjectInputStream(fileIn);
            settings = (JPSettings)objectIn.readObject();
        }
        catch (Exception e) {
            settings = new JPSettings();
        }
        String domain = "jet_packs:";
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.wooden_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "wooden_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.stone_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "stone_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.iron_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "iron_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.golden_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "golden_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.diamond_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "diamond_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.rainbow_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "jet_packs_rainbow_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.creative_jet_pack, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "jet_packs_creative_jet_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)JetPacks.rainbow_dust, (int)0, (ModelResourceLocation)new ModelResourceLocation(domain + "jet_packs_rainbow_dust", "inventory"));
    }

    @Override
    public void init() {
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EntityPlayerSP player = this.mc.field_71439_g;
            WorldClient world = this.mc.field_71441_e;
            if (world != null) {
                ItemStack chest = player.field_71071_by.field_70460_b[2];
                if (this.mc.field_71474_y.field_74314_A.func_151470_d() && !player.func_70093_af() && !this.spacePressed) {
                    JetPacks.network.sendToServer((IMessage)new KeyPressMessageToServer(57));
                    this.spacePressed = true;
                }
            }
            if (switch_hover_jet_pack.func_151468_f()) {
                JetPacks.network.sendToServer((IMessage)new HoverPressedMessageToServer());
            }
            if (open_settings.func_151468_f()) {
                this.mc.func_147108_a((GuiScreen)new GuiSettings());
            }
            if (this.spacePressed && !Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
                this.spacePressed = false;
                JetPacks.network.sendToServer((IMessage)new KeyReleaseMessageToServer(57));
            }
        }
    }

    public static void spawnParticleForPlayerJetpack(EntityPlayer player, ItemJetPack jet) {
        ClientProxy.spawnParticleJetPack(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, jet);
    }

    public static void spawnParticleJetPack(double px, double py, double pz, double rotationYaw, ItemJetPack jet) {
        for (int i = 0; i < 10; ++i) {
            double f = 0.25;
            double x = px + Math.sin(rotationYaw / 180.0 * Math.PI) * f;
            double z = pz - Math.cos(rotationYaw / 180.0 * Math.PI) * f;
            Color color = jet.getColor();
            double d = 0.3;
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), x + Math.sin(rotationYaw / 180.0 * Math.PI + 1.5707963267948966) * d, py + 1.0, z - Math.cos(rotationYaw / 180.0 * Math.PI + 1.5707963267948966) * d, 0.0, -3.0, 0.0, new int[0]);
            if (fx == null) continue;
            fx.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), x - Math.sin(rotationYaw / 180.0 * Math.PI + 1.5707963267948966) * d, py + 1.0, z + Math.cos(rotationYaw / 180.0 * Math.PI + 1.5707963267948966) * d, 0.0, -3.0, 0.0, new int[0]);
            fx.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        }
    }

    public static void handleJetParticleMessage(JetParticleMessageToClient message) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.spawnParticleJetPack(message.x, message.y, message.z, message.rotationYaw, JetPackRegistry.getJetPackByID(message.jetID)));
    }
}

