/*
* Radius loot part of the mod.
* Feel free to edit/redistribute.
*/
class AutoLootHerbsRadiusLoot extends AutoLootHerbsUserConfig
{
	public function LootHerbsInRadius()
	{
		var EntitiesFound : array<CGameplayEntity>;
		var ContainersFound : array<W3Container>;
		var i : int;
		var MaxContainers : int;
		var NumberOfContainers : int;
		var TempStoreOption : bool;
		var ContainerNum : int;
		
		if( !IsRadiusLootEnabled() )
			return;
		
		// find containers in a range
		FindGameplayEntitiesInRange( 
			EntitiesFound, // array to store values
			thePlayer, // center of search box
			GetRadiusLootMaxDistance(), // maximum distance
			150);// maximum objects

		for( i = 0; i < EntitiesFound.Size(); i+=1)	
			if((W3Container) EntitiesFound[i])
				ContainersFound.PushBack((W3Container) EntitiesFound[i]);
		
		// we initialize variables
		NumberOfContainers = EntitiesFound.Size();
		MaxContainers = GetRadiusLootMaxObjects();
		
		if(MaxContainers <= 0)
			MaxContainers = 1;
			
		ContainerNum = 0;
		
		// we now parse the containers
		for( i = 0; i < NumberOfContainers; i += 1)
		{
			if((W3Container)EntitiesFound[i])
			{
				// we ignore some containers
				if( ((W3Container)EntitiesFound[i]).IsEmpty() || ((W3Container)EntitiesFound[i]).HasQuestItem() 
				|| !((W3Herb)(W3Container)EntitiesFound[i]))
					continue;
				
				
				if( ((W3Container)EntitiesFound[i]).TryToAutoLootHerbs() == true )
					ContainerNum += 1; // we increase the containers found number
				
				
				// do not loot above the max number
				if(ContainerNum == MaxContainers)
					return;
			}
		}
	}
}