  /*---------------.
  | :: Textures :: |
  '---------------*/

Texture2D texColor  < string type = "input";  >;
//Texture2D texTarget < string type = "output"; >;

  /*---------------.
  | :: Samplers :: |
  '---------------*/
  
SamplerState LinearSampler
{
	Filter = MIN_MAG_LINEAR_MIP_POINT;
	AddressU = Clamp;
	AddressV = Clamp;
};

  /*-------------------------.
  | :: Defining constants :: |
  '-------------------------*/

// Set pixel shader version accordingly:
#if SMAA_HLSL_4_1 == 1
#define PS_VERSION ps_4_1
#else
#define PS_VERSION ps_4_0
#endif


#ifdef EFX //using eFX?
  #define screen_size float2(BUFFER_WIDTH,BUFFER_HEIGHT)
  #define pixel float2(1.0 / screen_size)

  #define px (pixel.x)
  #define py (pixel.y)
  
  #define s0 texColor
  #define s1 texColor
  
  #define myTex2D(s,p) s.Sample(LinearSampler, p)

#endif

  /*------------------------------.
  | :: Include SweetFX filters :: |
  '------------------------------*/
  
#include "SweetFX/Shaders/Main.h"  //Include the main SweetFX control shader


  /*------------------------.
  | :: SweetFX - structs :: |
  '------------------------*/

struct Output
{
float4 position_cs : SV_POSITION;
float2 texcoord : TEXCOORD;
};

  /*---------------------------------------.
  | :: SweetFX - SMAA_off vertex shader :: |
  '---------------------------------------*/

Output DX10_SMAA_off_VS(uint id: SV_VertexID) {
                      
Output output;
 
output.texcoord = float2((id << 1) & 2, id & 2);
output.position_cs = float4(output.texcoord * float2(2, -2) + float2(-1, 1), 0, 1);

return output;
}

  /*--------------------------------------.
  | :: SweetFX - SMAA_off pixel shader :: |
  '--------------------------------------*/

float4 main(float4 position  : SV_POSITION,
            float2 texcoord  : TEXCOORD0,
          /*float4 offset[2] : TEXCOORD1,*/
            uniform Texture2D texColor) : SV_TARGET
{
                                                                        
    float4 SMAAoutput = texColor.Sample(LinearSampler, texcoord);
    
    SMAAoutput = SweetFX_main(texcoord,SMAAoutput); // Add the other effects

    return SMAAoutput;  //Returning the pixel
    
}


  /*--------------------------.
  | :: SweetFX - Technique :: |
  '--------------------------*/

/**
 * SMAA_off technique
 */

technique10 LumaEdgeDetection {
    pass LumaEdgeDetection {
        SetVertexShader(CompileShader(vs_4_0, DX10_SMAA_off_VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, main(texColor)));

        //SetDepthStencilState(DisableDepthStencil, 0); //SetDepthStencilState(DisableDepthReplaceStencil, 1);
        //SetBlendState(NoBlending, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);
    }
}

/*
// --------------------------------------------------------- \\

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

// --------------------------------------------------------- \\

VS_OUTPUT PostProcess_VS(VS_INPUT IN)
{
	VS_OUTPUT OUT;
	
	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
	
	return OUT;
}
float4 PostProcess_PS_Target(VS_OUTPUT OUT) : SV_TARGET0
{
	// SV_TARGET0 --> Rendertarget 1
	// SV_TARGET1 --> Rendertarget 2
	// ...
	
	return texColor.Sample(samplerColor, OUT.tex) * float4(OUT.tex, 1.0, 1.0);
}
float4 PostProcess_PS(VS_OUTPUT OUT) : SV_TARGET
{
	float4 color = texTarget.Sample(samplerColor, OUT.tex);
	color.a = 1.0;

	return color;
}

// --------------------------------------------------------- \\

technique10 PostProcess
{
	pass p0 < string output0 = "texTarget"; >
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetPixelShader(CompileShader(ps_4_0, PostProcess_PS_Target()));
	}
	pass p1
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetPixelShader(CompileShader(ps_4_0, PostProcess_PS()));
	}
}

*/