  /*---------------.
  | :: Textures :: |
  '---------------*/

texture2D texColor  < string type = "input";  >;
texture2D texTarget < string type = "output"; >;

  /*---------------.
  | :: Samplers :: |
  '---------------*/

sampler2D LinearSampler
{
	Texture = <texColor>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Point;
	AddressU = Clamp; AddressV = Clamp;
};
/*
sampler2D samplerTarget
{
	Texture = <texTarget>;
	MinFilter = Linear; MagFilter = Linear; MipFilter = Point;
	AddressU = Clamp; AddressV = Clamp;
};
*/

  /*--------------.
  | :: Structs :: |
  '--------------*/

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};


  /*-------------------------.
  | :: Defining constants :: |
  '-------------------------*/

#ifdef EFX //using eFX?
  #define screen_size float2(BUFFER_WIDTH,BUFFER_HEIGHT)
  #define pixel float2(1.0 / screen_size)

  #define px (pixel.x)
  #define py (pixel.y)
  
  #define myTex2D(s,p) tex2D(s,p)

  #define s0 LinearSampler
  #define s1 LinearSampler
#endif

#include "SweetFX/Shaders/Main.h"  //Include the main SweetFX control shader


  /*---------------------------------------.
  | :: SweetFX - SMAA_off vertex shader :: |
  '---------------------------------------*/

void DX9_SMAA_off_VS(inout float4 position : POSITION
                    ,inout float2 texcoord : TEXCOORD0
					        //,out float4 lumacoord[2] : TEXCOORD1
					          ){

  //lumacoord[0] = pixel.xyxy * (float4(0.5, -0.5, -0.5, -0.5) * offset_bias) + texcoord.xyxy;
  //lumacoord[1] = pixel.xyxy * (float4(0.5, 0.5, -0.5, 0.5) * offset_bias) + texcoord.xyxy;
  
}

  /*--------------------------------------.
  | :: SweetFX - SMAA_off pixel shader :: |
  '--------------------------------------*/

float4 main( float2 texcoord : TEXCOORD0
           //, float4 lumacoord[2] : TEXCOORD1
           ) : COLOR {

    float4 SMAAoutput = tex2D(LinearSampler, texcoord);

    //SMAAoutput = SweetFX_main(SMAAoutput,texcoord,lumacoord); // Add the other effects
    SMAAoutput = SweetFX_main(texcoord,SMAAoutput); // Add the other effects

    return SMAAoutput;  //Returning the pixel
}

  /*--------------------------.
  | :: SweetFX - Technique :: |
  '--------------------------*/

    //What Shader Model should we use?
    #if (SweetFX_shader_model == 0)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_0

    #elif (SweetFX_shader_model == 1)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_a

    #elif (SweetFX_shader_model == 2)
      #define vertex_shader_model vs_2_0
      #define pixel_shader_model  ps_2_b

    #else
      #define vertex_shader_model vs_3_0
      #define pixel_shader_model  ps_3_0

    #endif

technique SMAA_off { // Not doing SMAA.
    pass SMAA_off {

        VertexShader = compile vertex_shader_model DX9_SMAA_off_VS();
        PixelShader  = compile pixel_shader_model main(); //Use this with GPU Shaderanalyzer

/*
        ZEnable = false;
        SRGBWriteEnable = false;
        AlphaBlendEnable = false;

        // Here we want to process all the pixels.
        StencilEnable = false;
*/
    }
}



//-------- old stuff ------------------------------------
/*
VS_OUTPUT PostProcess_VS(VS_INPUT IN)
{
	VS_OUTPUT OUT;
	
	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
	
	return OUT;
}
float4 PostProcess_PS_Target(VS_OUTPUT OUT) : COLOR0
{
	// COLOR0 --> Rendertarget 1
	// COLOR1 --> Rendertarget 2
	// ...
	
	return tex2D(samplerColor, OUT.tex) * float4(OUT.tex, 1.0, 1.0);
}
float4 PostProcess_PS(VS_OUTPUT OUT) : COLOR0
{
	float4 color = tex2D(samplerTarget, OUT.tex);
	color.a = 1.0;
	
	return color;
}
*/

/*
// --------------------------------------------------------- \\

technique PostProcess
{
	pass p0 < string output0 = "texTarget"; >
	{
		VertexShader = compile vs_3_0 PostProcess_VS();
		PixelShader = compile ps_3_0 PostProcess_PS_Target();
	}

	pass p1
	{
		VertexShader = compile vs_3_0 PostProcess_VS();
		PixelShader = compile ps_3_0 PostProcess_PS();
	}

}
*/