  /*------------------------------.
  | :: Include enabled shaders :: |
  '------------------------------*/

#if (USE_CUSTOM == 1)
  #include "SweetFX\Shaders\Custom.h"
  #define Need_sRGB 1
#endif

#if (USE_EXPLOSION == 1)
  #include "SweetFX\Shaders\Explosion.h"
  #define Need_sRGB 1
#endif

#if (USE_CARTOON == 1)
  #include "SweetFX\Shaders\Cartoon.h"
  #define Need_sRGB 1
#endif

#if (USE_ADVANCED_CRT == 1)
  #include "SweetFX\Shaders\AdvancedCRT.h"
  #define Need_sRGB 1
#endif

#if (USE_SWEETCRT == 1)
  #include "SweetFX\Shaders\SweetCRT.h"
  #define Need_sRGB 1
#endif

#if (USE_BLOOM == 1)
  #include "SweetFX\Shaders\Bloom.h"
  #define Need_sRGB 1
#endif

#if (USE_HDR == 1)
  #include "SweetFX\Shaders\HDR.h"
  #define Need_sRGB 1
#endif

#if (USE_LUMASHARPEN == 1)
  #include "SweetFX\Shaders\LumaSharpen.h"
  #define Need_sRGB 1
#endif

#if (USE_LEVELS == 1)
  #include "SweetFX\Shaders\Levels.h"
  #define Need_sRGB 1
#endif

#if (USE_TECHNICOLOR == 1)
  #include "SweetFX\Shaders\Technicolor.h"
  #define Need_sRGB 1
#endif

#if (USE_DPX == 1)
  #include "SweetFX\Shaders\DPX.h"
  #define Need_sRGB 1
#endif

#if (USE_MONOCHROME == 1)
  #include "SweetFX\Shaders\Monochrome.h"
  #define Need_sRGB 1
#endif

#if (USE_LIFTGAMMAGAIN == 1)
  #include "SweetFX\Shaders\LiftGammaGain.h"
  #define Need_sRGB 1
#endif

#if (USE_TONEMAP == 1)
  #include "SweetFX\Shaders\Tonemap.h"
  #define Need_sRGB 1
#endif

#if (USE_SEPIA == 1)
  #include "SweetFX\Shaders\Sepia.h"
  #define Need_sRGB 1
#endif

#if (USE_VIBRANCE == 1)
  #include "SweetFX\Shaders\Vibrance.h"
  #define Need_sRGB 1
#endif

#if (USE_CURVES == 1)
  #include "SweetFX\Shaders\Curves.h"
  #define Need_sRGB 1
#endif

#if (USE_VIGNETTE == 1)
  #include "SweetFX\Shaders\Vignette.h"
  #define Need_sRGB 1
#endif

#if (USE_DITHER == 1)
  #include "SweetFX\Shaders\Dither.h"
  #define Need_sRGB 1
#endif

#if (USE_BORDER == 1)
  #include "SweetFX\Shaders\Border.h"
  #define Need_sRGB 1
#endif

#if (USE_SPLITSCREEN == 1)
  #include "SweetFX\Shaders\Splitscreen.h"
  #define Need_sRGB 1
#endif

  /*--------------------.
  | :: Effect passes :: |
  '--------------------*/

float4 SweetFX_main(float2 tex, float4 FinalColor)
{

  /*--------------------.
  | :: Effect passes :: |
  '--------------------*/

  // Custom
  #if (USE_CUSTOM == 1)
    FinalColor = CustomPass(FinalColor,tex);
  #endif

  // Explosion
  #if (USE_EXPLOSION == 1)
    FinalColor = ExplosionPass(FinalColor,tex);
  #endif

  // Cartoon
  #if (USE_CARTOON == 1)
	FinalColor = CartoonPass(FinalColor,tex);
  #endif

  // Advanced CRT
  #if (USE_ADVANCED_CRT == 1)
	FinalColor = AdvancedCRTPass(FinalColor,tex);
  #endif
  
  // SweetCRT
  #if (USE_SWEETCRT == 1)
    FinalColor = SweetCRTPass(FinalColor,tex);
  #endif

  // Bloom
  #if (USE_BLOOM == 1)
	FinalColor = BloomPass (FinalColor,tex);
  #endif

  // HDR
  #if (USE_HDR == 1)
	FinalColor = HDRPass (FinalColor,tex);
  #endif

  // LumaSharpen
  #if (USE_LUMASHARPEN == 1)
	FinalColor = LumaSharpenPass(FinalColor,tex);
  #endif

  // Levels
  #if (USE_LEVELS == 1)
	FinalColor = LevelsPass(FinalColor);
  #endif

  // Technicolor
  #if (USE_TECHNICOLOR == 1)
	FinalColor = TechnicolorPass(FinalColor);
  #endif

  // DPX
  #if (USE_DPX == 1)
	FinalColor = DPXPass(FinalColor);
  #endif

  // Monochrome
  #if (USE_MONOCHROME == 1)
	FinalColor = MonochromePass(FinalColor);
  #endif

  // Lift Gamma Gain
  #if (USE_LIFTGAMMAGAIN == 1)
	FinalColor = LiftGammaGainPass(FinalColor);
  #endif

  // Tonemap
  #if (USE_TONEMAP == 1)
	FinalColor = TonemapPass(FinalColor);
  #endif

  // Vibrance
  #if (USE_VIBRANCE == 1)
	FinalColor = VibrancePass(FinalColor);
  #endif

  // Curves
  #if (USE_CURVES == 1)
	FinalColor = CurvesPass(FinalColor);
  #endif

  // Sepia
  #if (USE_SEPIA == 1)
    FinalColor = SepiaPass(FinalColor);
  #endif

  // Vignette
  #if (USE_VIGNETTE == 1)
	FinalColor = VignettePass(FinalColor,tex);
  #endif

  // Dither (should go near the end as it only dithers what went before it)
  #if (USE_DITHER == 1)
	FinalColor = DitherPass(FinalColor,tex);
  #endif

  // Border
  #if (USE_BORDER == 1)
    FinalColor = BorderPass(FinalColor,tex);
  #endif

  // Splitscreen
  #if (USE_SPLITSCREEN == 1)
	  FinalColor = SplitscreenPass(FinalColor,tex);
  #endif

  // Return FinalColor
  //FinalColor.a = 1.0; //Clear alpha channel to reduce filesize of screenshots that are converted to png and avoid problems when viewing the screenshots.
  return FinalColor;
}
