
pp.PrLibrary = cc.Class.extend({

    name: "",
    unlockeds: null,

    ctor: function (unlockeds, name) {
        //this._super();

        this.unlockeds = unlockeds;
        this.name = name;
    },

    reset: function () {
        for (var i = 0; i < this.unlockeds.length; i++)
            this.unlockeds[i] = false;

        tm.saveTmd();
    },

    unlockAll: function () {
        for (var i = 0; i < this.unlockeds.length; i++)
            this.unlockeds[i] = true;

        tm.saveTmd();
    },

    unlock: function (id) {
        if (!pp.isIdValid(id))
            return false;

        if (this.unlockeds[id]) {
            return false;
        }
        else {
            this.unlockeds[id] = true;

            tm.saveTmd();

            //cc.log("PrLibrary (" + this.name + ") Unlocked: id = " + id)

            return true;
        }
    },

    isLocked: function (id) {
        return !this.unlockeds[id];
    },

    isUnlocked: function (id) {
        return this.unlockeds[id];
    }

});

pp.LibItem = pp.PrLibrary.extend({

    sortedItems: null,

    ctor: function () {
        this._super(tmd.unlockedItemIds, "アイテム");
    },

    isSortedItemLocked: function (sortedIdx) {
        var id = this.sortedItems[sortedIdx].id;
        return this.isLocked(id);
    },

    getSortedItems: function () {
        if (!this.sortedItems) {
            var sortedItems = [];
            for (var i = 0; i < pp.world.items.length; i++) {
                sortedItems.push(pp.world.items[i]);
            }
            sortedItems.sort(function (itemA, itemB) {
                return itemA.price - itemB.price;
            });
            this.sortedItems = sortedItems;
        }
        return this.sortedItems;
    },

    idToSortedIdx: function (id) {
        var sortedItems = this.getSortedItems();
        for (var i = 0; i < sortedItems.length;i++) {
            if (sortedItems[i].id == id) return i;
        }
        return pp.idInvalid;
    },

    /*
    sortedIdToId: function (sortedId) {
        return this.getSortedItems()[sortedId].id;
    },
    */

    unlockForPerson: function (pid) {

        var person = pp.world.persons[pid];

        for (var i = 0; i < this.unlockeds.length; i++) {
            if (person.itemNums[i] > 0) this.unlock(i); //pp.libItem.idToSortedId(i));
        }
    }
});

pp.LibFigure = pp.PrLibrary.extend({

    ctor: function () {
        this._super(tmd.unlockedFigureIds, "スケッチ");
    }
});

pp.LibCut = pp.PrLibrary.extend({

    ctor: function () {
        this._super(tmd.unlockedCutIds, "イベント絵");
    }
});
