
pp.PrMediator = cc.Class.extend({

    // dummies for properties.
    person: null,
    scn: null,
    toShowMessage: null,
    messageWaitInSec: 0,

    personId: 0,
    currentScene: 0,

    waitingMode: 0,

    bgm: 0,
    bgmIdxForMusicRoom: 0,
    toShowMessageTemporary: false,
    toShowMenuInDemo: false,
    isDebug: false,
    isCheckingText: false,
    isDemo: false,
    toResetManualAfterThisTurn: false,
    sprClickMark: null,
    lastClickPos: null,

    gameState: 0,
    pidEnding: 0,

    listType: 0,
    filterType: 0,
    discType: 0,
    accessaryType: 0,

    gameOverReason: 0,

    saveDataTitles: null,

    monthNotified: false,

    popUps: null,
    balloons: null,

    personDId: 0,
    personEId: 0,

    logMonth: "",
    scnGame: null,
    isFirstPersonOfMonth: null,

    ctor: function () {

        this.personId = pp.ID_INVALID;
        this.currentScene = pp.scnTitle;
        this.bgm = "";
        this.bgmIdxForMusicRoom = pp.idxInvalid;

        this._name = "PrMediator";

        this.wuiSetWaitingMode(pp.MW_NOT_WAITING);

        this.popUps = [];
        this.balloons = [];
        this.isDemo = false;
        this.toShowMenuInDemo = false;
        this.isDebug = false;
        this.isCheckingText = false;
        this.toResetManualAfterThisTurn = false;
        this.lastClickPos = cc.p(0, 0);

        this.logMonth ="";
    },

    getPerson: function () {
        return this.personId == pp.ID_INVALID ? null : pp.world.persons[this.personId];
    },

    getScn: function () {
        return cc.director.getRunningScene();
    },

    getScnGame: function () {
        return this.scnGame;
    },

    getToShowMessage: function () {
        return tmd.toShowCpuTurn == pp.ctCheckAll || this.toShowMessageTemporary || (this.person && this.person.isManual) || (pp.world.interestedPersonId != pp.idInvalid && pp.world.interestedPersonId == this.personId);
    },

    doSetBgm: function (newBgm) {

        var prevBgm = this.bgm;

        cc.audioEngine.stopMusic();

        if (newBgm) {
            cc.audioEngine.playMusic(newBgm, true);
        }
        this.bgm = newBgm;

        return prevBgm;
    },

    stopBgm: function () {
        return this.doSetBgm("");
    },

    getBgm: function () {
        return this.bgm;
    },

    setBgm: function (newBgm, delay) {

        if (this.bgm != newBgm) {

            if (delay) {
                pp.mediator.scn.scheduleOnce(function () {
                    pp.mediator.doSetBgm(newBgm);
                }, delay);

                return this.stopBgm();
            }
            else {
                return this.doSetBgm(newBgm);
            }
        }

        return this.bgm;
    },

    playSound: function (sound, delay, forced) {
        if (!this.toShowMessage　&& !forced)
            return;

        if (delay) {
            pp.mediator.scn.scheduleOnce(function () {
                cc.audioEngine.playEffect(sound);
            }, delay);
        }
        else {
            cc.audioEngine.playEffect(sound);
        }
    },

    getDateString: function () {
        return pp.prDate(pp.world.year, pp.world.month);
    },

    getDateStringWithDay: function () {
        return pp.prDateWithDay(pp.world.year, pp.world.month, 1);
    },

    log: function (mes) {
        cc.log(mes); //@@@

        var frmLog = this.scnGame.frmLog;
        if (frmLog) {
            frmLog.add(mes);
        }
    },

    logTemp: function (mes) {
        cc.log(mes); //@@@

        var frmLog = this.scnGame.frmLog;
        if (frmLog) {
            frmLog.addTemp(mes);
        }
    },

    logRemoveTemp: function () {
        var frmLog = this.scnGame.frmLog;
        if (frmLog) {
            frmLog.removeTemp();
        }
    },

    logStartMonth: function () {
        var mes = this.getDateString();

        cc.log(mes); //@@@

        var frmLog = this.scnGame.frmLog;
        if (frmLog) {
            frmLog.startMonth(mes);
        }
    },

    logPersonCommand: function (personId, commandStr) {
        var person = pp.world.persons[personId];

        this.log("(" + person.name + "): " + commandStr);
    },

    getMessageWaitInSec: function () {
        switch (tmd.messageSpeed) {
            case 0: return 1;
            case 1: return 5;
            case 2: return 10;
            case 3: return 0;
        }
    },

    updateIsDemo: function () {
        this.isDemo = true;

        var persons = pp.world.persons;
        for (var i = 0; i < persons.length; i++) {
            var person = persons[i];
            if (person.isManual && person.state == pp.pcActive) {
                this.isDemo = false;
                break;
            }
        }
    },

    //----------------------------------------------------------------------

    uiUpdate: function (forced) {

        var scn = this.scn;
        if (scn && scn.lyrMap) {
            scn.lyrMap.updateColorForSeason();
        }

        if (scn instanceof pp.Scn) {
            scn.uiUpdate();
        }
    },

    uiSetSceneMode: function (scnMode) {
        var scn = this.scn;  //pp.scn();

        if (scn instanceof pp.ScnGame) {
            scn.setMode(scnMode);
        }
    },

    uiClearOverlappedPopups: function (num) {

        var num = num || this.popUps.length;

        for (var i = 0; i < num; i++) {
            var popup = this.popUps.pop();

            if (popup) {
                popup.doLastAnimeForOverlapped();
            }
        }
    },

    uiCustomAction: function (actionId) {

        if (cc.isFunction(this.scn.onCustomAction)) {
            this.scn.onCustomAction(actionId);
        }
        else {
            cc.assert(false, "INVALID call of uiCustomAction!");
        }
    },

    uiBlinkPerson: function (personId) {

        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        this.scn.lyrMap.blinkPerson(personId);
    },

    uiUpdatePlace: function (placeId) {
        if (this.scnGame instanceof pp.ScnGame) this.scnGame.lyrMap.updatePlace(placeId);
    },

    uiUpdateAllPlaces: function () {
        if (this.scnGame instanceof pp.ScnGame) this.scnGame.lyrMap.updateAllPlaces();
    },

    uiIsShownCommandWindow: function () {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        return this.scn.frmCommand.isShown;
    },

    uiShowCommandWindow: function (animated) {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        this.scn.frmCommand.show(animated);
    },

    uiHideCommandWindow: function (animated) {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        this.scn.frmCommand.hide(animated);
    },

    uiIsShownPersonWindow: function () {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        return this.scn.frmPerson && this.scn.frmPerson.isShown;
    },

    uiShowPersonWindow: function (animated) {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        if (this.scn.frmPerson)
            this.scn.frmPerson.show(animated);
    },

    uiHidePersonWindow: function (animated) {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        if (this.scn.frmPerson)
            this.scn.frmPerson.hide(animated);
    },

    uiShowDarkWall: function (opacity) {
        var opacity = cc.isUndefined(opacity) ? 128 : opacity;
        this.scn.lyrDarkWall.opacity = opacity;
    },

    uiHideDarkWall: function () {
        this.uiShowDarkWall(0);
    },

    uiSetEnabledPager: function (val) {
        cc.assert(this.scn instanceof pp.ScnGame, "INVALID scn.");

        if (this.scn.frmPager) {
            if (this.isDemo) {
                this.scn.frmPager.menu.enableItem(0, val);
            }
            else {
                this.scn.frmPager.menu.setEnabled(val);
                this.scn.frmPager.menu.setSelectedIndex(pp.PG_MAP);
            }
        }
    },

    uiShowClickMark: function (parent, type, color, pos) {

        if (tmd.messageSpeed != 3 && pp.mediator.waitingMode != pp.MW_USER)
            return;

        this.uiRemoveClickMark();

        pos = pos || cc.p(0, 0);

        var spr;
        var image;

        switch (type) {
            default:
            case pp.clmCleanup:
                image = res.Img_ShpNext64x64;
                break;

            case pp.clmMore:
                image = res.Img_ShpTriangle64x64;
                break;
        }

        spr = new pp.SprClickMark(parent, image);
        if (color) spr.color = color;
        spr.x += parent.scaleX < 0 ? -pos.x : pos.x;
        spr.y += pos.y;
        parent.addChild(spr, 1);

        this.sprClickMark = spr;
    },

    uiRemoveClickMark: function () {

        if (this.sprClickMark) {
            this.sprClickMark.removeFromParent();
        }

        this.sprClickMark = null;
    },

    uiGetMapScale: function () {
        if (this.scn instanceof pp.ScnGame) {
            return this.scn.lyrMap.scrView.getZoomScale();
        }
        return 1;
    },

    uiSetMapScale: function (scale) {
        if (this.scn instanceof pp.ScnGame) {
            this.scn.lyrMap.scrView.setZoomScale(scale, true);
        }
    },

    //----------------------------------------------------------------------

    wuiWaitUserInput: function () {
        this.wuiSetWaitingMode(pp.MW_USER);
    },

    //----------------------------------------------------------------------

    wuiSetScene: function (scnClass, arg0, transitionClass, delay) {
        var transitionClass = transitionClass || cc.TransitionFade;
        this.wuiSetWaitingMode(pp.MW_ANIME);

        var scn = new scnClass(arg0);

        if (scn instanceof pp.ScnGame) {
            this.scnGame = scn;
        }

        var tranScn = transitionClass.create(delay || 0.5, scn); // TransitionFlipX only works in cocos2dx v2 style...

        //cc.log("SET-SCENE: " + scn._name);
        cc.director.runScene(tranScn);
    },

    wuiPushScene: function (scnClass, arg0, transitionClass, delay) {
        //var transitionClass = transitionClass || cc.TransitionFlipX;
        this.wuiSetWaitingMode(pp.MW_ANIME);

        var scn = new scnClass(arg0);

        //cc.log("PUSH-SCENE: " + scn._name);

        if (transitionClass) {
            var tranScn = transitionClass.create(delay || 3, scn); // TransitionFlipX only works in cocos2dx v2 style...
            cc.director.pushScene(tranScn);
        }
        else {
            cc.director.pushScene(scn);
        }
    },

    wuiPopScene: function (transitionClass, delay) {
        //var transitionClass = transitionClass || cc.TransitionFlipX;
        this.wuiSetWaitingMode(pp.MW_ANIME);

        //cc.log("POP-SCENE");

        if (transitionClass) {

            if (tm.isNative()) {

                var transitionType =
                    transitionClass == cc.TransitionFade ? tm.TransitionFade :
                    transitionClass == cc.TransitionFlipX ? tm.TransitionFlipX :
                    transitionClass == cc.TransitionSlideInL ? tm.TransitionSlideInL :
                                tm.TransitionFade;

                cc.director.popSceneWithTransition(delay || 3, transitionType);
            }
            else {
                cc.director.popSceneWithTransitionB(transitionClass, delay || 3);
            }
        }
        else {
            cc.director.popScene();
        }
    },

    wuiShowClickToStart: function () {
        this.wuiSetWaitingMode(pp.MW_USER);

        // Click to Start
        var label = new tm.LabelTTF(tm.m("Tap to Start", "Click to Start"), pp.font, tm.m(42, 28), cc.color.BLACK);
        label.attr({
            x: cc.winSize.width / 2,
            y: cc.winSize.height * 0.3
        });
        //label.enableStroke(cc.color.BLACK, 1);
        label.runAction(
            tm.repeatForever(
                cc.delayTime(1),
                cc.fadeTo(0.1, 0),
                cc.delayTime(0.4),
                cc.fadeTo(0.1, 255),
                cc.delayTime(0.4)
            )
        );

        this.scn.addChild(new pp.Wall(label, function () {
            this.suiDidGetUserInput();
        }, this), 100);
    },

    wuiShowMessage: function (message, caption, backOpacity, frameType, captionType, forceWaitUser) {

        this.wuiSetWaitingMode(pp.MW_USER | (forceWaitUser ? 0 : pp.MW_TIMEOUT));

        var pop = new pp.PopMessage(message, caption, function () {
            this.suiDidGetUserInput();
        }, this, backOpacity, frameType, captionType);

        this.uiShowClickMark(pop.frame0, pp.clmCleanup);

        this.scn.addChild(pop, 100);
    },

    wuiShowTutorial: function (message, keepBalloons, popPos, caption) {

        this.wuiSetWaitingMode(pp.MW_USER);

        if (popPos) pp.Pop_position = popPos;

        this.scn.addChild(new pp.PopTutorial(message, caption, function () {
            this.suiDidGetUserInput();

            if (!keepBalloons) pp.mediator.cleanUpBalloons();
        }, this), 100);

        if (popPos) pp.Pop_position = cc.p(0,0);

        pp.world.tutorialLastMessage = message;
    },

    wuiShowMessageEx: function (message, image, backOpacity) {

        this.wuiSetWaitingMode(pp.MW_USER);

        pp.mediator.stopBgm();

        this.scn.addChild(new pp.PopMessageEx(message, image, function () {
            this.suiDidGetUserInput();
        }, this, backOpacity, function () {
            pp.mediator.setBgm(res.Mus_Congrats);
        }, this), 100);

    },

    wuiShowLetter: function (subject, body, date, personId, caption, allowOverlap) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var pop = new pp.PopLetter(subject, body, date, personId, caption, function () {
            this.suiDidGetUserInput();
        }, this, allowOverlap);

        this.scn.addChild(pop, 100);

        this.uiShowClickMark(pop.frame0, allowOverlap ? pp.clmMore : pp.clmCleanup);
    },

    wuiShowPerson: function (personId, pageIdx, caption, frameTypeOrOptions, waitingMode, popPos, allowOverlap) {
        this.wuiSetWaitingMode(waitingMode || pp.MW_USER_OR_TIMEOUT);

        var scn = cc.director.getRunningScene();

        if (popPos) {
            pp.Pop_position = popPos;
            pp.Pop_margin_side = tm.m(-58, -18);
            pp.Pop_margin_vertical = 9;
        }

        var popup = new pp.PopPerson(personId, pageIdx, caption, frameTypeOrOptions, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, null, allowOverlap);

        scn.addChild(popup, 100);

        if (popPos) {
            pp.Pop_position = cc.p(0,0);
            pp.Pop_margin_side = 0;
            pp.Pop_margin_vertical = 0;
        }

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },

    wuiShowReportTabbed: function (reportId, caption, waitingMode, backOpacity, allowOverlap) {

        this.wuiSetWaitingMode(waitingMode || pp.MW_USER_OR_TIMEOUT);

        var popup = new pp.PopReportTabbed(reportId, caption, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, backOpacity, allowOverlap);

        this.scn.addChild(popup, 100);

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },

    wuiShowPrObj: function (popClass, id, waitingMode, backOpacity, allowOverlap, options) {

        this.wuiSetWaitingMode(waitingMode || pp.MW_USER_OR_TIMEOUT);

        var popup = new popClass(id, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, backOpacity, allowOverlap, options);

        this.scn.addChild(popup, 100);

        //this.uiShowClickMark(popup.frame0, allowOverlap ? pp.clmMore : pp.clmCleanup);

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },

    //------

    uiShowArrow: function (targetPos, baseAlignOrPos) {
        this.uiShowBalloon("", targetPos, baseAlignOrPos);
    },

    uiShowBalloon: function (caption, targetPos, bodyAlignOrPos) {

        var scn = cc.director.getRunningScene();

        var bodyPos;
        var bodyAlign;
        var distX = 100;
        var distY = 100;
        if (cc.isNumber(bodyAlignOrPos) || !bodyAlignOrPos) {
            bodyAlign = bodyAlignOrPos || tm.m(pp.ALIGN_TOP_LEFT, pp.ALIGN_BOTTOM_LEFT);
            switch (bodyAlign) {
                default:
                case pp.ALIGN_BOTTOM_LEFT:
                    bodyPos = cc.p(targetPos.x - distX, targetPos.y - distY);
                    bodyAlignOrPos = pp.ALIGN_BOTTOM_LEFT;
                    break;
                case pp.ALIGN_BOTTOM_RIGHT:
                    bodyPos = cc.p(targetPos.x + distX, targetPos.y - distY);
                    break;
                case pp.ALIGN_TOP_LEFT:
                    bodyPos = cc.p(targetPos.x - distX, targetPos.y + distY);
                    break;
                case pp.ALIGN_TOP_RIGHT:
                    bodyPos = cc.p(targetPos.x + distX, targetPos.y + distY);
                    break;
            }
        }
        else {
            bodyPos = bodyAlignOrPos;
            bodyAlign = pp.ALIGN_BOTTOM_LEFT;
        }

        var xdiff = targetPos.x - bodyPos.x;
        var ydiff = targetPos.y - bodyPos.y;
        var spr = new pp.SprFlatBalloon(caption, xdiff, ydiff, null, bodyAlign);
        spr.attr({
            x: bodyPos.x,
            y: bodyPos.y
        });
        scn.addChild(spr, 200);
        spr.setActionToSync(this.scn.act800ms);

        this.addBalloon(spr);
    },

    addBalloon: function (balloon) {
        this.balloons.push(balloon);
    },

    hideBalloons: function () {
        this.balloons.map(function (balloon) { balloon.visible = false;});
    },

    showBalloons: function () {
        this.balloons.map(function (balloon) { balloon.visible = true;});
    },

    cleanUpBalloons: function () {
        while (this.balloons.length > 0) {
            var balloon = this.balloons.pop();
            balloon.removeFromParent();
        }
    },

    //------

    wuiShowVoice: function (personId, image, voice, caption, allowOverlap) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var pop = new pp.PopVoice(personId, image, voice, caption, function () {
            this.suiDidGetUserInput();
        }, this, null, allowOverlap);

        if (pop.voices.length > 1) {
            this.uiShowClickMark(pop.sprVoice, pp.clmMore, cc.color.BLACK, cc.p(pop.sprVoice.scaleX < 0 ? -20 : 0, 0));
        }
        else {
            this.uiShowClickMark(pop.frame0, allowOverlap ? pp.clmMore : pp.clmCleanup);
        }

        this.scn.addChild(pop, 100);

        if (allowOverlap) {
            this.popUps.push(pop);
        }
    },

    wuiShowVoiceS: function (personIdx, voice, allowOverlap, allowStay) {

        cc.assert(this.scn instanceof pp.ScnSociety, "Invalid scn...");

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        this.scn.showVoice(personIdx, voice, allowOverlap, allowStay);

        this.uiShowClickMark(this.scn.getLastVoice(), pp.clmMore, cc.color.BLACK, cc.p(0, 20));
    },

    wuiSetFocusOnPlace: function (placeId) {

        //cc.assert(this.scn instanceof pp.ScnGame, "Invalid scn...");
        if (this.scn instanceof pp.ScnGame) {
            this.wuiSetWaitingMode(pp.MW_ANIME);

            this.scn.lyrMap.setFocus(placeId, function () {
                this.suiDidAnime();
            }, this);
        }
        else {
            this.scn.scheduleOnce(function () {
                pp.story.didWaitMediator();
            }, 0);
        }
    },


    //@@@
    wuiShowCut: function (image) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var allowOverlap = true;

        var popup = new pp.Pop(new cc.Sprite(image), "", pp.POP_FRM_NO_BUTTONS, function () {
            this.suiDidGetUserInput();
        }, this, 1, pp.POP_CAPTION_NONE, allowOverlap, pp.POP_ANIME_SIMULTANEOUS);

        popup.y += 35;
//        popup.x -= 260;

        this.scn.addChild(popup, 100);

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },
    //@@@
    wuiShowMessageTmp: function (message, caption, backOpacity) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var pop = new pp.PopMessage(message, caption, function () {
            this.suiDidGetUserInput();
        }, this, backOpacity);
        pop.y -= 200;
        this.scn.addChild(pop, 100);
    },
    //@@@
    uiShowCongrats: function () {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var frm = new tm.Scale9SpriteTiled(res.Img_FrmDate);
        frm.attr({
            x: this.scn.width / 2,
            y: this.scn.height * 0.85
        });
        var spr = new cc.Sprite(res.Img_Congrats);
        frm.setContentSize(spr.width + 80, spr.height + 80);
        spr.attr({
            x: frm.width/2,
            y: frm.height/2
        });
        frm.addChild(spr);
        this.scn.addChild(frm, 100);
    },




    wuiShowThankYou: function (personId) {

        this.wuiSetWaitingMode(pp.MW_USER);

        //this.toWaitUserSelection = true;

        var popup = new pp.Pop(
            new pp.LyrThankYou(personId),
            "",
            pp.POP_FRM_OK_BUTTON,
            function () {
                this.suiDidGetUserInput();

                //his.toWaitUserSelection = false;
            },
            this,
            1,
            pp.POP_CAPTION_NONE,
            false,
            pp.POP_ANIME_SIMULTANEOUS
        );

        this.scn.addChild(popup, 100);
    },


    wuiShowBigMessage: function (message, align) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        this.scn.addChild(new pp.WallBigMessage(message, function () {
            this.suiDidGetUserInput();
        }, this, align), 100);
    },

    wuiShowCutS: function (image) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var allowOverlap = true;

        var spr = new cc.Sprite(image);
        spr.attr({
            scale: tm.m(1.5, 1),
            anchorX: 0,
            anchorY: 0
        });
        var lyr = new cc.LayerColor(cc.color(0,0,0,0), spr.width * spr.scaleX, spr.height * spr.scaleY);
        lyr.addChild(spr);
        var popup = new pp.Pop(lyr, "", pp.POP_FRM_NO_BUTTONS, function () {
            this.suiDidGetUserInput();
        }, this, 1, pp.POP_CAPTION_NONE, allowOverlap, pp.POP_ANIME_SIMULTANEOUS);

        popup.y += tm.m(280, 80);
        popup.x -= tm.m(0, 260);

        this.scn.addChild(popup, 1);

        this.uiShowClickMark(popup.frame0, allowOverlap ? pp.clmMore : pp.clmCleanup);

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },

    wuiShowReportS: function (reportId) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var allowOverlap = tm.m(false, true);

        var report = pp.world.reports[reportId];

        if (tm.m()) {
            pp.mediator.scn.setReportId(reportId);

            pp.Pop_from_pos = cc.p(cc.winSize.width - 20 - 32, cc.winSize.height - 45 - 12 - 32);
        }

        var popup = new pp.PopReportTabbed(reportId, report.getTitle(), function (sel) {
            this.suiDidGetUserInput();
        }, this, null, allowOverlap);

        popup.x += tm.m(0, 235);
        popup.y += tm.m(0, 140);

        this.scn.addChild(popup, tm.m(102, 1));

        this.uiShowClickMark(popup.frame0, pp.clmMore);

        if (allowOverlap) {
            this.popUps.push(popup);
        }
    },

    wuiShowTheme: function (themeId, waitingMode, buttonType) {
        this.wuiSetWaitingMode(waitingMode || pp.MW_USER_OR_TIMEOUT);

        buttonType = buttonType || pp.POP_FRM_NO_BUTTONS;

        this.scn.addChild(new pp.PopTheme(themeId, buttonType, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this), 100);
    },

    wuiShowParamChange: function (paramName, fromVal, toVal, paramOwnerName, allowOverlap, popPos) {

        this.wuiSetWaitingMode(pp.MW_USER | pp.MW_TIMEOUT);

        var scn = cc.director.getRunningScene();

        if (popPos) pp.Pop_position = popPos;

        var pop = new pp.PopParamChange(paramName, fromVal, toVal, paramOwnerName, allowOverlap, function () {
            this.suiDidGetUserInput();
        }, this);

        if (popPos) pp.Pop_position = cc.p(0, 0);

        this.uiShowClickMark(pop.frame0, allowOverlap ? pp.clmMore : pp.clmCleanup);

        scn.addChild(pop, 100);

        if (allowOverlap) {
            this.popUps.push(pop);
        }
    },

    wuiSelectOkCancel: function (messages, frameType) {

        this.wuiSetWaitingMode(pp.MW_USER);

        this.scn.addChild(new pp.PopConfirm(messages, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, null, frameType), 100);
    },

    wuiSelectYesNo: function (messages) {

        this.wuiSetWaitingMode(pp.MW_USER);

        this.scn.addChild(new pp.PopConfirm(messages, function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, null, pp.POP_FRM_YES_NO_BUTTON), 100);
    },

    wuiSelectThemeIdx: function () {

        this.wuiSetWaitingMode(pp.MW_USER);

        this.scn.addChild(new pp.PopDoTheme(function (sel) {
            this.suiDidGetUserInput(sel);
        }, this, this.person), 100);
    },

    wuiSelectOptions: function (options, caption, xMagnitude) {

        this.wuiSetWaitingMode(pp.MW_USER);

        //pp.mediator.toWaitUserSelection = true;
        //cc.log("* toWaitUserSelection=" + pp.mediator.toWaitUserSelection);

        this.scn.addChild(
            new pp.PopStringSelect(
                options,
                caption,
                pp.POP_FRM_NO_CANCEL_BUTTON,
                function (sel) {
                    this.suiDidGetUserInput(sel);

                    //pp.mediator.toWaitUserSelection = false;
                    //cc.log("* toWaitUserSelection=" + pp.mediator.toWaitUserSelection);
                },
                this,
                xMagnitude)
            ,100);
    },

    wuiSelectOptionsWithCancel: function (options, caption, xMagnitude, backOpacity, frameType, fontSize) {

        this.wuiSetWaitingMode(pp.MW_USER);

        var frameType = frameType || pp.POP_FRM_CANCEL_BUTTON;

        this.scn.addChild(
            new pp.PopStringSelect(
                options,
                caption,
                frameType,
                function (sel) {
                    this.suiDidGetUserInput(sel);
                },
                this,
                xMagnitude,
                backOpacity,
                fontSize)
            ,100);
    },

    wuiSelectTheme: function () {

        this.wuiSetWaitingMode(pp.MW_USER);

        var frame = new pp.PopThemeMap(
            function (sel) {
                this.suiDidGetUserInput(sel);
            },
            this);
        this.scn.addChild(frame, 100);
    },

    wuiSelectPerson: function (caption, filterType) {

        this.wuiSetWaitingMode(pp.MW_USER);

        var filterType = filterType || pp.flActive;

        var options1 = [];
        var options2 = [];
        var ids = [];
        var firstSelectedIdx = pp.idxInvalid;
        var fieldNames;
        var fieldAligns;
        var fieldWidths;
        var images = [];

        pp.world.persons.forEach(function (person) {

            if (person.state == pp.pcActive ||
                (filterType == pp.flTextCheck && person.state == pp.pcYoung)) {
                var place = pp.world.places[person.placeId];

                options1.push([person.getFullName(), person.getAge(), person.fame, person.money, place.name, person.getImageFileName()]);
                options2.push([person.getFullName(),
                        person.fieldPs[pp.fdAstronomy].getAptitudeStr(),
                        person.fieldPs[pp.fdMechanics].getAptitudeStr(),
                        person.fieldPs[pp.fdHeat].getAptitudeStr(),
                        person.fieldPs[pp.fdBiology].getAptitudeStr(),
                        person.fieldPs[pp.fdOptics].getAptitudeStr(),
                        person.fieldPs[pp.fdMathematics].getAptitudeStr(),
                        person.fieldPs[pp.fdEngineering].getAptitudeStr(),
                        person.fieldPs[pp.fdDrawing].getAptitudeStr()]);

                ids.push(person.id);

                if (person.id == this.prevSelectedPersonId) {
                    firstSelectedIdx = ids.length - 1;
                }
            }
        }, this);

        var fields = pp.world.fields;

        fieldNames = [
            [ __("名前"), __("年齢"), __("名声"), __("資金"), __("所在地"), "image" ],
            [ __("名前"),
                fields[pp.fdAstronomy].name2,
                fields[pp.fdMechanics].name2,
                fields[pp.fdHeat].name2,
                fields[pp.fdBiology].name2,
                fields[pp.fdOptics].name2,
                fields[pp.fdMathematics].name2,
                fields[pp.fdEngineering].name2,
                fields[pp.fdDrawing].name2],
            [ __("般"), __("適") ]
        ];

        fieldWidths = [
            [ 300, 60, 70, 70, 200 ],
            [ 300, 60, 60, 60, 60, 60, 60, 60, 60 ]
        ];

        fieldAligns = [
            [ pp.LEFT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.LEFT ],
            [ pp.LEFT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT, pp.RIGHT ]
        ];

        var frame = new pp.PopListSelect(
            fieldNames,
            fieldWidths,
            fieldAligns,
            [options1, options2],
            caption,
            function (sel) {
                if (sel == pp.POP_WAS_CANCEL) {
                    this.suiDidGetUserInput(pp.ID_INVALID);
                }
                else {
                    this.suiDidGetUserInput(ids[sel]);

                    this.prevSelectedPersonId = ids[sel];
                }
            },
            this,
            0,
            false
        );

        if (firstSelectedIdx != pp.idxInvalid)
            frame.setSelected(firstSelectedIdx);

        this.scn.addChild(frame, 100);
    },

    wuiSelectPrObj: function(objType, filterType) {

        this.wuiSetWaitingMode(pp.MW_USER);

        var pop = new pp.PopListSelectPr(
            objType,
            filterType,
            function (sel) {
                this.suiDidGetUserInput(sel);
            },
            this,
            false
        );

        this.scn.addChild(pop, 100);
    },

    //----------------------------------------------------------------------

    wuiEffectItemSelected: function (itemId, pos, backword) {

        this.wuiSetWaitingMode(pp.MW_ANIME);

        var item = pp.world.items[itemId];
        pos = pos || cc.p(this.scn.width/2, this.scn.height/2);

        var spr = new cc.Sprite(item.picture);
        spr.attr({
            scale: backword ? 1/2 : 3,
            opacity: backword ? 255 : 1,
            x: pos.x,
            y: pos.y
        });

        this.scn.addChild(spr, 100);

        if (backword)
            pp.mediator.playSound(res.Snd_Unselect);
        else
            pp.mediator.playSound(res.Snd_OK, 1);

        spr.runAction(
            cc.sequence(
                cc.spawn(
                    cc.scaleTo(1, backword ? 3 : 1/2),
                    cc.fadeTo(1, backword ? 1 : 255),
                    cc.rotateBy(1, 360*2)
                ),
                cc.callFunc(function () {
                    this.suiDidAnime();
                }, this),
                cc.removeSelf()
            )
        );
    },

    //----------------------------------------------------------------------

    wuiSetWaitingMode: function (mode) {
        this.waitingMode = mode;

        if (false)
            switch (mode) {
                case pp.MW_NOT_WAITING: cc.log("MW_NOT_WAITING"); break;
                case pp.MW_ANIME: cc.log("MW_ANIME"); break;
                case pp.MW_TIMEOUT: cc.log("MW_TIMEOUT"); break;
                case pp.MW_USER: cc.log("MW_USER"); break;
                case pp.MW_USER_OR_TIMEOUT: cc.log("MW_USER_OR_TIMEOUT"); break;
            }
    },

    suiDidGetUserInput: function (selection) {
        if (this.waitingMode & pp.MW_USER) {

            this.uiRemoveClickMark();

            pp.story.didWaitMediator(selection);
            //cc.log("Waited User." + (cc.isUndefined(selection) ? "" : ("sel = " + selection)));
        }
        else {
            cc.log("!! Got UI sel (" + selection + "). Ignore...");
        }
    },

    suiDidAnime: function () {
        if (this.waitingMode & pp.MW_ANIME) {
            pp.story.didWaitMediator();
            //cc.log("Waited Anime.");
        }
        else {
            cc.log("!! Got Anime. Ignore...");
        }
    },

    suiDidTimeOut: function () {
        if (this.waitingMode & pp.MW_TIMEOUT) {
            pp.story.didWaitMediator();
            //cc.log("Waited timeout.");
        }
        else {
            cc.log("!! Got timeout. Ignore...");
        }
    }

});


//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrMediator.prototype;
cc.defineGetterSetter(_p, "person", _p.getPerson);
cc.defineGetterSetter(_p, "scn", _p.getScn);
cc.defineGetterSetter(_p, "toShowMessage", _p.getToShowMessage);
cc.defineGetterSetter(_p, "messageWaitInSec", _p.getMessageWaitInSec);
