var lc = lc || {};

lc.loadDatabase = function (callback, target) {

    var dbs = {
        "jp": res.Db_Strings,
        "en": res.Db_StringsEn,
        "zh": res.Db_StringsZh
    };

    cc.async.map(
        dbs,
        function(value, key, cb) {
            cc.loader.loadJson(value, cb);
        },
        function (err, results) {
            if (err) {
                cc.log(err);
            }
            else {
                lc.id_jp = results["jp"][0];
                lc.id_en = results["en"][0];
                lc.id_zh = results["zh"][0];

                callback.call(target);
            }
        }
    );
};

lc.id_jp = {};

lc.id_en = {};

lc.id_zh = {};

__1 = function (arg) { return __(arg); }; // to ignore second arg :)

__ = function (arg0) {

    if (cc.isString(arg0) && arg0.substr(0, 3) == "STR") {
        return lc.id_to_str.apply(null, arguments);
    }
    else {
        if (arguments.length == 1)
            return lc.from_jp(arg0);
        else {
            return lc.from_jp(arg0, arguments[1], arguments[2]);
        }
    }
};

lc.from_jp = function (jpVal, enVal, zhVal) {

    if (tmd.language == pp.LN_JAPANESE)
        return jpVal;

    if (cc.isUndefined(enVal)) {
        // Use dictionary
        var dictionary = tmd.language == pp.LN_ENGLISH ? lc.jp_en : lc.jp_zh;

        if (jpVal in dictionary) {
            var translatedStr = dictionary[jpVal];
            return translatedStr || jpVal;
        }
        else {
            cc.error('locale: Translation Not found for "' + jpVal + '".');
            return jpVal;
        }
    }
    else {
        // Select from arguments
        if (tmd.language == pp.LN_ENGLISH)
            return enVal;
        else if (!cc.isUndefined(zhVal))
            return zhVal;
        else
            return jpVal;
    }
};

lc.id_to_str = function id_to_str (id) {

    var str;

    var dictionary = tmd.language == pp.LN_JAPANESE ? lc.id_jp :
        tmd.language == pp.LN_ENGLISH ? lc.id_en : lc.id_zh;

    if (id in dictionary) {
        str = dictionary[id];
    }

    if (cc.isUndefined(str)) {
        cc.error('locale: Translation Not found for "' + id + '".');
        return id;
    }

    if (arguments.length > 1) {
        var args = Array.prototype.slice.call(arguments, id_to_str.length);
        str = String.prototype.format.apply(str, args);
    }

    return str;
};
