
pp.PrDiscovery = pp.PrObject.extend({

    id: pp.ID_INVALID,
    name: "",
    data: 0,
    deduce: 0,
    engineering: 0,
    importance: 0,
    itemId: pp.ID_INVALID,
    themeId: pp.ID_INVALID,
    type: 0,
    credibility: 0,
    thingName: "",
    voice: "",

    ctor: function (objInDb) {

        this._super();

        this.id = objInDb.id;
        this.name = objInDb.name;
        this.data = objInDb.data;
        this.deduce = objInDb.deduce;
        this.engineering = objInDb.engineering;
        this.importance = objInDb.importance;
        this.itemId = objInDb.item;
        this.themeId = objInDb.theme;
        this.type = objInDb.type;
        this.credibility = objInDb.credibility;
        this.thingName = objInDb.thingName;
        this.voice = objInDb.voice;
    },

    getTypeName: function () {
        return __(pp.ttNames[this.type]);
    },

    getStatusStr: function (personId) {

        var ret = "";
        var person = pp.world.persons[personId];
        var report = person.getReportForDisc(this.id);
        if (report) {
            if (report.societyId == pp.ID_INVALID) {
                ret = __("論文作成済み");
            }
            else {
                ret = __("論文提出済み");
            }
        }
        else {
            switch (this.type) {
                case pp.ttTheory:
                    ret = __("論文未作成");
                    break;

                case pp.ttFigure:
                    if (person.discCredibilities[this.id] == pp.crPreMake)
                        ret = __("未描画");
                    else
                        ret = __("描画済み／論文未作成");
                    break;

                case pp.ttThing:
                case pp.ttBook:
                    ret = __("論文未作成");
                    break;

                case pp.ttItem:
                    if (person.discCredibilities[this.id] == pp.crPreMake)
                        ret = __("未作成");
                    else
                        ret = __("試作済み／論文未作成");
                    break;
            }
        }

        return ret;
    },

    getReportStatusName: function (personId) {
        var person = pp.world.persons[personId];
        var report = person.getReportForDisc(this.id);

        if (report) {
            if (report.societyId == pp.ID_INVALID)
                return __("作成済");
            else
                return __("提出済");
        }
        else
            return __("未作成", "Not Yet");
    },

    getFigurePath: function (isPoor) {
        for (var i = 0; i < pp.figures.length; i++) {
            var figure = pp.figures[i];
            if (figure.discId == this.id) {
                return isPoor ? figure.poorPicture : figure.picture;
            }
        }
        return "";
    },

    getFigureId: function () {

        for (var i = 0; i < pp.figures.length; i++) {
            if (pp.figures[i].discId == this.id)
            return i;
        }
        return pp.idInvalid;
    },

    getReleasedReportId: function () {

        for (var i = 0; i < pp.world.reports.length; i++) {
            var report = pp.world.reports[i];
            if (!pp.isIdValid(report.societyId))
                continue;

            if (report.discoveryId == this.id)
                return i;
        }

        return pp.idInvalid;
    }

});

pp.PrDiscovery.prototype.tableName = function () {
    return "discoveries";
};
