
pp.PrField = pp.PrObject.extend({

    id: pp.ID_INVALID,
    name: "",
    name2: "",
    deduceName: "",
    dataName: "",
    isDeducable: false,
    isDatable: false,

    ctor: function (objInDb) {

        this._super();

        this.id = objInDb["id"];
        this.name = objInDb["name"];
        this.name2 = objInDb["name2"];
        this.deduceName = objInDb["deduceName"];
        this.dataName = objInDb["dataName"];

        this.isDeducable = this.deduceName != undefined;
        this.isDatable = this.dataName != undefined;
    },

    getThemes: function () {

        var themes = [];

        for (var i = 0; i < pp.world.themes.length; i++) {
            var theme = pp.world.themes[i];
            if (theme.fieldId == this.id)
                themes.push(theme);
        }

        return themes;
    },

    getAuthorityCount: function (personId) {

        var count = 0;

        var themes = this.getThemes();
        for (var i = 0; i < themes.length; i++) {
            var theme = themes[i];
            if (pp.world.persons[personId] == theme.getAuthorityPerson()) {
                count++;
            }
        }

        return count;
    }

});

pp.PrField.prototype.tableName = function () {
    return "fields";
};
