
pp.PrPlace = pp.PrObject.extend({

    id: pp.ID_INVALID,
    name: "",
    latitude: 0,
    longitude: 0,
    science: 0,
    infoPos: 0,
    infoPosX: 0,

    ctor: function (objInDb) {

        this._super();

        this.id = objInDb["id"];
        this.name = objInDb["name"];
        this.latitude = objInDb["latitude"];
        this.longitude = objInDb["longitude"];
        this.science = objInDb["science"];

        this.infoPos = objInDb["infoPos"] || 0;
        this.infoPosX = objInDb["infoPosX"] || 0;
    },

    getCostToPlace: function (toPlaceId) {

        var cost =
            Math.abs(this.latitude - pp.world.places[toPlaceId].latitude) +
            Math.abs(this.longitude - pp.world.places[toPlaceId].longitude);

        cost = tm.int(cost/4);

        return cost;
    },

    getPersons: function () {
        var result = [];
        for (var i = 0; i < pp.world.persons.length; i++) {
            var person = pp.world.persons[i];
            if (person.state == pp.pcActive && person.placeId == this.id)
                result.push(person);
        }
        return result;
    },

    getFacilities: function () {

        return [].concat(
            this.getSocieties(),
            this.getUniversities(),
            this.getObservatories()
        );

        /*
        for (var i = 0; i < pp.world.societies.length; i++) {
            var society = pp.world.societies[i];
            if (society.placeId == this.id && society.exist)
                facilities.push(society);
        }

        for (var i = 0; i < pp.world.universities.length; i++) {
            var univ = pp.world.universities[i];
            if (univ.placeId == this.id)
                facilities.push(univ);
        }

        for (var i = 0; i < pp.world.observatories.length; i++) {
            var obs = pp.world.observatories[i];
            if (obs.placeId == this.id)
                facilities.push(obs);
        }

        return facilities;
        */
    },

    getSocieties: function () {
        var result = [];
        for (var i = 0; i < pp.world.societies.length; i++) {
            var society = pp.world.societies[i];
            if (society.placeId == this.id && society.exist)
                result.push(society);
        }
        return result;
    },

    getUniversities: function () {
        var result = [];
        for (var i = 0; i < pp.world.universities.length; i++) {
            var univ = pp.world.universities[i];
            if (univ.placeId == this.id)
                result.push(univ);
        }
        return result;
    },

    getObservatories: function () {
        var result = [];
        for (var i = 0; i < pp.world.observatories.length; i++) {
            var obs = pp.world.observatories[i];
            if (obs.placeId == this.id)
                result.push(obs);
        }
        return result;
    }

});

pp.PrPlace.prototype.tableName = function () {
    return "places";
};

