
pp.PrReport = pp.PrObject.extend({

    //Dummies for properties
    title: null,
    discName: null,
    person: null,
    discovery: null,

    id: pp.ID_INVALID,
    personId: pp.ID_INVALID,
    discoveryId: pp.ID_INVALID,
    societyId: pp.ID_INVALID,
    acceptDate: "",
    composedDate: "",
    backing: 0,
    credibility: 0,
    rejected: false,

    getFieldsToSave: function () {
        return [
            "id", "personId", "discoveryId", "societyId", "acceptDate", "composedDate",
            "backing", "credibility", "rejected"
        ];
    },

    ctor: function (objInDbOrPersonId, discId, societyId) {

        this._super();

        this.id = pp.world.reports ? pp.world.reports.length : pp.idInvalid;

        this.personId = pp.isIdValid(objInDbOrPersonId) ? objInDbOrPersonId : pp.idInvalid;
        this.discoveryId = pp.isIdValid(discId) ? discId : pp.idInvalid;
        this.societyId = pp.isIdValid(societyId) ? societyId : pp.idInvalid;
        this.acceptDate = "";
        this.composedDate = pp.prDateWithDay(pp.world.year, pp.world.month, 1);
        this.backing = 0;
        this.credibility = 0;
        this.rejected = false;

        var objInDb = cc.isNumber(objInDbOrPersonId) ? null : objInDbOrPersonId;

        if (objInDb) {
            this.id = objInDb["id"];
            this.personId = objInDb["author"];
            this.discoveryId = objInDb["discovery"];
            this.societyId = objInDb["society"];
            this.acceptDate = objInDb["acceptdate"];
            this.composedDate = objInDb["composedate"];
            this.backing = objInDb["backing"];
            this.credibility = objInDb["credibility"];
        }

        if (cc.isUndefined(this.societyId)) this.societyId = pp.ID_INVALID;
    },

    getStatusName: function () {
        if (this.societyId == pp.ID_INVALID) {
            return __("未提出");
        }
        return __("公開済");
    },

    getSocietyName: function () {
        if (this.societyId == pp.ID_INVALID) {
            return __("未提出");
        }
        else {
            return pp.world.societies[this.societyId].name;
        }
    },

    getThemeId: function () {
        return pp.world.discoveries[this.discoveryId].themeId;
    },

    getDiscName: function () {
        return pp.world.discoveries[this.discoveryId].name;
    },

    getTitle: function () {
        var ret;
        var disc = pp.world.discoveries[this.discoveryId];

        switch (disc.type) {
            case pp.ttTheory:
                var theme = pp.world.themes[disc.themeId];
                ret = theme.name + __("について", "", "");
                break;

            case pp.ttItem:
                var item = pp.world.items[disc.itemId];
                ret = item.name;
                break;

            case pp.ttThing:
            case pp.ttBook:
            case pp.ttFigure:
                ret = disc.name;
                break;
        }
        return tmi.titleize(ret);
    },

    getCredibilityStr: function () {
        var ret;
        var disc = pp.world.discoveries[this.discoveryId];
        switch (disc.type) {
            case pp.ttTheory:
            case pp.ttFigure:
                ret = "" + this.credibility;
                break;

            case pp.ttThing:
            case pp.ttBook:
            case pp.ttItem:
                ret = "**";
                break;
        }
        return ret;
    },

    getBody: function () {
        var ret;
        var disc = pp.world.discoveries[this.discoveryId];
        var theme = pp.world.themes[disc.themeId];

        switch (disc.type) {
            case pp.ttTheory:
                ret = __(str.s1000, theme.name, disc.name, theme.name);
                    //"私は" +
                    //theme.name + "についての研究を進めるうち「" +
                    //disc.name + "」との結論を得た。この事実は" +
                    //theme.name + "を論じるにあたり、きわめて重要であると思われる。";
                break;

            case pp.ttItem:
                var item = pp.world.items[disc.itemId];
                var field = pp.world.fields[item.fieldId];
                ret = __(str.s1001, theme.name, disc.name, item.name, field.name);
                    //"私は" +
                    //theme.name + "についての研究を進めるうち「" +
                    //disc.name + "」の可能性に気付き、それを製作することに成功した。この『" +
                    //item.name + "』は" +
                    //field.name + "の更なる発展に貢献できる道具である。";
                break;

            case pp.ttThing:
                ret = __(str.s1002, theme.name, disc.name, disc.thingName);
                    //"私は" +
                    //theme.name + "についての研究を進めるうち、いままで存在が知られていなかった「" +
                    //disc.name + "」を発見した。これに対して『" +
                    //disc.thingName +"』という呼称を提案したい。";
                break;

            case pp.ttFigure:
                ret = __(str.s1003, disc.name);
                    //"私はこの度「" +
                    //disc.name + "」の正確な描画を行った。ご覧のように、" +
                    //"今まで明らかでなかった緻密な構造をみせている。";
                break;

            case pp.ttBook:
                ret = __(str.s803, theme.name, disc.name);
                    //"私は長年にわたる" +
                    //theme.name + "についての研究を整理した。この原稿が「" +
                    //disc.name + "」との表題をもって出版されることを期待している。";
                break;

        }
        return ret;
    },

    getAcceptDateStr: function () {
        return this.societyId == pp.ID_INVALID ? "--/--/--" : "" + this.acceptDate;
    },

    getComposedDateStr: function () {
        return this.composedDate;
    },

    getBackingStr: function () {
        return this.societyId == pp.ID_INVALID ? "--" : "" + this.backing;
    },

    getPerson: function () {
        return pp.world.persons[this.personId];
    },

    getDiscovery: function () {
        return pp.world.discoveries[this.discoveryId];
    }

});

pp.PrReport.prototype.tableName = function () {
    return "reportsS1";
};

//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrReport.prototype;
cc.defineGetterSetter(_p, "title", _p.getTitle);
cc.defineGetterSetter(_p, "person", _p.getPerson);
cc.defineGetterSetter(_p, "discovery", _p.getDiscovery);
cc.defineGetterSetter(_p, "discName", _p.getDiscName);
