
pp.PrSociety = pp.PrObject.extend({


    // Dummies for properties
    job0Person: null,
    job1Person: null,
    job2Person: null,
    job0PersonName: null,
    job1PersonName: null,
    job2PersonName: null,
    persons: null,

    id: pp.ID_INVALID,
    jobFame0: 0,
    jobFame1: 1,
    jobFame2: 2,
    jobName0: "",
    jobName1: "",
    jobName2: "",

    name: "",
    placeId: pp.ID_INVALID,
    monarchId: pp.ID_INVALID,
    knightName: "",
    nationName: "",

    authority: 0,
    exist: false,
    job0PersonId: pp.ID_INVALID,
    job1PersonId: pp.ID_INVALID,
    job2PersonId: pp.ID_INVALID,

    getFieldsToSave: function () {
        return [
            "id",
            "authority",
            "exist",
            "job0PersonId",
            "job1PersonId",
            "job2PersonId"
        ];
    },

    ctor: function (objInDb) {

        this._super();

        this.id = objInDb["id"];
        this.jobFame0 = objInDb["jobfame0"];
        this.jobFame1 = objInDb["jobfame1"];
        this.jobFame2 = objInDb["jobfame2"];
        this.jobName0 = objInDb["jobName0"];
        this.jobName1 = objInDb["jobName1"];
        this.jobName2 = objInDb["jobName2"];
        this.name = objInDb["name"];
        this.placeId = objInDb["place"];
        this.monarchId = objInDb["monarch"];
        this.knightName = objInDb["knightName"];
        this.nationName = objInDb["nationName"];
    },

    getJob0Person: function () {
        return this.job0PersonId == pp.ID_INVALID ? pp.world.persons[pp.piJudgeA] : pp.world.persons[this.job0PersonId];
    },

    getJob1Person: function () {
        return this.job1PersonId == pp.ID_INVALID ? pp.world.persons[pp.piJudgeC] : pp.world.persons[this.job1PersonId];
    },

    getJob2Person: function () {
        return this.job2PersonId == pp.ID_INVALID ? pp.world.persons[pp.piJudgeB] : pp.world.persons[this.job2PersonId];
    },

    getJob0PersonName: function () {
        return this.job0PersonId == pp.ID_INVALID ? "---" : pp.world.persons[this.job0PersonId].getFullName();
    },
    getJob1PersonName: function () {
        return this.job1PersonId == pp.ID_INVALID ? "---" : pp.world.persons[this.job1PersonId].getFullName();
    },
    getJob2PersonName: function () {
        return this.job2PersonId == pp.ID_INVALID ? "---" : pp.world.persons[this.job2PersonId].getFullName();
    },

    getPersonsWithNoTitle: function () {
        var persons = [];
        pp.world.persons.forEach(function(person) {
            if (person.societyId != this.id) return;
            if (person.jobIdx != pp.IDX_INVALID) return;
            persons.push(person);
        }, this);

        // Sort by fame
        persons.sort(function (personA, personB) {
            return personB.fame - personA.fame;
        });

        return persons;
    },

    getPersons: function () {
        var persons = [];
        pp.world.persons.forEach(function(person) {
            if (person.societyId != this.id) return;
            if (person.state != pp.pcActive) return;
            persons.push(person);
        }, this);
        return persons;
    },

    getJobPersons: function () {
        var persons = [];

        persons.push(this.job0PersonId == pp.idInvalid ? null : pp.world.persons[this.job0PersonId]);
        persons.push(this.job1PersonId == pp.idInvalid ? null : pp.world.persons[this.job1PersonId]);
        persons.push(this.job2PersonId == pp.idInvalid ? null : pp.world.persons[this.job2PersonId]);

        return persons;
    },

    hasManualMember: function () {
        var persons = this.persons;
        var result = false;
        persons.forEach(function(person) {
            if (person.isManual || person.id == pp.world.interestedPersonId) result = true;
        });
        return result;
    },

    toShowMessageByJobPerson: function () {

        var persons = this.getJobPersons();

        for (var i = 0; i < persons.length; i++) {
            var person = persons[i];
            if (person && (person.isManual || person.id == pp.world.interestedPersonId))
                return true;
        }

        return false;
    }

});

pp.PrSociety.prototype.tableName = function () {
    return "societies";
};

pp.PrSociety.prototype.loadSenario = function (objs, db) {

    var societiesFromDbS1 = db["societiesS1"];

    for (var i = 0; i < objs.length; i++) {

        var society = objs[i];
        var societyObjFromDbS1 = societiesFromDbS1[society.id];

        society.authority = societyObjFromDbS1["authority"];
        society.exist = societyObjFromDbS1["exist"];
        society.job0PersonId = societyObjFromDbS1["job1person"] || pp.ID_INVALID;
        society.job1PersonId = societyObjFromDbS1["job2person"] || pp.ID_INVALID;
        society.job2PersonId = societyObjFromDbS1["job3person"] || pp.ID_INVALID;

        if (society.job0PersonId != pp.ID_INVALID) {
            var person = pp.world.persons[society.job0PersonId];
            person.jobIdx = 0;
        }
        if (society.job1PersonId != pp.ID_INVALID) {
            var person = pp.world.persons[society.job1PersonId];
            person.jobIdx = 1;
        }
        if (society.job2PersonId != pp.ID_INVALID) {
            var person = pp.world.persons[society.job2PersonId];
            person.jobIdx = 2;
        }
    }
};

//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrSociety.prototype;
cc.defineGetterSetter(_p, "job0Person", _p.getJob0Person);
cc.defineGetterSetter(_p, "job1Person", _p.getJob1Person);
cc.defineGetterSetter(_p, "job2Person", _p.getJob2Person);
cc.defineGetterSetter(_p, "job0PersonName", _p.getJob0PersonName);
cc.defineGetterSetter(_p, "job1PersonName", _p.getJob1PersonName);
cc.defineGetterSetter(_p, "job2PersonName", _p.getJob2PersonName);
cc.defineGetterSetter(_p, "persons", _p.getPersons);

