

pp.PrWorld = pp.PrObject.extend({

    //Dummies for properties
    activePersons: null,

    persons: null,
    discoveries: null,
    fields: null,
    items: null,
    occupations: null,
    places: null,
    reports: null,
    societies: null,
    themes: null,
    universities: null,
    observatories: null,


    year: 1600,
    month: 1,

    shuffledPersonIds: null,
    commandedPersonNum: 0,

    tutorialStage: 0,
    tutorialNextSelection: 0,
    tutorialLastMessage: "",

    interestedPersonId: null,

    getFieldsToSave: function () {
        return [
            "year",
            "month",
            "commandedPersonNum",
            "tutorialStage",
            "tutorialNextSelection",
            "tutorialLastMessage",
            "items",
            "persons",
            "reports",
            "societies",
            "shuffledPersonIds",
            "interestedPersonId"
        ];
    },


    ctor: function () {

        pp.world = this;

        this._name = "PrWorld";

        this.init();
    },

    init: function () {
        this.year = 1667;
        this.month = 4;
        this.commandedPersonNum = 0;

        this.tutorialStage = pp.tuOff;
        this.tutorialNextSelection = pp.cmCancel;
        this.tutorialLastMessage = "";

        this.interestedPersonId = pp.idInvalid;
        this.cache = {};
    },

    countDiscoveryForThemes: function () {

        for (var i = 0; i < this.discoveries.length; i++) {
            var disc = this.discoveries[i];
            var theme = this.themes[disc.themeId];
            theme.discoveryCount++;
        }
    },

    loadRelations: function (database) {

        // Person-Item relation
        {
            var itemObjsInDb = database["itemsS1"];
            for (var i = 0; i < itemObjsInDb.length; i++) {
                var itemObjInDb = itemObjsInDb[i];

                var itemId = itemObjInDb["id"];
                var personId = itemObjInDb["person"];

                this.persons[personId].itemNums[itemId] = 1;
            }
        }

        // Person-Person relation
        {
            var friendlinessesInDb = database["friendlinessesS1"];

            for (var i = 0; i < friendlinessesInDb.length; i++) {
                var frdInDb = friendlinessesInDb[i];
                var pid1 = frdInDb["person1"];
                var pid2 = frdInDb["person2"];
                var friendliness = frdInDb["friendliness"];

                this.persons[pid1].friendlinesses[pid2] = friendliness;
                this.persons[pid2].friendlinesses[pid1] = friendliness;
            }
        }
    },

    loadDatabase: function (loadDatabaseCallback, target) {

        this.init();

        var dbs = {
            persons: res.Db_Persons,
            discoveries: res.Db_Discoveries,
            fields: res.Db_Fields,
            items: res.Db_Items,
            occupations: res.Db_Occupations,
            places: res.Db_Places,
            societies: res.Db_Societies,
            themes: res.Db_Themes,
            universities: res.Db_Universities,
            observatories: res.Db_Observatories,

            friendlinessesS1: res.Db_FriendlinessesSenario1,
            itemsS1: res.Db_ItemsSenario1,
            personsS1: res.Db_PersonsSenario1,
            reportsS1: res.Db_ReportsSenario1,
            societiesS1: res.Db_SocietiesSenario1,

            personsEn: res.Db_PersonsEn,
            placesEn: res.Db_PlacesEn,
            themesEn: res.Db_ThemesEn,
            fieldsEn: res.Db_FieldsEn,
            itemsEn: res.Db_ItemsEn,
            societiesEn: res.Db_SocietiesEn,
            discoveriesEn: res.Db_DiscoveriesEn,
            occupationsEn: res.Db_OccupationsEn,
            observatoriesEn: res.Db_ObservatoriesEn,
            universitiesEn: res.Db_UniversitiesEn,

            personsZh: res.Db_PersonsZh,
            placesZh: res.Db_PlacesZh,
            themesZh: res.Db_ThemesZh,
            fieldsZh: res.Db_FieldsZh,
            itemsZh: res.Db_ItemsZh,
            societiesZh: res.Db_SocietiesZh,
            discoveriesZh: res.Db_DiscoveriesZh,
            occupationsZh: res.Db_OccupationsZh,
            observatoriesZh: res.Db_ObservatoriesZh,
            universitiesZh: res.Db_UniversitiesZh
        };

        var onDidLoadDb;

        var doLoadDb = function () {

            cc.async.map(
                dbs,
                function(value, key, cb) {
                    cc.loader.loadJson(value, cb);
                },
                function (err, results) {
                    if (err) {
                        cc.log(err);
                    }
                    else {
                        onDidLoadDb(results);
                    }
                }
            );
        };

        onDidLoadDb = function (database) {

            //cc.log("onDidLoadDb CALLED");

            this.persons = pp.PrPerson.prototype.createArray(database);
            this.themes = pp.PrTheme.prototype.createArray(database);
            this.discoveries = pp.PrDiscovery.prototype.createArray(database);
            this.societies = pp.PrSociety.prototype.createArray(database);
            this.items = pp.PrItem.prototype.createArray(database);
            this.places = pp.PrPlace.prototype.createArray(database);
            this.occupations = pp.PrOccupation.prototype.createArray(database);
            this.fields = pp.PrField.prototype.createArray(database);

            this.universities = pp.PrUniversity.prototype.createArray(database);
            this.observatories = pp.PrObservatory.prototype.createArray(database);

            this.reports = pp.PrReport.prototype.createArray(database);

            this.countDiscoveryForThemes();

            pp.PrSociety.prototype.loadSenario(this.societies, database);
            pp.PrPerson.prototype.loadSenario(this.persons, database);

            this.loadRelations(database);

            this.shuffledPersonIds = new Array(this.persons.length);
            this.shufflePersonIds();

            loadDatabaseCallback.call(target);

        }.bind(this);

        doLoadDb();
    },

    initPersonIds: function () {

        for (var i = 0; i < this.shuffledPersonIds.length; i++) {
            this.shuffledPersonIds[i] = i;
        }
    },

    shufflePersonIds: function () {

        this.initPersonIds();

        for (var i = 0; i < this.shuffledPersonIds.length; i++) {

            var tmp;
            var j0 = i; // % this.shuffledPersonIds.length;
            var j1 = Math.floor(cc.random0To1() * this.shuffledPersonIds.length);
            if (j0 == j1) {
                j1 = (j1 + 1) % this.shuffledPersonIds.length;
            }

            tmp = this.shuffledPersonIds[j0];
            this.shuffledPersonIds[j0] = this.shuffledPersonIds[j1];
            this.shuffledPersonIds[j1] = tmp;
        }
    },

    getActivePersons: function () {
        var result = [];
        for (var i = 0; i < this.persons.length; i++) {
            var person = this.persons[i];
            if (person.state == pp.pcActive)
                result.push(person);
        }
        return result;
    },

    manualPersonId: function () {
        for (var i = 0; i < this.persons.length; i++)
            if (this.persons[i].isManual) return i;

        return pp.idInvalid;
    }

});

//////////////////////////////////////////////////////////////////////////////
// Define properties
//////////////////////////////////////////////////////////////////////////////

var _p = pp.PrWorld.prototype;
cc.defineGetterSetter(_p, "activePersons", _p.getActivePersons);
