
stoComClaimReport = function (preSelectedReportId) {

    var done = false;
    var reportId;
    var societyId;

    if (pp.isIdValid(preSelectedReportId)) {
        reportId = preSelectedReportId;
        goto("didSelectReport");
    }

SelReport:
    if (pp.isIdValid(preSelectedReportId)) {
        goto("Exit");
    }

    //'論文選択ﾌｫｰﾑ表示
    reportId = sto.wuiSelectReport(null, [pp.frDiscType, pp.ttTheory, pp.frPublished, true]);

    if (reportId == pp.selCancel)
        goto("Exit");

    if (pp.world.reports[reportId].personId == pp.mediator.personId)
    {
        stol.wuiShowMessage("SelReport", __(str.s1)); //"自分自身です。");
    }

DidSelectReport:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComClaimReport, reportId);
    goto("Exit");

NotCheckingText:
    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];
    var toPerson = pp.world.persons[report.personId];

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s29, toPerson.fullName, tmi.titleize(disc.name)));
        //toPerson.fullName + "の論文『" + disc.name + "』を批判します。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("SelReport");

    //'実行
    sto.callStoryFunc(this.stoExeClaimReport, reportId);

    //'ｺﾏﾝﾄﾞが実行された
    done = true;

Exit:
    return done;
};



stoExeClaimReport = function (reportId, forcedValues) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedValues);

    var report = pp.world.reports[reportId];
    var society = pp.world.societies[report.societyId];
    var person = pp.mediator.person;
    var toPerson = pp.world.persons[report.personId];
    var disc = pp.world.discoveries[report.discoveryId];

    /*
    var currentVal = pp.mediator.getToShowMessage();
    */

    //'提出される組織の役員がﾌﾟﾚｲﾔｰなら必ずﾒｯｾｰｼﾞ表示
    if (society.toShowMessageByJobPerson())
        pp.mediator.toShowMessageTemporary = true;

    //'批判される論文の作者がﾌﾟﾚｲﾔｰでも必ずﾒｯｾｰｼﾞ表示
    if (toPerson.isManual || toPerson.id == pp.world.interestedPersonId)
        pp.mediator.toShowMessageTemporary = true;

    /*
    if (pp.mediator.getToShowMessage() == currentVal)
        goto("EndFocus");
        */

    sto.wuiSetFocusOnPlace(pp.mediator.person.placeId);

    /*
    EndFocus:
    */

    var body =
        __(str.s30, toPerson.fullName, report.discName);
        //"私の研究によれば、公開されている" + toPerson.fullName +
        //"氏の論文『" + report.discName + "』の内容は信憑性に乏しく､" +
        //"根拠の無い推論で語られていると結論付けざるを得ません｡";

    sto.wuiShowLetter(
        __(society.name + "殿", society.name, society.name),
        body,
        pp.mediator.getDateStringWithDay(),
        person.id);

    sto.wuiShowMessage(
        __(str.s34, person.fullName, toPerson.fullName, report.discName)
        //person.fullName + "が" +
        //toPerson.fullName + "の論文『" +
        //report.discName + "』を批判しています。"
    );

    var accepted = sto.callStoryFunc(this.stoIsClaimAccepted, reportId, forcedValues);

    if (isCheckingText)
        goto("Exit");

    if (accepted == false)
        goto("Rejected");

Accepted:
    //'*** 認められた
    //'論文公開停止
    report.societyId = pp.idInvalid;
    sto.wuiShowMessage(
        __(str.s37, report.discName));
        //"論文『" + report.discName + "』の公開が停止されました！");

    //'論文作者名声DOWN
    //'(上昇値) = -(重要度 + 組織権威 / 10 - 5) * (支持率 / 50)
    var up = -(disc.importance + society.authority / 10 - 5) * (report.backing / 50);
    up = tm.imax(up, -person.fame);
    sto.wuiShowParamChange(__("名声"), toPerson.fame, toPerson.fame+up, toPerson.fullName);
    toPerson.fame += up;

    up = tm.int((disc.importance + society.authority / 10 - 5) * (report.backing / 50) / 3);
    sto.wuiShowParamChange(__("名声"), person.fame, person.fame+up, person.fullName);
    person.fame += up;

    goto("Exit");

Rejected:
    //'友好度DOWN
    var fup = -5;
    fup = tm.imax(fup, -person.friendlinesses[toPerson.id]);
    sto.wuiShowParamChange(
        __("友好度"),
        person.friendlinesses[toPerson.id],
        person.friendlinesses[toPerson.id]+fup,
        person.fullName + __("と", " and ", "跟") + toPerson.fullName
    );

    person.friendlinesses[toPerson.id] += fup;
    toPerson.friendlinesses[person.id] = person.friendlinesses[toPerson.id];

Else1:
    pp.mediator.uiUpdate();

Exit:
    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s41, toPerson.name, tmi.titleize(disc.name), (accepted ? __("論文公開停止", "Halt Publication", "发表已经终止") : __("無効な批判", "No Effect", "批判无效"))));
    //toPerson.name + "の論文『" + disc.name + "』を批判しました。結果：" + (accepted ? "論文公開停止" : "無効な批判"));

    pp.mediator.toShowMessageTemporary = false;
};


stoIsClaimAccepted = function (reportId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var person = pp.mediator.person;
    var toPersonId = report.personId;
    var toPerson = pp.world.persons[toPersonId];
    var society = pp.world.societies[report.societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    //---------- SCENE SOCIETY ----------
    sto.wuiSetFocusOnPlace(society.placeId);
    pp.mediator.setBgm(res.Mus_Society);
    sto.wuiPushScene(pp.ScnSociety, society.id, cc.TransitionFlipX, 3);
    sto.wuiShowCutS(res.Img_CutSociety);
    sto.wuiShowReportS(reportId);


    var accepted;
    //var backing = 50;

    cr = report.credibility;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    var personDId = pp.mediator.personDId;
    var personEId = pp.mediator.personEId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = toPerson.friendlinesses[personAId];
    //'論文作者との友好度と完成度で決定
    opA = cr < 30 ? 3 : cr < 50 ? 2 : cr < 70 ? 1 : 0;
    opA += fr < 50 ? 1 : fr < 70 ? 0 : -1;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = toPerson.friendlinesses[personBId];
    //'論文作者との友好度と完成度で決定
    opB = cr < 30 ? 3 : cr < 50 ? 2 : cr < 70 ? 1 : 0;
    opB += fr < 50 ? 1 : fr < 70 ? 0 : -1;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = toPerson.friendlinesses[personCId];
    //'論文作者との友好度と完成度で決定
    opC = cr < 30 ? 3 : cr < 50 ? 2 : cr < 70 ? 1 : 0;
    opC += fr < 50 ? 1 : fr < 70 ? 0 : -1;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //D氏

    if (person.id == personDId) {
        //'*** 自分が批判する場合
        mes =
            __(str.s42, toPerson.lastName, society.name);
            //"以前からの疑問を書簡にまとめました。" +
            //toPerson.lastName + "氏のある論文の内容が適切とは思えないのです。" +
            //society.name + "として再考をお願いいたします。";
    }
    else {
        mes =
            __(str.s45,
                person.fullName,
                (toPersonId == personDId ? __("私", "my", "我") : __(toPerson.fullName + "氏", "Mr " + toPerson.fullName + "'s", toPerson.fullName)),
                society.name);
            //person.fullName + "氏から" +
            //(toPersonId == personDId ? "私" : toPerson.fullName + "氏") +
            //"の論文の内容を批判する書簡が送られてまいりました。" +
            //society.name + "としての対応を決定しなければなりません。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s49, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'Ｂ氏
    if (toPersonId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 0;
        mes =
            __(str.s50, person.lastName);
            //person.lastName + "氏は何の根拠があってそんなことを言い出したのでしょうか？私の論文に不備などありません。";
        goto("SettledB");
    }
    else if (person.id == personBId)
    {
        //'*** 自分が批判したなら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s51, society.name);
            //"以前からこの論文には疑問がありました。" + society.name +
            //"の権威を保つため、公開を差し止めるのが適当と思います。";
        goto("SettledB");
    }

    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:

    switch (opB)
    {
        case 1:
        case 0:
            mes =
                __(str.s54, person.lastName);
                //person.lastName + "氏は何の根拠があってそんなことを言い出したのでしょうか？" +
                //"念のため確認してみましたが、この論文にそのような不備はありません。";
            break;

        case 4:
        case 3:
        case 2:
            mes =
                __(str.s56, report.discName);
                //"当然のご批判ですね。『" + report.discName + "』の内容には以前から疑問がありました。";
            break;
    }

SettledB:
    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (toPersonId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 0;
        mes =
            __(str.s57, person.lastName, report.discName);
            //person.lastName + "氏とは困ったお人だ。私の『" + report.discName + "』の真意が読み取れていないと見える。";
        goto("SettledA");
    }
    else if (person.id == personAId)
    {
        //'*** 自分が批判したなら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s58, society.name);
            //"以前からこの論文には疑問がありました。" + society.name +
            //"の権威を保つため、公開を差し止めるのが適当と思います。";
        goto("SettledA");
    }

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:
    switch (opA)
    {
        case 1:
        case 0:
            mes =
                __(str.s61) + CR +
                __(str.s62, society.jobName2);
                //"まったく的外れのご指摘だ。そのような不備があればこちらで受理するはずも無い。\n" +
                //society.jobName2 + "はどう思うかね？";
            break;

        case 4:
        case 3:
        case 2:
            mes =
                __(str.s63);
                //"・・・確かにご指摘の通りと思える個所もある。これは再考せねばなるまい。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (toPersonId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 0;
        mes =
            __(str.s64, report.discName);
            //"この私の論文が批判されるとは思いませんでした。" + report.discName +
            //"という結論は揺るぎ無いものであると確信しています。";
        goto("SettledC");
    }
    else if (person.id == personCId)
    {
        //'*** 自分が批判したなら特別なｾﾘﾌ
        opC = 4;
        mes =
            __(str.s66, society.name);
            //"以前からこの論文には疑問がありました。" + society.name +
            //"の権威を保つため、公開を差し止めるのが適当でありましょう。";
        goto("SettledC");
    }

    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        case 1:
        case 0:
            mes =
                __(str.s69);
                //"とても賛同できません。この論文の素晴らしさが伝わっていなかったとは、悲しいことです。";
            break;

        case 4:
        case 3:
        case 2:
            mes =
                __(str.s70, report.discName);
                //"言われてみれば、" + report.discName + "というのも少々無理があるような気がしてきました。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    // 意見が割れてる？
    if (((opA > 1 && opB <= 1) || (opB > 1 && opA <=1) ||
        (opB > 1 && opC <= 1) || (opC > 1 && opB <=1) ||
        (opC > 1 && opA <= 1) || (opA > 1 && opC <=1)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s71));
        //"意見が分かれたな。では総合的に見て私が判断しよう。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:

    //'3人のﾎﾟｲﾝﾄが6以上なら受理
    if (opA + opB + opC >= 6)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s72, person.fullName, report.discName));
        //"・・・それでは、この" + person.fullName + "氏のご批判を受けて" +
        //"論文『" + report.discName + "』の公開を停止することとする。");

AcceptedByA:
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s74, person.lastName));
        //"・・・では、この" + person.lastName + "氏のご批判は不適切という判断で決定です。いいですね？");

    accepted = false;

Exit:
    //---------- POP SCENE ----------
    sto.wuiPopScene(cc.TransitionFlipX, 3);
    sto.wuiSetFocusOnPlace(person.placeId);

    return accepted;

};
