
stoComMake = function () {

    var options = [
        __("アイテム試作"),
        __("スケッチ描画")
    ];

SelSubCommand:

    var userSel = sto.wuiSelectOptionsWithCancel(options, __("作成"));

    if (userSel == pp.selCancel) {
        return false;
    }

    var done;
    var funcToCall;
    if (userSel == 0) {
        funcToCall = this.stoComMakeTrial;
    }
    else if (userSel == 1) {
        funcToCall = this.stoComDrawFigure;
    }

    done = sto.callStoryFunc(funcToCall);

    return done;

};

stoComMakeTrial = function (preSelectedDiscId) {
    var done = false;

    var disc;
    var discId;

    if (pp.isIdValid(preSelectedDiscId)) {
        discId = preSelectedDiscId;
        goto("DidSelectDisc");
    }

    //'発見選択ﾌｫｰﾑ表示
    if (pp.mediator.person.getDiscoveriesWithType(pp.ttItem).length < 1)
    {
        stol.wuiShowMessage("Exit",
            __(str.s219));
            //"選択可能な発明がありません。");
    }

SelDiscovery:
    if (pp.isIdValid(preSelectedDiscId)) {
        goto("Exit");
    }

    discId = sto.wuiSelectDiscovery([pp.fdPerson, pp.mediator.personId, pp.fdType, pp.ttItem]);
    if (discId == pp.selCancel)
        goto("Exit");

DidSelectDisc:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComItem, discId);
    goto("Exit");

NotCheckingText:
    //'確認
    //'*** 道具の場合
    if (pp.mediator.person.discCredibilities[discId] == pp.crReady)
    {
        stol.wuiShowMessage("SelDiscovery",
            __(str.s220));
            //"すでに試作に成功しています。");
    }

    disc = pp.world.discoveries[discId];
    var sel = sto.wuiSelectOkCancel(
        __(str.s221, disc.name));
        //"『" + disc.name + "』の試作を行います。よろしいですか？");
    if (sel == pp.selCancel)
        goto("SelDiscovery");

    //'試作実行
    sto.callStoryFunc(this.stoExeMakeTrial, disc.id);
    done = true;

Exit:
    return done;
};

stoExeMakeTrial = function (discId, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);

    var person = pp.mediator.person;
    var disc = pp.world.discoveries[discId];

    //--- シーン変更
    sto.wuiPushScene(pp.ScnRoom, null, cc.TransitionFade, 2);

    //'*** 前振り
    mes = __(str.s222, disc.name, tmi.article(disc.name));
        //"理論的には、" + disc.name + "の製作は十分可能だ。あとは私の技術次第だ・・・。";
    sto.wuiShowVoice(
        person.id,
        res.Img_CutMake,
        mes,
        __(str.s223)); //"発明品試作");

    //'(試作成否) = (工作技術 + 器用度) / 2 > (必要技術(完成度))
    var isSuccess = person.fieldPs[pp.FD_ENGINEERING].experience + tm.irand(0, 10) >= disc.engineering;

    if (isCheckingText)
        isSuccess = forcedVoiceIdx > 2;

    if (isSuccess == false)
        goto("Failed");

Succeeded:
    //'*** 成功
    //'ﾒｯｾｰｼﾞ表示
    var mes;
    var mesIdx;
    var messages = [ __(str.s224), __(str.s225), __(str.s226) ];
    if (isCheckingText) {
        mesIdx = forcedVoiceIdx - 3;
    }
    else {
        mesIdx = tm.irand(3);
        /*
        mes =
            tm.irand(3) == 0 ? "よし完成したぞ。私の理論が形になった瞬間だ。" :
            tm.irand(2) == 0 ? "これで出来ているのかな？とりあえず使ってみるか。" :
                "苦労の甲斐あって試作に成功だ。";
        */
    }
    mes = messages[mesIdx];

    var item = pp.world.items[disc.itemId];

    sto.wuiShowVoice(
        person.id,
        item.picture,
        mes,
        __(str.s227), //"試作 - 成功",
        true);

    //'ｱｲﾃﾑ表示
    sto.wuiShowItem(disc.itemId, person.id);

    person.discCredibilities[discId] = pp.crReady;

    sto.wuiShowMessage(
        __(str.s228, disc.name));
        //disc.name + "の試作に成功しました。");

    //'*** ｱｲﾃﾑ入手
    person.itemNums[disc.itemId] = 1;

    // 図鑑アンロック
    sto.callStoryFuncIf(person.isManual, this.stoLibUnlock, pp.libItem, disc.itemId, item.name);

    pp.mediator.uiUpdate();

    goto("Exit");

Failed:
    //'*** 失敗
    //'ﾒｯｾｰｼﾞ表示
    var mes;
    var mesIdx;
    var messages = [ __(str.s229), __(str.s230), __(str.s231) ];
    if (isCheckingText) {
        mesIdx = forcedVoiceIdx;
    }
    else {
        mesIdx = tm.irand(3);
    }
    mes = messages[mesIdx];
/*
    var mes =
            tm.irand(3) == 0 ? "あっちを押さえるとこっちが外れてこっちを押さえるとあっちが外れるぞ。" :
            tm.irand(2) == 0 ? "駄目だ、私の技術力では無理のようだ。" :
                               "うわっ！！破裂した・・・。\n１からやり直しだ・・・。";
   */

    sto.wuiShowVoice(
        person.id,
        null,
        mes,
        __(str.s232), //"試作 - 失敗",
        true);

    sto.wuiShowMessage(
        __(str.s233, disc.name));
        //disc.name + "の試作に失敗しました。");

Exit:
    //熟練度上昇
    // 50まではあがりやすい 80以降はここでは上がらず
    var field = pp.world.fields[pp.fdEngineering];
    var fieldp = person.fieldPs[pp.fdEngineering];
    var p0 = fieldp.experience;
    var up = tm.irand(2, 3) - (p0 < 50 ? 0 : p0 < 60 ? 1 : p0 < 80 ? 2 : 3);
    var p1 = tm.imin(p0 + up, pp.fieldExperienceMax);

    if (p0 == p1)
        goto("DidSkillUp");

    sto.wuiShowParamChange(__(field.name2 + "熟練", "Skill of " + field.name), p0, p1);
    fieldp.experience = p1;

DidSkillUp:
    sleep(0.2);
    pp.mediator.uiClearOverlappedPopups();

    pp.mediator.logPersonCommand(person.id,
        __(str.s234, disc.name, (isSuccess ? __("成功") : __("失敗"))));
        //disc.name + "の試作を行いました。結果：" + (isSuccess ? "成功" : "失敗"));

    //--- シーン変更
    sto.wuiPopScene(cc.TransitionFade, 2);

    return;
};

stoComDrawFigure = function (preSelectedDiscId) {
    var done = false;

    var disc;
    var person = pp.mediator.person;
    var discId;

    if (pp.isIdValid(preSelectedDiscId)) {
        discId = preSelectedDiscId;
        goto("DidSelectDisc");
    }

    if (person.getDiscoveriesWithType(pp.ttFigure).length < 1)
    {
        stol.wuiShowMessage("Exit",
            __(str.s235));
            //"選択可能な観察図がありません");
    }

SelDiscovery:
    if (pp.isIdValid(preSelectedDiscId)) {
        goto("Exit");
    }

    //'発見選択ﾌｫｰﾑ表示
    discId = sto.wuiSelectDiscovery([pp.fdPerson, person.id, pp.fdType, pp.ttFigure]);
    if (discId == pp.selCancel)
        goto("Exit");

DidSelectDisc:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComDrawFigure, discId);
    goto("Exit");

NotCheckingText:
    //'確認
    disc = pp.world.discoveries[discId];
    if (person.discCredibilities[discId] == pp.crPreMake)
        goto("FirstWrite");

Rewrite:
    var sel = sto.wuiSelectOkCancel(
        __(str.s236, tmi.titleize(disc.name)));
        //"『" + disc.name + "』は既に描画済みです。描き直しますか？");
    if (sel == pp.selCancel)
        goto("SelDiscovery");

    goto("CallExe");

FirstWrite:
    var sel = sto.wuiSelectOkCancel(
        __(str.s237, disc.name));
        //"『" + disc.name + "』の描画を行います。よろしいですか？");
    if (sel == pp.selCancel)
        goto("SelDiscovery");

CallExe:
    //'描画実行
    sto.callStoryFunc(this.stoExeDrawFigure, discId);

    done = true;

Exit:
    return done;
};

stoExeDrawFigure = function (discId, forcedCompletion) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedCompletion);

    var disc = pp.world.discoveries[discId];
    var person = pp.mediator.person;

    //--- シーン変更
    sto.wuiPushScene(pp.ScnRoom, null, cc.TransitionFade, 2);

    var image = res.Img_CutBiology;
    // 科学者が単顕微鏡を使用していたら画像差し替え
    for (var iThemep = 0; iThemep < person.themePs.length; iThemep++) {
        var themep = person.themePs[iThemep];
        for (var iItem = 0; iItem < themep.itemIds.length; iItem++) {
            if (themep.itemIds[iItem] == pp.iiMonoMicroscope) {
                image = res.Img_CutBiology2;
                break;
            }
        }
    }

    //'*** 前振り
    var mes = __(str.s238, disc.name);
        //"この美しい" + disc.name + "を精密にスケッチすれば、公開する価値がある。私に十分な技術があるかどうか・・・。";
    sto.wuiShowVoice(
        person.id,
        image,
        mes,
        __(str.s239), //"スケッチ描画",
        false);

    var c;
    var dif = disc.engineering;
    var exp = person.fieldPs[pp.fdDrawing].experience;
    if (isCheckingText) {
        c = forcedCompletion;
    }
    else {
        if (dif > exp) {
            c = tm.int(70 * exp / dif );
            //c = tm.int((100 - dif) / dif * exp);
        }
        else {
            c = tm.int(70 + 30 * (exp - dif) / (100 - dif));
            //c = tm.int((100 - dif) + dif / (100 - dif) * (exp - dif));
        }
    }
    //var c = 60 - (disc.engineering - (person.engineering + person.dexterity) / 2);
cc.log("dif=" + dif + ", exp=" + exp + ", c=" + c);

    c = tm.imin(100, tm.imax(10, c));

    //'しゃべり
    var mesIdx;
    var messages = [
        __(str.s240),
        __(str.s241),
        __(str.s242),
        __(str.s243),
        __(str.s244)
    ];
    mesIdx = c < 30 ? 0 : c < 50 ? 1 : c < 70 ? 2 : c < 90 ? 3 : 4;
    mes = messages[mesIdx];

    /*
    var mes =
        c < 30 ? "・・・・駄目だ。自分でも何を描いているのかわからなくなってきた。" :
        c < 50 ? "なかなか上手く描けないものだな。もう少し練習が必要かもしれない。" :
        c < 70 ? "一応は何を描いてあるか確認できる・・・。\nしかしこれでは良い評価は期待できそうもない。" :
        c < 90 ? "私の技術を持ってすれば、この程度のスケッチはやさしい仕事であったな。" :
                 "我ながら美しい図が完成した。自然界の神秘をそのまま再現していると言ってよさそうだ。";
                 */

    sto.wuiShowVoice(
        person.id,
        //res.Img_CutMath,
        image,
        mes,
        __(str.s239), //"スケッチ描画",
        true);

    //'描画完了
    person.discCredibilities[discId] = c;

    //'図表示
    sto.wuiShowFigure(disc.getFigureId(), c, person.isManual ? pp.MW_USER : pp.MW_USER_OR_TIMEOUT);

    sto.wuiShowMessage(
        __(str.s246, disc.name));
        //disc.name + "の描画が完了しました。");

    //熟練度上昇
    // 50まではあがりやすい 80以降はここでは上がらず
    var field = pp.world.fields[pp.fdDrawing];
    var fieldp = person.fieldPs[pp.fdDrawing];
    var p0 = fieldp.experience;
    var up = tm.irand(2, 3) - (p0 < 50 ? 0 : p0 < 60 ? 1 : p0 < 80 ? 2 : 3);
    var p1 = tm.imin(p0 + up, pp.fieldExperienceMax);

    if (p0 == p1)
        goto("DidSkillUp");

    sto.wuiShowParamChange(__(field.name2 + "熟練", "Skill of " + field.name), p0, p1);
    fieldp.experience = p1;

DidSkillUp:

    // 図鑑アンロック
    sto.callStoryFuncIf(person.isManual && c >= 70, this.stoLibUnlock, pp.libFigure, disc.getFigureId(), disc.name);

    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    pp.mediator.logPersonCommand(person.id,
        __(str.s247, disc.name, c));
        //disc.name + "のスケッチを行いました。完成度：" + c);

    //--- シーン変更
    sto.wuiPopScene(cc.TransitionFade, 2);
};

stoComWriteReport = function (preSelectedDiscId) {
    
    var done = false;

    var disc;
    var person = pp.mediator.person;
    var discId;

    if (pp.isIdValid(preSelectedDiscId)) {
        discId = preSelectedDiscId;
        goto("DidSelectDisc");
    }

    //'発見選択ﾌｫｰﾑ表示
    if (pp.mediator.person.discoveries.length > 0)
        goto("SelDiscovery");

    sto.wuiShowMessage(
        __(str.s248)
        //"選択可能な発見がありません。"
    );
    goto("Exit");
    
SelDiscovery:
    if (pp.isIdValid(preSelectedDiscId)) {
        goto("Exit");
    }

    discId = sto.wuiSelectDiscovery([pp.fdPerson, person.id]);
    if (discId == pp.selCancel)
        goto("Exit");

DidSelectDisc:
    disc = pp.world.discoveries[discId];
    //'発見種別が道具なら、試作が済んでいるかどうかﾁｪｯｸ
    if (disc.type == pp.ttItem && person.discCredibilities[discId] != pp.crReady)
    {
        stol.wuiShowMessage("SelDiscovery",
            __(str.s249)
            //"試作が成功していないので論文は作成できません。"
        );
    }

    //'発見種別図なら、描画が済んでいるかどうかﾁｪｯｸ
    if (disc.type == pp.ttFigure && person.discCredibilities[discId] == pp.crPreMake)
    {
        stol.wuiShowMessage("SelDiscovery",
            __(str.s250)
            //"描画が完了していないので論文は作成できません。"
        );
    }

    //'すでに論文にしていないかどうかﾁｪｯｸ
    var report;
    for (var i = 0; i < pp.world.reports.length; i++)
    {
        report = pp.world.reports[i];
        if (report.personId == person.id && report.discoveryId == discId)
        {
            //'*** 作成済み
            //'理論論文か、図論文でなければ改訂させない
            if (disc.type != pp.ttTheory && disc.type != pp.ttFigure)
            {
                stol.wuiShowMessage("SelDiscovery",
                    __(str.s251)
                    //"作成済みです。この論文は改訂できません。"
                );
            }

            if (report.societyId != pp.idInvalid)
            {
                //'*** 作成済み、提出済み
                //'警告ﾒｯｾｰｼﾞ表示
                var society = pp.world.societies[report.societyId];
                var mes =
                    __(str.s252, tmi.titleize(disc.name), society.name);
                    //"『" + disc.name + "』はすでに論文を" + society.name+ "に提出済みです。改訂するには公開を停止してください。";
                stol.wuiShowMessage("SelDiscovery", mes);
            }

            //'改訂するかどうか確認
            goto("Rewrite");
        }
    }

    //'*** 作成前
    //'確認

Write:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComWriteReport, discId);
    goto("Exit");

NotCheckingText:
    var mes =
        __(str.s253, disc.name);
        //"『" + disc.name + "』を論文にまとめます。\nよろしいですか？";
    var sel = sto.wuiSelectOkCancel(mes);
    if (sel == pp.selCancel)
        goto("SelDiscovery");

    //'研究論文作成
    //'試作実行
    done = sto.callStoryFunc(this.stoExeWriteReport, discId);
    goto("Exit");

Rewrite:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText2");

    sto.callStoryFunc(this.stoCheck_ComRewriteReport, report.id);
    goto("Exit");

NotCheckingText2:
    var mes =
        __(str.s254, disc.name);
        //"『" + disc.name + "』はすでに論文を作成済みです。改訂しますか？";
    var sel = sto.wuiSelectOkCancel(mes);
    if (sel == pp.selCancel)
        goto("SelDiscovery");

    //'研究論文改訂
    done = sto.callStoryFunc(this.stoExeRewriteReport, report.id);
    goto("Exit");

Exit:
    return done;

};


stoExeWriteReport = function (discId, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);

    //--- シーン変更
    sto.wuiPushScene(pp.ScnRoom, null, cc.TransitionFade, 2);

    var person = pp.mediator.person;

    //'論文ｲﾝｽﾀﾝｽ追加
    var report = new pp.PrReport(person.id, discId);

    /*
    report.personId = pp.mediator.personId;
    report.discoveryId = discId;
    report.societyId = pp.idInvalid;
    report.id = pp.world.reports.length;
    report.composedDate = pp.prDateWithDay(pp.world.year, pp.world.month, 1);
    */

    pp.world.reports.push(report);

    var disc = pp.world.discoveries[discId];
    var c;
    var mes;

    //'*** 発見種別によって分岐
    switch (disc.type)
    {
        case pp.ttTheory:
        {
            //'*** 理論の場合
            //'完成度決定
            c = person.discCredibilities[discId]; // + person.compose / 5 + tm.irand(-3, 3) - 10 - 3;
            c = tm.itrim(c, 0, 100);

            var mesIdx;
            var messages = [ __(str.s255), __(str.s256), __(str.s257), __(str.s258) ];

            if (isCheckingText) {
                mesIdx = forcedVoiceIdx;
            }
            else {
                mesIdx = c < 30 ? 0 : c < 60 ? 1 : c < 90 ? 2 : 3;
            }
            mes = messages[mesIdx];

            //'しゃべり
                //c < 30 ? "さあ論文を仕上げたぞ。\nしかし読み直すのが恐い。" :
                //c < 60 ? "この私の理論が世間に認められると良いのだが・・・。" :
                //c < 80 ? "ここもよし、ここもよしと・・・。\n我ながら良い論文ができあがったな。" :
                //         "素晴らしい論文が完成した。\nこのような論文が書けたことは私の誇りだ。";
            break;
        }
        case pp.ttItem:
        {
            //'*** 道具の場合
            //'しゃべり
            var item = pp.world.items[disc.itemId];
            mes =
                __(str.s259, item.name);
                //"私の" + item.name + "が広く世界に知られるようになる事を期待しよう。";
            c = pp.crReady;
            break;
        }
        case pp.ttThing:
        {
            //'*** 物の場合
            //'しゃべり
            mes =
                __(str.s260, disc.thingName);
                //"発表論文が出来たぞ。この" + disc.thingName + "の発見はとても意義深いものだ。";
            c = pp.crReady;
            break;
        }
        case pp.ttFigure:
        {
            c = person.discCredibilities[discId];
            mes =
                __(str.s261, disc.name);
                //"発表論文が出来たぞ。この" + disc.name + "の正確な描画は貴重な資料となるだろう。";
            break;
        }
        case pp.ttBook:
        {
            mes =
                __(str.s804, disc.name);
                //"個人の力では出版は不可能だ。協会がこの「" + disc.name + "」を出版してくれることを期待しよう。";
            c = pp.crReady;
            break;
        }
    }
    report.credibility = c;

    sto.wuiShowVoice(
        person.id,
        res.Img_CutMath,
        mes,
        __("論文作成"),
        true);

    //'論文表示
    sto.wuiShowReport(report.id, person.isManual ? pp.MW_USER : pp.MW_USER_OR_TIMEOUT, null, true); //@@@

    sto.callTutorialFunc(this.stoTutWriteReport3);

    var theme = pp.world.themes[disc.themeId];

    mes =
        __(str.s263, theme.name, disc.name);
        //theme.name + "に関する論文『" + disc.name + "』を作成しました！";
    sto.wuiShowMessage(
        mes
    );

    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s264, disc.name, report.getCredibilityStr()));
        //"論文『" + disc.name + "』を作成しました。完成度：" + c);

    //--- シーン変更
    sto.wuiPopScene(cc.TransitionFade, 2);

    return true;
};

stoExeRewriteReport = function (reportId, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);

    var person = pp.mediator.person;
    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];

    //'*** 発見種別によって分岐
    var c;
    var mes;

    //--- シーン変更
    sto.wuiPushScene(pp.ScnRoom, null, cc.TransitionFade, 2);

    //'*** 発見種別によって分岐
    switch (disc.type)
    {
        case pp.ttTheory:
        {
            //'*** 理論の場合
            //'完成度決定
            c = person.discCredibilities[disc.id]; // + person.compose / 5 + tm.irand(-3, 3) - 10 - 3;
            c = tm.itrim(c, 0, 100);

            var mesIdx;
            var messages = [ __(str.s265), __(str.s266), __(str.s267), __(str.s268) ];

            if (isCheckingText) {
                mesIdx = forcedVoiceIdx;
            }
            else {
                mesIdx = c < 30 ? 0 : c < 60 ? 1 : c < 90 ? 2 : 3;
            }
            mes = messages[mesIdx];

            /*

            //'しゃべり
            mes = c < 30 ? "論文を書きなおしたぞ。しかし読み直してみると嫌な予感がする・・・。" :
                  c < 60 ? "この私の理論が世に認められると良いのだが・・・。" :
                  c < 80 ? "よし、わかりにくかった部分が明快に表現できた。\nこれで完成としよう。" :
                           "苦労の甲斐あってすばらしい論文が出来あがったぞ。\nこのような論文が書けたことは私の誇りだ。";
                           */

            break;
        }

        case pp.ttFigure:
        {
            c = person.discCredibilities[report.discoveryId];
            mes =
                __(str.s269, disc.name);
                //"発表論文を書きなおしたぞ。\n" + disc.name + "の描画は貴重な資料となるだろう。";
            break;
        }
    }

    sto.wuiShowVoice(
        person.id,
        res.Img_CutMath,
        mes,
        __(str.s270), //"論文改定",
        true
    );

    sto.wuiShowParamChange(
        __("完成度"), report.credibility, c, __("論文『" + disc.name + "』", "Paper '" + tmi.titleize(disc.name) + "'"));

    report.credibility = c;

    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s272, tmi.titleize(disc.name), c));
        //"論文『" + disc.name + "』を改定しました。新完成度：" + c);

    //--- シーン変更
    sto.wuiPopScene(cc.TransitionFade, 2);

    return true;
};

