
stoComPagedResearch = function () {

    var done = false;
    var theme;
    var field;
    var person = pp.mediator.person;

    // Change Scene
    if (pp.mediator.scn instanceof pp.ScnPaged) {
        goto("NoPush");
    }

    sto.wuiPushScene(pp.ScnPagedResearch, null, cc.TransitionFade, 1);
    goto("SelCommand");

NoPush:
    sto.wuiSetScene(pp.ScnPagedResearch, null, cc.TransitionFade, 1);

SelCommand:
    sto.callTutorialFunc(this.stoTutPages2);
    sto.callTutorialFunc(this.stoTutSelectTheme1);
    sto.callTutorialFunc(this.stoTutSelectEquip1);
    sto.callTutorialFunc(this.stoTutExperiment1);
    sto.callTutorialFunc(this.stoTutTheory1);
    sto.callTutorialFunc(this.stoTutWriteReport1);
    sto.callTutorialFunc(this.stoTutSubmitReport1);
    sto.callTutorialFunc(this.stoTutCheckThemeMap);

    var ret = sto.wuiWaitUserInput();

    var stoFuncToCall = null;
    var arg0 = null;
    var arg1 = null;
    var comId;

    if (cc.isArray(ret)) {
        comId = ret[0];
        arg0 = ret[1];
        arg1 = ret[2];
    }
    else {
        comId = ret;
    }

    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

CheckingText:
    if (comId == pp.cmrData) goto("ComDataCT");
    if (comId == pp.cmrDeduce) goto("ComDeduceCT");
    if (comId == pp.cmrDiscovery && person.discCredibilities[arg0] < 0)
        goto("ComDiscoveryCT");

    goto("NotCheckingText");

ComDataCT:
    var themePIdx = arg0;
    sto.callStoryFunc(this.stoCheck_ComData, themePIdx);
    goto("SelCommand");

ComDeduceCT:
    var themePIdx = arg0;
    sto.callStoryFunc(this.stoCheck_ComDeduce, themePIdx);
    goto("SelCommand");

ComDiscoveryCT:
    var discId = arg0;
    sto.callStoryFunc(this.stoCheck_ComDiscovery, discId);
    goto("SelCommand");

NotCheckingText:
    var ret = sto.callTutorialFunc(this.stoTutCheckSelection, ret, pp.world.tutorialStage == pp.tuExperiment1);
    if (ret == false) {
        goto("SelCommand");
    }

    if (comId == pp.cmrData) {
        goto("ComData");
    }
    if (comId == pp.cmrDeduce) {
        goto("ComDeduce");
    }
    if (comId == pp.cmrUnselect) {
        goto("ComUnselectTheme");
    }
    if (comId == pp.cmrSelect) {
        goto("ComSelectTheme");
    }
    if (comId == pp.cmrCancel) {
        goto("Exit");
    }
    if (comId == pp.cmrInfo) {
        goto("ComInfo");
    }
    if (comId == pp.cmrInfoSelf) {
        goto("ComInfoSelf");
    }
    if (comId == pp.cmrInfoTheme) {
        goto("ComInfoTheme");
    }
    if (comId == pp.cmrDiscovery) {
        goto("ComDiscovery");
    }
    if (comId == pp.cmrItem) {
        goto("ComItem");
    }
    if (comId == pp.cmpMap) {
        person.preferredPage = pp.PG_MAP;
        goto("Exit");
    }
    if (comId == pp.cmpResearch) {
        person.preferredPage = pp.PG_RESEARCH;
        goto("SelCommand");
    }
    if (comId == pp.cmpThemeMap) {
        person.preferredPage = pp.PG_THEME_MAP;
        goto("DidPop");
    }
    if (comId == pp.cmpSystem) {
        person.preferredPage = pp.PG_SYSTEM;
        goto("DidPop");
    }

    goto("WaitBeta");

ComInfo:
    sto.callStoryFunc(this.stoComInfo);
    goto("SelCommand");

ComInfoSelf:
    sto.wuiShowPerson(pp.mediator.personId, 0, person.getFullName(), pp.POP_FRM_NO_BUTTONS, pp.MW_USER);
    goto("SelCommand");

ComInfoTheme:
    var themePIdx = arg0;
    sto.wuiShowTheme(person.themePs[themePIdx].themeId, pp.MW_USER);
    goto("SelCommand");

ComData:
    ret = sto.callStoryFunc(this.stoCheckGutless);
    if (!ret) goto("SelCommand");

    var themePIdx = arg0;
    var themeP = person.themePs[themePIdx];
    theme = pp.world.themes[themeP.themeId];
    field = pp.world.fields[theme.fieldId];

    var hasEquip = false;
    for (var i = 0; i < themeP.itemIds.length; i++) {
        if (themeP.itemIds[i] != pp.idInvalid) hasEquip = true;
    }
    if (!hasEquip && field.id != pp.fdImportant)
        stol.wuiShowMessage("SelCommand", __(str.s1011, field.dataName));
            //field.dataName + "器具が選択されていません。");

    ret = sto.wuiSelectOkCancel(
        __(str.s288, theme.name, field.dataName) + CR +
        __(str.s289)
        //theme.name + "の" + field.dataName + "を行います。\n" +
        //"よろしいですか？"
    );

    if (ret == pp.selCancel)
        goto("SelCommand");

    sto.callTutorialFunc(this.stoTutCheckCleanUp);

    sto.callStoryFunc(this.stoExeResearchData, themePIdx);
    done = true;
    goto("Exit");

ComDeduce:
    ret = sto.callStoryFunc(this.stoCheckGutless);
    if (!ret) goto("SelCommand");

    var themePIdx = arg0;
    theme = pp.world.themes[person.themePs[themePIdx].themeId];
    field = pp.world.fields[theme.fieldId];

    ret = sto.wuiSelectOkCancel(
        __(str.s288, theme.name, field.deduceName) + CR + __(str.s289)
    );
    //theme.name + "の" + field.deduceName + "を行います。\n" +
    //"よろしいですか？");

    if (ret == pp.selCancel)
        goto("SelCommand");

    sto.callStoryFunc(this.stoExeResearchDeduce, themePIdx);
    done = true;
    goto("Exit");

ComUnselectTheme:
    var themePIdx = arg0;
    theme = pp.world.themes[person.themePs[themePIdx].themeId];

    ret = sto.wuiSelectOkCancel(
        __(str.s292, themePIdx + 1, theme.name));
        //__("研究テーマ") + (themePIdx + 1) + "『" +
        //theme.name + "』の研究を終了します。\nよろしいですか？");

    if (ret == pp.selCancel) {
        goto("SelCommand");
    }

    //研究終了
    sto.callStoryFunc(this.stoExeUnselectTheme, themePIdx);

    pp.mediator.uiUpdate();
    if (pp.mediator.scn.updateVoice) {
        pp.mediator.scn.updateVoice(themePIdx);
    }
    goto("SelCommand");

ComSelectTheme:
    var themePIdx = arg0;

    sto.wuiPushScene(pp.ScnThemeMap, null, cc.TransitionSlideInR, 0.5);

    sto.callTutorialFunc(this.stoTutSelectTheme2);

ReSelectTheme:
    var userSel = sto.wuiWaitUserInput();

    pp.mediator.hideBalloons();

    if (userSel == pp.selCancel)
        goto("Cancel");

    var okCancel = sto.wuiShowTheme(userSel, pp.MW_USER_OR_TIMEOUT, pp.POP_FRM_OK_CANCEL_BUTTONS);
    if (okCancel == pp.selCancel)
        goto("ReSelectTheme");

Cancel:
    var ret = sto.callTutorialFunc(this.stoTutCheckSelection, userSel, true);
    if (ret == false) {
        goto("ReSelectTheme");
    }

    if (userSel == pp.selCancel) {
        goto("ExitSelectTheme");
    }

    var newThemeId = userSel;
    var theme = pp.world.themes[userSel];

    //重複チェック
    if (person.themePs[0].themeId == userSel ||
        person.themePs[1].themeId == userSel ||
        person.themePs[2].themeId == userSel)
    {
        stol.wuiShowMessage("ReSelectTheme", __(str.s294));
        //"そのテーマはすでに選択済みです。");
    }

    //確認
    /*
    var okCancel = sto.wuiSelectOkCancel(
        __(str.s295, themePIdx+1, theme.name) + CR +
        __(str.s296)
    );
    */

    //"研究テーマ" + (themePIdx + 1) + "を『" + theme.name + "』にします。\n" +
    //    "よろしいですか？");

    var ret = sto.callTutorialFunc(this.stoTutCheckSelection, okCancel == pp.selCancel ? pp.selCancel : userSel);
    if (ret == false || okCancel == pp.selCancel) {
        goto("ReSelectTheme");
    }

    //テーマ確定
    sto.callStoryFunc(this.stoExeSelectTheme, themePIdx, newThemeId);
    //this.setCurrentThemeAt(themePIdx, newThemeId);

ExitSelectTheme:
    sto.wuiPopScene(cc.TransitionSlideInL, 0.5);
    pp.mediator.uiUpdate();
    if (pp.mediator.scn.updateVoice) {
        pp.mediator.scn.updateVoice(themePIdx);
    }
    goto("SelCommand");

ComItem:
    var themePIdx = arg0;
    var itemIdx = arg1;

    var themeP = person.themePs[themePIdx];
    var itemId = themeP.itemIds[itemIdx];
    var theme = pp.world.themes[themeP.themeId];

    if (itemId == pp.idInvalid) {
        goto("ToSelectItem");
    }
    var item = pp.world.items[itemId];

ToSelectSubItemCommand:
    var ret = sto.wuiSelectOptionsWithCancel([
        __("情報"), __("変更"), __("選択解除") ]);

    //cc.log("ret=" + ret);
    if (cc.isArray(ret)) {
        // workaround. ignore invalid selection.
        //cc.log("invalid command!");
        goto("SelCommand");
    }

    if (ret == pp.selCancel) {
        goto("SelCommand");
    }
    if (ret == 0) {
        goto("ItemInfo");
    }
    if (ret == 1) {
        goto("ToSelectItem");
    }
    if (ret == 2) {
        goto("UnselectItem");
    }

UnselectItem:
    /*
    var ret = sto.wuiSelectOkCancel(__(str.s1012, item.name));
        //"『" + item.name + "』の選択を解除します。\nよろしいですか？");
    if (ret == pp.selCancel) {
        goto("ToSelectSubItemCommand");
    }
    */
    themeP.itemIds[itemIdx] = pp.idInvalid;
    pp.mediator.uiUpdate();

    var pos = pp.mediator.scn.frmThemeR.lyrItems[itemIdx].convertToWorldSpaceAR();
    sto.wuiEffectItemUnselected(itemId, pos);

    goto("SelCommand");

ItemInfo:
    sto.wuiShowItem(itemId, person.id, pp.MW_USER);
    goto("ToSelectSubItemCommand");

ToSelectItem:
    sto.callTutorialFunc(this.stoTutSelectEquip2);

ToSelectItem2:
    var newItemId = sto.wuiSelectItem([pp.fiPerson, person.id, pp.fiField, theme.fieldId]);

    //cc.log("newItemId=" + newItemId);
    if (cc.isArray(newItemId)) {
        // workaround. ignore invalid selection.
        //cc.log("invalid command!");
        goto("SelCommand");
    }

    var checkOk = sto.callTutorialFunc(this.stoTutCheckSelection, newItemId, true);
    if (checkOk == false) {
        goto("ToSelectItem2");
    }
    if (newItemId == pp.selCancel) {
        goto("SelCommand");
    }
    var newItem = pp.world.items[newItemId];

    for (var i = 0; i < pp.maxNumItemsInThemeP; i++) {
        if (themeP.itemIds[i] != newItemId) continue;

        stol.wuiShowMessage("ToSelectItem",
            __(str.s1013));
            //"そのアイテムは選択済みです。");
    }

    /*
    var ret = sto.wuiSelectOkCancel(
        __(str.s300, itemIdx+1, newItem.name) + CR +
        __(str.s296)
        //"実験器具" + (itemIdx+1) + "を『" + newItem.name + "』にします。" + CR +
        //"よろしいですか？"
    );
    if (ret == pp.selCancel) {
        goto("ToSelectItem2");
    }
    */

    sto.callTutorialFunc(this.stoTutCheckCleanUp);

    themeP.itemIds[itemIdx] = newItemId;

    var pos = pp.mediator.scn.frmThemeR.lyrItems[itemIdx].convertToWorldSpaceAR();
    sto.wuiEffectItemSelected(newItemId, pos);

    pp.mediator.uiUpdate();
    goto("SelCommand");

ComDiscovery:
    var discId = arg0;
    var disc = pp.world.discoveries[discId];
    theme = pp.world.themes[disc.themeId];
    field = pp.world.fields[theme.fieldId];
    var report = person.getReportForDisc(discId);

SelSubCommand:
    var strs = [];
    var ids = [];

    strs.push(__("情報"));
    ids.push(pp.cmdInfo);

    if (disc.type == pp.ttTheory) {
        strs.push(__("理論検証"));
        ids.push(pp.cmdTheory);
    }
    if (disc.type == pp.ttFigure) {

        if (person.discCredibilities[discId] == pp.crPreMake) {
            strs.push(__("スケッチ"));
        }
        else{
            strs.push(__("再スケッチ"));
        }
        ids.push(pp.cmdFigure);
    }
    if (disc.type == pp.ttItem && person.discCredibilities[discId] == pp.crPreMake) {
        strs.push(__("発明品試作"));
        ids.push(pp.cmdItem);
    }

    if (person.getReportForDisc(discId) == null) {
        strs.push(__("論文作成"));
        ids.push(pp.cmdWriteReport);
    }
    else {
        var report = person.getReportForDisc(discId);
        if (report.societyId == pp.idInvalid) {
            strs.push(__("論文提出"));
            ids.push(pp.cmdSubmitReport);
        }
        else {
            strs.push(__("公開停止"));
            ids.push(pp.cmdStopReport);
        }

        strs.push(__("論文改訂"));
        ids.push(pp.cmdWriteReport);
    }

    sto.callTutorialFunc(this.stoTutTheory2);
    sto.callTutorialFunc(this.stoTutWriteReport2);
    sto.callTutorialFunc(this.stoTutSubmitReport2);

ReSelSubCommand:
    ret = sto.wuiSelectOptionsWithCancel(strs, __("発見"));

Workaround:
    var checkOk = sto.callTutorialFunc(this.stoTutCheckSelection, ret == pp.selCancel ? pp.selCancel : ids[ret], true);
    if (checkOk == false) {
        goto("ReSelSubCommand");
    }

    if (ret == pp.selCancel)
        goto("SelCommand");

    if (ids[ret] == pp.cmdInfo) {
        goto("ComDiscInfo");
    }
    if (ids[ret] == pp.cmdTheory) {
        goto("ComDiscTheory");
    }
    if (ids[ret] == pp.cmdFigure) {
        goto("ComDiscFigure");
    }
    if (ids[ret] == pp.cmdItem) {
        goto("ComDiscItem");
    }
    if (ids[ret] == pp.cmdWriteReport) {
        goto("ComWriteReport");
    }
    if (ids[ret] == pp.cmdSubmitReport) {
        goto("ComSubmitReport");
    }
    if (ids[ret] == pp.cmdStopReport) {
        goto("ComStopReport");
    }

    // Workaround for unexpected fast double-clicks on discovery menu button
    ret = sto.wuiWaitUserInput();
    cc.log("Workarounded");
    goto("Workaround");

    //goto("WaitBetaSub");


ComDiscInfo:
    sto.callStoryFunc(this.stoComInfoDisc, discId, person.id);
    goto("SelSubCommand");

ComDiscTheory:
    done = sto.callStoryFunc(this.stoComTheory, discId);

    var ret = sto.callTutorialFunc(this.stoTutCheckCond, done);
    if (ret == false)
        goto("ReSelSubCommand");

    goto("MightDoneSubCommand");

ComDiscFigure:
    done = sto.callStoryFunc(this.stoComDrawFigure, discId);
    goto("MightDoneSubCommand");

ComDiscItem:
    done = sto.callStoryFunc(this.stoComMakeTrial, discId);
    goto("MightDoneSubCommand");

ComWriteReport:
    done = sto.callStoryFunc(this.stoComWriteReport, discId);

    var ret = sto.callTutorialFunc(this.stoTutCheckCond, done);
    if (ret == false)
        goto("ReSelSubCommand");

    goto("MightDoneSubCommand");

ComSubmitReport:
    done = sto.callStoryFunc(this.stoComSubmitReport, report.id);

    var ret = sto.callTutorialFunc(this.stoTutCheckCond, done);
    if (ret == false)
        goto("ReSelSubCommand");

    if (done)
        goto("DidPop");

    goto("MightDoneSubCommand");

ComStopReport:
    done = sto.callStoryFunc(this.stoComStopReport, report.id);
    goto("MightDoneSubCommand");

WaitBeta:
    // sto.wuiShowMessage("べーたばんをおまちください");
    // workaround...
    goto("SelCommand");

WaitBetaSub:
    sto.wuiShowMessage("べーたばんをおまちくださいさぶ");
    goto("SelSubCommand");

MightDoneSubCommand:
    pp.mediator.uiUpdate();

    if (!done) {
        goto("SelSubCommand");
    }

Exit:
    pp.mediator.uiUpdate();

    // Restore Scene
    sto.wuiPopScene(cc.TransitionFade, 1);

DidPop:
    return done;
};

stoExeResearchDeduce = function (themepIdx, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);

    var person = pp.mediator.person;
    var themep = person.themePs[themepIdx];
    var theme = pp.world.themes[themep.themeId];
    var field = pp.world.fields[theme.fieldId];
    var fieldp = person.fieldPs[theme.fieldId];

    var up = Math.floor(1 + (fieldp.knowledge + themep.data) / 20);
    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);

    var p0 = themep.deduce;
    var p1 = tm.imin(p0 + up, theme.getMaxDeduce());
    themep.deduce = p1;

    //台詞表示
    var voice;
    if (isCheckingText) {
        voice = forcedVoiceIdx == 0 ? theme.voiceT1 : forcedVoiceIdx == 1 ? theme.voiceT2 : theme.voiceT3;
    }
    else {
        voice = p1 <= 10 ? theme.voiceT1 : p1 <= 40 ? theme.voiceT2 : theme.voiceT3;
    }

    var image = res.Img_CutStudy;

    //--- シーン変更
    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    sto.wuiShowVoice(
        person.id,
        image,
        voice,
        theme.name + " - " + field.deduceName,
        true);

    if (isCheckingText)
        goto("Exit");

    //パラメータ変化音＋表示
    //pp.mediator.playSound(res.Snd_Up, 0.3);
    sto.wuiShowParamChange(field.deduceName, p0, p1, __("『") + theme.name + __("』"));

    pp.mediator.uiClearOverlappedPopups();

    sto.callStoryFunc(this.stoCheckDiscovery, themepIdx);

    // Log
    pp.mediator.logPersonCommand(
        person.id, __(str.s317, theme.name, field.deduceName));
        //theme.name + "についての" + field.deduceName + "をしています。");

Exit:
    pp.mediator.uiClearOverlappedPopups();

    //--- シーン復帰
    sto.wuiPopScene(cc.TransitionFade, 2);
    pp.mediator.uiUpdate();

    return true;
};


stoExeSelectTheme = function (themePIdx, themeId) {

    var person = pp.mediator.person;

    var maxDeduce = 0;
    var maxData = 0;

    for (var i = 0; i < pp.world.discoveries.length; i++) {
        if (person.discCredibilities[i] != pp.crPreNotice &&
            pp.world.discoveries[i].themeId == themeId)
        {
            maxDeduce = tm.max(maxDeduce, pp.world.discoveries[i].deduce);
            maxData = tm.max(maxData, pp.world.discoveries[i].data);
        }
    }
    person.themePs[themePIdx].themeId = themeId;
    person.themePs[themePIdx].data = maxData;
    person.themePs[themePIdx].deduce = maxDeduce;

    var theme = pp.world.themes[themeId];

    // Log
    pp.mediator.logPersonCommand(
        person.id, __("研究テーマ") + " " + (themePIdx + 1) + " " + __("選択") + " - " + __("『") + theme.name + __("』"));
    //theme.name + "についての" + field.deduceName + "をしています。");

    return false;
};


stoExeUnselectTheme = function (themePIdx) {

    var person = pp.mediator.person;
    var themep = person.themePs[themePIdx];
    var theme = pp.world.themes[themep.themeId];

    themep.themeId = pp.ID_INVALID;
    for (var i = 0; i < themep.itemIds.length; i++)
        themep.itemIds[i] = pp.idInvalid;

    // Log
    pp.mediator.logPersonCommand(
        person.id,__("研究テーマ") + " " + (themePIdx + 1) + " " + __("選択解除") + " - " + __("『") + theme.name + __("』"));
    //theme.name + "についての" + field.deduceName + "をしています。");

    return false;
};


stoExeResearchData = function (themepIdx, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);

    var person = pp.mediator.person;
    var themep = person.themePs[themepIdx];
    var theme = pp.world.themes[themep.themeId];
    var field = pp.world.fields[theme.fieldId];
    var fieldp = person.fieldPs[theme.fieldId];

    var image = pp.fieldCuts[theme.fieldId];

    //--- 上昇値計算
    var up = Math.floor(fieldp.experience/10 + 1);
    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);

    // アイテム効果
    for (var i = 0; i < themep.itemIds.length; i++) {
        if (themep.itemIds[i] != pp.idInvalid) {
            var itemId = themep.itemIds[i];
            up += pp.world.items[itemId].gain;

            if (itemId == pp.iiMonoMicroscope)
                image = res.Img_CutBiology2;
        }
    }

    // 天文台効果
    if (theme.fieldId == pp.fdAstronomy) {
        var obsId = person.getObservatoryId();
        if (obsId != pp.idInvalid) {
            var obs = pp.world.observatories[obsId];
            up += Math.floor(obs.equipment/20 +1);
            image = res.Img_CutAstronomy2;
        }
    }

    // 執筆時特殊処理
    if (field.id == pp.fdImportant) {
        up = 5;
    }

    var p0 = themep.data;
    var p1 = tm.imin(p0 + up, theme.getMaxData());
    themep.data = p1;

    //台詞表示
    var voice;
    if (isCheckingText) {
        voice = forcedVoiceIdx == 0 ? theme.voiceE1 : forcedVoiceIdx == 1 ? theme.voiceE2 : theme.voiceE3;
    }
    else {
        voice = p1 <= 10 ? theme.voiceE1 : p1 <= 40 ? theme.voiceE2 : theme.voiceE3;
    }

    //--- シーン変更
    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    sto.wuiShowVoice(
        person.id,
        image,
        voice,
        theme.name + " - " + field.dataName,
        true);

    if (isCheckingText)
        goto("Exit");

    //パラメータ変化表示
    sto.wuiShowParamChange(field.dataName, p0, p1, __("『") + theme.name + __("』"), true);

    sto.callTutorialFunc(this.stoTutExperiment2);

    pp.mediator.uiClearOverlappedPopups(1);

    if (field.id == pp.fdImportant)
        goto("DidSkillUp");

    //熟練度上昇
    // 50まではあがりやすい 80以降はここでは上がらず
    var p0 = fieldp.experience;
    var up = tm.irand(2, 3) - (p0 < 50 ? 0 : p0 < 60 ? 1 : p0 < 80 ? 2 : 3);
    var p1 = tm.imin(p0 + up, pp.fieldExperienceMax);

    if (p0 == p1)
        goto("DidSkillUp");

    sto.wuiShowParamChange(__(field.name2 + "熟練", "Skill of " + field.name), p0, p1);
    fieldp.experience = p1;

DidSkillUp:

    pp.mediator.uiClearOverlappedPopups();

    sto.callStoryFunc(this.stoCheckDiscovery, themepIdx);

    // Log
    pp.mediator.logPersonCommand(
        person.id, __(str.s317, theme.name, field.dataName));
    //theme.name + "についての" + field.deduceName + "をしています。");

Exit:
    pp.mediator.uiClearOverlappedPopups();

    //--- シーン復帰
    sto.wuiPopScene(cc.TransitionFade, 2);
    pp.mediator.uiUpdate();

    return true;
};


stoCheckDiscovery = function (themepIdx) {

    var person = pp.mediator.person;
    var themep = person.themePs[themepIdx];
    var newDiscIds = [];

    for (var i = 0; i < pp.world.discoveries.length; i++) {  //全発見をチェック
        var disc = pp.world.discoveries[i];

        if (disc.themeId != themep.themeId) // 研究テーマに属さない発見ならスキップ
            continue;
        if (person.discCredibilities[i] != pp.crPreNotice) // 発見ずみならスキップ
            continue;
        if (themep.deduce < disc.deduce)  // 推理値が基準未満ならスキップ
            continue;
        if (themep.data < disc.data)　// データ値が基準未満ならスキップ
            continue;

        newDiscIds.push(i);　// 発見するリストへ追加
    }

    var i = 0;
Next:
    if (i >= newDiscIds.length) goto("Exit");
    sto.callStoryFunc(this.stoDiscover, newDiscIds[i]);
    i++;
    goto("Next");
Exit:
    //cc.log("DISC CHECK DONE!");
    return;
};


stoDiscover = function (discId) {

    var person = pp.mediator.person;
    var disc = pp.world.discoveries[discId];
    var theme = pp.world.themes[disc.themeId];
    var mes;

    if (disc.type == pp.ttTheory) goto("ttTheory");
    else if (disc.type == pp.ttItem) goto("ttItem");
    else if (disc.type == pp.ttFigure) goto("ttFigure");
    else if (disc.type == pp.ttThing) goto("ttThing");
    else if (disc.type == pp.ttBook) goto("ttBook");

ttTheory:
    var caption = __(str.s318); //"理論発見";
    sto.wuiShowVoice(
        person.id,
        null,
        [
            __(str.s319), //"まてよ・・・。",
            disc.voice
        ],
        caption,
        true
    );

    // 初期完成度決定
    //var p = tm.imin(person.fieldPs[theme.fieldId].aptitude / 2 + tm.irand(0, 19), disc.credibility);
    var p = disc.credibility - tm.irand(20, 40);
    p = tm.itrim(p, 1, disc.credibility);

    person.discCredibilities[discId] = p;
    pp.mediator.uiUpdate();
    mes = __(str.s320, theme.name, disc.name);
        //theme.name + "の研究中に、『" + disc.name + "』を着想しました！";
    sto.wuiShowMessage(mes, caption);

    sto.callTutorialFunc(this.stoTutDiscovery);

    pp.mediator.uiClearOverlappedPopups();

    return;

ttItem:
    var caption = __(str.s321); //"発明";
    sto.wuiShowVoice(
        person.id,
        null,
        [
            __(str.s319),
            //"まてよ・・・。",
            disc.voice
        ],
        caption,
        true
    );
    person.discCredibilities[discId] = pp.crPreMake;
    pp.mediator.uiUpdate();
    mes = __(str.s323, theme.name, disc.name, tmi.article(disc.name));
        //theme.name + "の研究中に、『" + disc.name + "』の可能性に気がつきました！";
    sto.wuiShowMessage(mes, caption);
    pp.mediator.uiClearOverlappedPopups();
    return;

ttFigure:
    var caption = __(str.s324); // "図発見";
    sto.wuiShowVoice(
        person.id,
        null,
        [
            disc.voice,
            __(str.s325) //"この様子をなんとか描画できないものだろうか・・・。"
        ],
        caption,
        true
    );
    person.discCredibilities[discId] = pp.crPreMake;
    pp.mediator.uiUpdate();
    mes =
        __(str.s326, theme.name, disc.name);
        //theme.name + "の研究中に、特徴的な『" + disc.name + "』を発見しました！";
    sto.wuiShowMessage(mes, caption);
    pp.mediator.uiClearOverlappedPopups();
    return;

ttThing:
    var caption = __(str.s327); //"存在発見";
    sto.wuiShowVoice(
        person.id,
        null,
        [
            __(str.s328), //"これは・・・。",
            disc.voice
        ],
        caption,
        true
    );
    person.discCredibilities[discId] = pp.crReady;
    pp.mediator.uiUpdate();
    mes = __(str.s329, theme.name, tmi.titleize(disc.name));
        //theme.name + "の研究中に、『" + disc.name + "』を発見しました！";
    sto.wuiShowMessage(mes, caption);
    pp.mediator.uiClearOverlappedPopups();
    return;

ttBook:
    var caption = __(str.s800); //"執筆完了";
    sto.wuiShowVoice(
        person.id,
        null,
        [
            __(str.s801),
            //"できたぞ・・・。",
            disc.voice
        ],
        caption,
        true
    );
    person.discCredibilities[discId] = pp.crReady;
    pp.mediator.uiUpdate();
    mes = __(str.s802, theme.name, disc.name);
        //theme.name + "の研究成果として、『" + disc.name + "』を書き上げました！";
    sto.wuiShowMessage(mes, caption);
    pp.mediator.uiClearOverlappedPopups();
    return;
};