
stoComShop = function () {

    var person = pp.mediator.person;
    var item;
    var done = false;
    var itemId;

    var options = [
        __("購入"),
        __("売却")
    ];


SelSubCommand:

    var ret;
    var userSel = sto.wuiSelectOptionsWithCancel(options, __("売買"));

    if (userSel == pp.selCancel) {
        goto("Exit");
    }
    else if (userSel == 0) {
        goto("BuyItem");
    }
    else if (userSel == 1) {
        goto("SellItem");
    }
    else
        goto("Other");

BuyItem:
    //'選択ﾌｫｰﾑ表示
    itemId = sto.wuiSelectItem();
    if (itemId == pp.selCancel)
        goto("SelSubCommand");

    item = pp.world.items[itemId];

    if (person.itemNums[itemId] > 0)
    {
        stol.wuiShowMessage("BuyItem", __(str.s371)); //"すでに所有しています。");
    }

    if (person.money < item.price)
    {
        stol.wuiShowMessage("BuyItem", __(str.s372)); //"資金が足りません。");
    }

    sto.wuiShowItem(itemId, null, pp.MW_USER);

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s373, item.name, item.price));
        //item.name + "を購入します。\nよろしいですか？\n必要資金: " + item.price);
    if (ret == pp.selCancel)
        goto("BuyItem");

    //'購入実行
    sto.callStoryFunc(this.stoExeBuy, itemId);
    done = false;
    goto("SelSubCommand");

SellItem:
    //'選択ﾌｫｰﾑ表示
    itemId = sto.wuiSelectItem([pp.ftPerson, person.id]);
    if (itemId == pp.selCancel)
        goto("SelSubCommand");

    item = pp.world.items[itemId];

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s374, item.name, tm.int(item.price/2)));
        //item.name + "を売却します。\nよろしいですか？",
        //"売却価格: " + tm.int(item.price/2)]);
    if (ret == pp.selCancel)
        goto("SellItem");

    //'売却実行
    sto.callStoryFunc(this.stoExeSell, itemId);
    done = false;
    goto("SelSubCommand");

Exit:
    return done;
};

stoExeBuy = function (itemId) {

    var person = pp.mediator.person;
    var item = pp.world.items[itemId];

    sto.wuiShowMessage(
        __(str.s375, person.fullName, item.name));
        //person.fullName + "は" + item.name + "を購入しました。");

    // Log
    pp.mediator.logPersonCommand(person.id, __(str.s376, item.name));
        //item.name + "を購入しました。");

    person.itemNums[itemId]++;
    person.money -= item.price;

    pp.mediator.uiUpdate();

    sto.callStoryFuncIf(person.isManual, this.stoLibUnlock, pp.libItem, itemId, item.name);
};

stoExeSell = function (itemId) {

    var person = pp.mediator.person;
    var item = pp.world.items[itemId];

    sto.wuiShowMessage(__(str.s377, person.fullName, item.name));
        //person.fullName + "は" + item.name + "を売却しました。");

    // Log
    pp.mediator.logPersonCommand(person.id, __(str.s378, item.name));
        //item.name + "を売却しました。");

    person.itemNums[itemId]--;
    person.money += tm.int(item.price/2);

    // 使用中だったら解除
    for (var i = 0; i < person.themePs.length; i++) {
        var themep = person.themePs[i];
        for (var j = 0; j < themep.itemIds.length; j++) {
            if (themep.itemIds[j] == itemId)
                themep.itemIds[j] = pp.idInvalid;
        }
    }

    pp.mediator.uiUpdate();
};

