
stoComStopReport = function (preSelectedReportId) {

    var done = false;
    var reportId;
    var societyId;

    if (pp.isIdValid(preSelectedReportId)) {
        reportId = preSelectedReportId;
        goto("DidSelectReport");
    }


SelReport:
    if (pp.isIdValid(preSelectedReportId)) {
        goto("Exit");
    }

    //'論文選択ﾌｫｰﾑ表示
    reportId = sto.wuiSelectReport(
        __(str.s383),
        //"論文選択",
        [pp.frPerson, pp.mediator.personId]);

    if (reportId == pp.selCancel)
        goto("Exit");

DidSelectReport:
    if (pp.world.reports[reportId].societyId == pp.idInvalid)
    {
        stol.wuiShowMessage("SelReport",
            __(str.s384));
            //"その論文は公開されていません。");
    }

    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s385, tmi.titleize(disc.name)));
        //"論文『" + disc.name + "』の公開を停止します。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("SelReport");

    //'研究論文提出
    sto.callStoryFunc(this.stoExeStopReport, reportId);

    //'ｺﾏﾝﾄﾞが実行された
    done = true;

Exit:
    return done;
};



stoExeStopReport = function (reportId) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var report = pp.world.reports[reportId];
    var society = pp.world.societies[report.societyId];
    var person = pp.mediator.person;
    var disc = pp.world.discoveries[report.discoveryId];

    var up;
    var mup;

    //'公開停止
    report.societyId = pp.idInvalid;

    sto.wuiShowMessage(
        __(str.s386, tmi.titleize(disc.name)));
        //"論文『" + disc.name + "』の公開は停止されました。");

    //'名声DOWN
    //'(上昇値) = -(重要度 + 組織権威 / 10 - 5) * (支持率 / 50) * 1.2
    up = -(disc.importance + society.authority / 10 - 5) * (report.backing / 50)*1.2;
    up = tm.imax(up, -person.fame);

    sto.wuiShowParamChange(__("名声"), person.fame, person.fame + up, person.fullName);
    person.fame += up;

    //'研究費没収
    mup = tm.imax(-person.money, tm.imax(up * 5, -300));
    sto.wuiShowMessage(
        __(str.s388, society.name));
        //society.name + "に研究費を返却します。");
    sto.wuiShowParamChange(__("資金"), person.money, person.money + mup, person.fullName);
    person.money += mup;

    return;
};
