
stoComSubmitReport = function (preSelectedReportId) {

    var done = false;
    var reportId;
    var societyId;

    if (pp.isIdValid(preSelectedReportId)) {
        reportId = preSelectedReportId;
        goto("DidSelectReport");
    }

SelReport:
    if (pp.isIdValid(preSelectedReportId)) {
        goto("Exit");
    }

    //'論文選択ﾌｫｰﾑ表示
    reportId = sto.wuiSelectReport(__("論文"), [pp.frPerson, pp.mediator.personId, pp.frPublished, false]);

    if (reportId == pp.selCancel)
        goto("Exit");

DidSelectReport:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComSubmitReport, reportId);
    goto("Exit");

NotCheckingText:
    var ret = sto.callStoryFunc(this.stoCheckDiscouraged);
    if (!ret) goto("SelReport");

    if (pp.world.reports[reportId].societyId != pp.idInvalid)
    {
        stol.wuiShowMessage("SelReport",
            __(str.s509)
            //"その論文は提出済みです。"
        );
    }

    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];

SelSociety:
    //'組織選択ﾌｫｰﾑ表示
    societyId = sto.wuiSelectSociety();
    if (societyId == pp.selCancel)
        goto("SelReport");

    var society = pp.world.societies[societyId];

    //'確認
    var ret = sto.wuiSelectOkCancel(
        __(str.s510, tmi.titleize(disc.name), society.name )
        //"論文『" + disc.name + "』を" + society.name + "に提出します。\nよろしいですか？"
    );
    if (ret == pp.selCancel)
        goto("SelSociety");

    //'研究論文提出

    // シーンが研究室ならここで POP する
    if (!(pp.mediator.scn instanceof pp.ScnPagedResearch)) goto("NoPop");
    sto.wuiPopScene(cc.TransitionFade, 1);

NoPop:
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, societyId);

    //'ｺﾏﾝﾄﾞが実行された
    done = true;

Exit:
    return done;
};



stoExeSubmitReport = function (reportId, societyId, forcedValues) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedValues);

    var lastThemeDone = false;

    var society = pp.world.societies[societyId];
    var person = pp.mediator.person;
    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];

    //'提出される組織の役員がﾌﾟﾚｲﾔｰなら必ずﾒｯｾｰｼﾞ表示
    if (society.toShowMessageByJobPerson())
        pp.mediator.toShowMessageTemporary = true;

    var backing;
    var ret = sto.callStoryFunc(this.stoIsReportAccepted, reportId, societyId, forcedValues);
    var accepted = ret[0];
    var backing = ret[1];

    if (isCheckingText && disc.type != pp.ttBook)
        goto("Exit");

    if (accepted == false)
        goto("Rejected");

Accepted:
    //'*** 受理された
    var theme = pp.world.themes[report.getThemeId()];
    var prevAuthority = theme.getAuthorityPerson();

    report.societyId = societyId;
    report.acceptDate = pp.prDateWithDay(pp.world.year, pp.world.month, 1);
    report.backing = backing;

    if (disc.id == pp.diPrincipia)
        goto("Principia");

    sto.wuiShowMessage(
        __(str.s511, tmi.titleize(disc.name), society.name)
        //"論文『" + disc.name + "』が" + society.name + "によって受理、公開されました！"
    );

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s512, tmi.titleize(disc.name), society.name)
        //"論文『" + disc.name + "』を" + society.name + "に提出しました。結果：受理"
    );

    //'発明なら店に追加
    if (disc.type == pp.ttItem)
    {
        var item = pp.world.items[disc.itemId];
        item.isActive = true;
    }

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(
            __(str.s513, society.name, tmi.titleize(disc.name)) + (
                backing > 80 ? __(str.s515):
                backing > 70 ? __(str.s516) :
                backing > 50 ? __(str.s517) :
                               __(str.s518))
        );

            /*
            society.name + "に論文『" +
            disc.name + "』を提出、受理。" + (
                backing > 80 ? "絶賛される。" :
                backing > 70 ? "高い評価を得る。" :
                backing > 50 ? "まずまずの評価。" :
                                "しかし不評。")
                                */
    }

    //'上昇値の元を計算
    //'(上昇値) = (重要度 + 組織権威 / 10 - 5) * (支持率 / 50)
    var fup = Math.floor((disc.importance + society.authority / 10 - 5) * (report.backing / 50));

    //'名声UP
    sto.wuiShowMessage(
        __(str.s519, tmi.titleize(disc.name))
        //"論文『" + disc.name + "』が名声を博しています！"
    );

    sto.wuiShowParamChange(__("名声"), person.fame, person.fame+fup, person.fullName);

    person.fame += fup;

    pp.mediator.uiUpdate();

    //'研究費授与
    var mup = tm.imin(fup * 5, 300);
    mup = tm.imin(mup, pp.monMax - person.money);

GetMoney:
    sto.wuiShowVoice(
        [person.id, pp.piJudgeC],
        null,
        [
            "@" +
                __(str.s521, person.fullName, society.name),
                __(str.s522)
            //person.fullName + "氏の研究に" + society.name + "として研究費を提供することが決定しました。より一層の研究成果をあげてください。",
            //"ありがとうございます。"
        ],
        __(str.s523),
        //"論文受理",
        false);

    sto.wuiShowParamChange(__("資金"), person.money, person.money+mup, person.fullName);
    person.money += mup;

    pp.mediator.uiUpdate();

    //'組織権威上昇
    var aup = tm.imin(fup / 10, 20);
    sto.wuiShowParamChange(__("権威"), society.authority, society.authority+aup, society.name);
    society.authority += aup;

    if (prevAuthority == theme.getAuthorityPerson(true))
        goto("DidChangeAuthority");

    //*** この科学者がテーマ権威になった
/*
    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowVoice(
        theme.getCommentator().id,
        null,
        "いま" + theme.name + "を最も理解しているのは間違いなく" + person.lastName + "さんだ。"
    );

    pp.mediator.toShowMessageTemporary = false;
*/

    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowMessage(
        __(str.s925, person.fullName, theme.name)
        //@person.fullName + "はテーマ『" + theme.name + "』の権威になりました。"
    );

    pp.mediator.toShowMessageTemporary = society.toShowMessageByJobPerson();

    pp.mediator.logPersonCommand(person.id,
        __(str.s926, theme.name));
        //"テーマ『" + theme.name + "』の権威になりました。");

DidChangeAuthority:

    if (!lastThemeDone)
        goto("DidLastMessage");

    // 科学の創始者メッセージ
    pp.mediator.toShowMessageTemporary = true;

    sto.wuiSetFocusOnPlace(person.placeId);

    sto.wuiShowMessage(
        __(str.s930, person.fullName),
        //person.fullName + "は近代科学の創始者となりました。",
        null,
        null,
        null,
        null,
        true // force wait user
    );

    pp.mediator.toShowMessageTemporary = society.toShowMessageByJobPerson();

    if (!person.isManual)
        goto("DidLastMessage");

    // エンディング表示設定
    //'ｹﾞｰﾑｵｰﾊﾞｰ理由ｾｯﾄ
    pp.mediator.gameOverReason = pp.goClear;

    //'次ｽﾃｰﾄは『ｴﾝﾃﾞｨﾝｸﾞ』
    pp.mediator.gameState = pp.gsEndGame;
    pp.mediator.pidEnding = person.id;

    //sto.callStoryFunc(this.stoEvePersonRetired, person.id);


DidLastMessage:
    goto("Exit");

Principia:
    //*** 「自然哲学の数学的諸原理」

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s816, tmi.titleize(disc.name), society.name)
        //"『" + disc.name + "』を" + society.name + "に提出しました。結果：出版"
    );

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(
            __(str.s817, disc.name)
            //"後世に多大な影響をおよぼすことになる『" + disc.name + "』を出版し、絶賛される。"
        );
    }

    //'ﾒｯｾｰｼﾞ表示
    if (person.isManual == false)
        goto("NotManual");

Manual:
    sto.wuiShowMessageEx(
        __(str.s818, person.fullName, disc.name),
        //person.fullName + "の著作" + "『" + disc.name + "』が出版されました！",
        res.Img_ItemBook);

    goto("EndIf");

NotManual:
    pp.mediator.toShowMessageTemporary = true;

    sto.wuiShowMessage(
        __(str.s818, person.fullName, disc.name));
        //person.fullName + "の著作" + "『" + disc.name + "』が出版されました！",

    pp.mediator.toShowMessageTemporary = society.toShowMessageByJobPerson();

EndIf:
    //'上昇値の元を計算
    var fup = 500; //Math.floor((disc.importance + society.authority / 10 - 5) * (report.backing / 50));

    //'名声UP
    sto.wuiShowParamChange(__("名声"), person.fame, person.fame+fup, person.fullName);

    person.fame += fup;

    pp.mediator.uiUpdate();

    //'研究費授与
    var mup = 1000;
    mup = tm.imin(mup, pp.monMax - person.money);

    lastThemeDone = true;

    goto("GetMoney");

Rejected:
    //'*** 不受理
    sto.wuiShowMessage(
        __(str.s526, tmi.titleize(disc.name), society.name)
        //"論文『" + disc.name + "』は" + society.name + "に受理されませんでした。"
    );

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s527, tmi.titleize(disc.name), society.name)
        //"論文『" + disc.name + "』を" + society.name + "に提出しました。結果：不受理"
    );


    // 「落胆」になる
    person.discourageMonths = tm.irand(2, 4);
    sto.wuiShowMessage(
        __(str.s1010, person.fullName, __("落胆"))
        //person.fullName + "の状態が 落胆 になりました。"
    );
    pp.mediator.log("   >>" +
        __(str.s1010, person.name, __("落胆")),
        true);

    // 不受理フラグ(CPU用)
    report.rejected = true;

    if (person.isManual)
    {
        person.addDiary(
            __(str.s528, society.name, tmi.titleize(disc.name))
            //society.name + "に論文『" + disc.name + "』を提出、しかし受理されず。"
        );
    }

    var up = -Math.floor(disc.importance * (100 - backing) / 500);
    if (-up > person.fame)
        up = -person.fame;
    if (up < 0)
    {
        stol.wuiShowParamChange("Else1", __("名声"), person.fame, person.fame+up, person.fullName);
    }
Else1:
    pp.mediator.uiUpdate();

Exit:
    pp.mediator.toShowMessageTemporary = false;

    return;
};

//////////////////////////////////////////////////////////////////////

stoIsReportAccepted = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];
    var society = pp.world.societies[societyId];
    var person = pp.world.persons[report.personId];

    //---------- SCENE SOCIETY ----------
    sto.wuiSetFocusOnPlace(society.placeId);
    pp.mediator.setBgm(res.Mus_Society);
    sto.wuiPushScene(pp.ScnSociety, societyId, cc.TransitionFlipX, 3);
    sto.wuiShowCutS(res.Img_CutSociety);
    sto.wuiShowReportS(reportId);


    var ret = [ false, 100 ];

    switch (disc.type)
    {
        case pp.ttTheory:
            goto("Theory");
            break;

        case pp.ttFigure:
            goto("Figure");
            break;

        case pp.ttThing:
            goto("Thing");
            break;

        case pp.ttItem:
            goto("Item");
            break;

        case pp.ttBook:
            goto("Book");
            break;
    }

Theory:
    ret = sto.callStoryFunc(this.stoIsReportAcceptedTheory, reportId, societyId, forcedValues);
    goto("Exit");

Figure:
    ret = sto.callStoryFunc(this.stoIsReportAcceptedFigure, reportId, societyId, forcedValues);
    goto("Exit");

Thing:
    ret = sto.callStoryFunc(this.stoIsReportAcceptedThing, reportId, societyId, forcedValues);
    goto("Exit");

Item:
    ret = sto.callStoryFunc(this.stoIsReportAcceptedItem, reportId, societyId, forcedValues);
    goto("Exit");

Book:
    ret = sto.callStoryFunc(this.stoIsReportAcceptedBook, reportId, societyId, forcedValues);
    goto("Exit");

Exit:

    //---------- POP SCENE ----------
    sto.wuiPopScene(cc.TransitionFlipX, 3);
    sto.wuiSetFocusOnPlace(person.placeId);

    return ret;

};
