
stoIsReportAcceptedBook = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var im;
    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var personId = report.personId;
    var person = pp.world.persons[personId];
    var society = pp.world.societies[societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    var prevBgm;
    var accepted;
    var backing = 50;

    cr = report.credibility;
    im = disc.importance;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opA += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opB += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opC += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏

    if (personId == pp.mediator.personDId) {
        //'*** 自分の論文の場合
        mes =
            __(str.s805) +
            __(str.s806, society.name);
            //"本日は、先頃私の書き上げました書籍の原稿についてです。" +
            //"内容についてはすでにお話しました。" + society.name + "の出版物としてふさわしいのかどうか、判定をお願い致します。";
    }
    else {
        mes =
            __(str.s807, person.fullName, society.name);
            //"本日は、先頃" + person.fullName + "氏より送られて参りました書籍の原稿についてです。\n" +
            //"内容についてはすでにお話しました。" + society.name + "の出版物としてふさわしいのかどうか、判定をお願い致します。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s808, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'すでに同理論が協会に提出されていないか？
    var aReport;
    for (var i = 0; i < pp.world.reports.length; i++) {
        aReport = pp.world.reports[i];
        if (aReport.societyId == pp.idInvalid) continue;
        if (aReport.discoveryId != report.discoveryId) continue;
        goto("NotNew");
    }
    goto("New");

NotNew:
    //'*** すでにある発見であった
    var aPidx = personBId == aReport.personId ? pp.PIDX_JOB2 : pp.PIDX_JOB1;
    sto.wuiShowVoiceS(aPidx,
        __(str.s809, pp.world.persons[aReport.personId].lastName, tmi.titleize(disc.name)));
        //"ちょっと待ってください。この原稿が述べている内容は、" + pp.world.persons[aReport.personId].lastName +  "氏が『" + disc.name + "』として出版しているものではないですか？");
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s810));
        //"残念だがその通りだな。この原稿を出版することはできない。");
    backing = 100;
    accepted = false;
    goto("DeclinedNotNew");

New:
    //'Ｂ氏
    if (personId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s811, theme.name, society.name);
            //"この私の原稿は" + theme.name + "の研究成果です。是非" + society.name + "からの出版をお願いしたい。";
    }
    else
    {
        mes =
            __(str.s812);
            //"私はまだ初めの方しか読めていないのですが、素晴らしい内容でした。\n" +
            //"ただし非常に難解で・・・。\n" +
            //"果たしてこれを理解できる人間がどれだけいるかはわかりませんが、出版するべきです。";
    }

    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (personId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s811, theme.name, society.name);
            //"この私の原稿は" + theme.name + "の研究成果だ。是非" + society.name + "からの出版をお願いしたい。";
    }
    else
    {
        mes =
            __(str.s813, person.lastName);
            //"この本を書いた" + person.lastName + "氏という方は本当に我々と同じ人間なのだろうか？\n" +
            //"ここに書かれていることはまるで神のパズルを解き明かしていく過程のようで、神秘的ですらある。";
    }

    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (personId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 4;
        mes =
            __(str.s811, theme.name, society.name);
            //"この私の原稿は" + theme.name + "の研究成果です。是非" + society.name + "からの出版をお願いしたい。";
    }
    else
    {
        mes =
            __(str.s814, society.name);
            //"まさに彼にしか成しえない偉大な業績です。\n" +
            //"このような素晴らしい書籍を我らが" + society.name + "から出版できるとは、これほど誇らしいと感じたことはありません。";
    }

    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    //------------------------------

    //'受理
    mes =
        __(str.s815, disc.name, society.name);
        //"よろしい。どうやら全会一致のようだ。\n" +
        //"本書『" + disc.name + "』は" + society.name + "が責任を持って出版することにしよう。\n" +
        //"人々の驚きようが目に浮かぶな。";

    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    accepted = true;

    //'支持率決定
    backing = 100;

DeclinedNotNew:

    return [accepted, backing];
};
