
stoIsReportAcceptedFigure = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var im;
    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var personId = report.personId;
    var person = pp.world.persons[personId];
    var society = pp.world.societies[societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    var prevBgm;
    var accepted;
    var backing = 50;

    cr = report.credibility;
    im = disc.importance;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opA += cr >= 90 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opB += cr >= 90 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opC += cr >= 90 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏

    if (personId == pp.mediator.personDId) {
        //'*** 自分の論文の場合
        mes =
            __(str.s530) + __(str.s531, society.name);

            //"本日は私の研究の成果を見ていただきます。" + society.name +
            //"としてのこの論文の評価を決定していただきたいと思います。";
    }
    else {
        mes =
            __(str.s532, society.name, person.fullName) +
            __(str.s533, society.name);

            //society.name + "宛に" + person.fullName + "氏から論文が送られてまいりました。" +
            //society.name + "としてこの論文の評価を決定したいと思います。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s534, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'すでに同理論が協会に提出されていないか？
    /*
    var aReport;
    for (var i = 0; i < pp.world.reports.length; i++) {
        aReport = pp.world.reports[i];
        if (aReport.societyId == pp.idInvalid) continue;
        if (aReport.discoveryId != report.discoveryId) continue;
        goto("NotNew");
    }
    goto("New");

NotNew:
    //'*** すでにある発見であった
    var aPidx = personBId == aReport.personId ? pp.PIDX_JOB2 : pp.PIDX_JOB1;
    sto.wuiShowVoiceS(aPidx, "ちょっと待ってください。この論文が述べている発見は、" + pp.world.persons[aReport.personId].lastName +  "氏が『" + disc.name + "』と呼んでいるものですよ。");
    sto.wuiShowVoiceS(pp.PIDX_JOB0, "残念だがその通りだな。良く調べてから提出するよう" + person.lastName + "氏に伝えておくように。");
    backing = 100;
    accepted = false;
    goto("DeclinedNotNew");

New:
*/

    //'Ｂ氏
    if (personId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s537, theme.name, society.name);
            //"この私のスケッチは" + theme.name + "研究の重要な記録です。是非" + society.name + "のご評価をお願いしたい。";
        goto("SettledB");
    }

    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:

    switch (opB)
    {
        default:
        case 4:
            mes =
                __(str.s539, tmi.titleize(disc.name), society.name);
                //"すばらしい描写力ですね。『" + disc.name + "』』とは対象も興味深い。\n" +
                //society.name + "から高い評価を与えようではありませんか。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s541, tmi.titleize(disc.name));
                //"『" + disc.name + "』ですか。なかなか美しい描写と言えますね。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s542, personA.lastName);

                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;

        case 1:
            mes = __(str.s543, tmi.titleize(disc.name));
                //"うーん。『" + disc.name + "』ですか・・・。あまり意味のあるスケッチとは思えませんな。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                    __(str.s544, society.jobName0);
                    //society.jobName0 + "の意見はどうですか？";
            }
            break;

        case 0:
            mes = __(str.s545, tmi.titleize(disc.name));
                //"『" + disc.name + "』ですか。・・・子供の落書きですね。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR + __(str.s546, personA.lastName);
                    //personA.lastName + "さんの意見は？";
            }
            break;
    }

SettledB:
    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (personId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s547, theme.name, society.name);
            //"この私のスケッチは" + theme.name + "研究の重要な記録だ。我らが" + society.name + "としてのご評価をお願いする。";
        goto("SettledA");
    }

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:

    switch (opA)
    {
        default:
        case 4:
            mes =
                __(str.s549, person.lastName);
                //"これは素晴らしい。" + person.lastName + "氏のあふれんばかりの才能が伝わってきます。\n" +
                //"最高の評価と共に公表させていただきましょう。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s551);
                //"なるほど、このような形相をしているわけですね。緻密な描画に感心するばかりだ。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                        __(str.s552, personC.lastName);
                    //personC.lastName + "君はどう思うかね？";
            }
            break;

        case 1:
            mes =
                __(str.s553);
                //"これは本当にその物を見て描いたのだろうか・・・？\nあまり感じるものがありませんな。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                        __(str.s554, society.jobName2);
                    //society.jobName2 + "はどう思うかね？";
            }
            break;

        case 0:
            mes =
                __(str.s555);
                //"子供でももう少しまともな物を描いていますよ。\nとてもじゃないが、こんなものは受理できません。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (personId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 4;
        mes =
            __(str.s556, theme.name, society.name);
            //"この私のスケッチは" + theme.name + "研究の重要な成果です。是非我らが" + society.name + "からの評価をお願いしたいのですが。";
        goto("SettledC");
    }

    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        default:
        case 4:
            mes =
                __(str.s558);
                //"す、すごいです。\n本当に私達と同じ人間が描いた物なのでしょうか？言葉が見つかりません。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s559);
                //"このような肉眼ではなかなか見ることの出来ない世界を伝えてくれる彼の研究は賞賛に値すると思います。";
            break;

        case 1:
            mes =
                __(str.s560);
                //"私にはあまり出来の良い図とは思えません。このような物が研究と呼べるのかどうか疑問です。";
            break;

        case 0:
            mes =
                __(str.s561);
                //"私は無節操に描き殴った出来の悪い図を見せられて不快感すら覚えました。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    //------------------------------

    // 意見が割れてる？
    if (((opA > 1 && opB <= 1) || (opB > 1 && opA <=1) ||
        (opB > 1 && opC <= 1) || (opC > 1 && opB <=1) ||
        (opC > 1 && opA <= 1) || (opA > 1 && opC <=1)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s562, society.name));
        //"評価が定まらないな。では私が総合的に見て" + society.name + "としての見解をまとめよう。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:
    //'3人のﾎﾟｲﾝﾄが2以上なら受理
    if (opA + opB + opC >= 2)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s563));
        //"・・・それでは、この論文は受理することにしよう。");

AcceptedByA:
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s564, society.name));
        //"・・・・では、この論文は" + society.name + "には相応しくないとして不受理処分としてくれ。");

    accepted = false;

Exit:
    //'支持率決定
    backing = tm.imin(opA + opB + opC, 10) * 10;

DeclinedNotNew:

    return [accepted, backing];
};
