
stoIsReportAcceptedItem = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var im;
    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var personId = report.personId;
    var person = pp.world.persons[personId];
    var society = pp.world.societies[societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    var prevBgm;
    var accepted;
    var backing = 50;

    cr = report.credibility;
    im = disc.importance;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opA += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opB += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opC += im >= 60 ? 1 : im >= 30 ? 0 : im >= 20 ? -1 : -2;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏

    if (personId == pp.mediator.personDId) {
        //'*** 自分の論文の場合
        mes =
            __(str.s565, society.name);
            //"本日は私の研究の成果を見ていただきます。" + society.name +
            //"としてのこの発明の評価を決定していただきたいと思います。";
    }
    else {
        mes =
            __(str.s567, society.name, person.fullName) +
            __(str.s568, society.name);
            //society.name + "宛に" + person.fullName + "氏から論文が送られてまいりました。" +
            //society.name + "としてこの発明の評価を決定したいと思います。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s569, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'すでに同理論が協会に提出されていないか？
    var aReport;
    for (var i = 0; i < pp.world.reports.length; i++) {
        aReport = pp.world.reports[i];
        if (aReport.societyId == pp.idInvalid) continue;
        if (aReport.discoveryId != report.discoveryId) continue;
        goto("NotNew");
    }
    goto("New");

NotNew:
    //'*** すでにある発見であった
    var aPidx = personBId == aReport.personId ? pp.PIDX_JOB2 : pp.PIDX_JOB1;
    sto.wuiShowVoiceS(aPidx,
        __(str.s570, pp.world.persons[aReport.personId].lastName, disc.name)
        //"ちょっと待ってください。この論文が述べている発明は、" + pp.world.persons[aReport.personId].lastName +  "氏が『" + disc.name + "』として既に発表しているものですよ。"
    );
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s571));
        //"確かにその通りだな。慣習に習って先に発表されたものを有効としよう。\n残念だがこの論文は受理できない。");
    backing = 100;
    accepted = false;
    goto("DeclinedNotNew");

New:
    //'Ｂ氏
    if (personId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s572, theme.name, society.name);
            //"この私の発明は" + theme.name + "研究の輝かしい成果です。是非" + society.name + "のご推薦をお願いしたい。";
        goto("SettledB");
    }

    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:

    switch (opB)
    {
        default:
        case 4:
            mes =
                __(str.s574, disc.name, society.name);
                //"うーむ、『" + disc.name + "』とは素晴らしい発明だな。\n" + society.name + "から高い評価を与えましょう。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s575, disc.name);
                //"『" + disc.name + "』ですか。なかなか素晴らしい発明ですな。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR + __(str.s576, personA.lastName);
                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;

        case 1:
            mes =
                __(str.s577, disc.name);
                //"うーん。『" + disc.name + "』ですか・・・。あまり役に立つようには思えませんが。";
            mes = mes + CR + __(str.s578, society.jobName0);
                //society.jobName0 + "の意見はどうですか？";
            break;

        case 0:
            mes =
                __(str.s579, disc.name);
                //"まったくお粗末なガラクタだ。『" + disc.name + "』か。こんなものは誰でも作れるし、いちいち公表しないでしょう。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                    __(str.s580, personA.lastName);
                    //personA.lastName + "さんの意見は？";
            }
            break;
    }

SettledB:
        sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (personId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s581, theme.name, society.name);
            //"この私の発明は" + theme.name + "研究の輝かしい成果だ。我らが" + society.name + "のご推薦をお願いする。";
        goto("SettledA");
    }

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:

    switch (opA)
    {
        default:
        case 4:
            mes = __(str.s583, person.lastName);
                //"素晴らしい・・・。" + person.lastName + "氏がついにやってくれたと言うことだ。\n最高の評価を与えよう。";
            break;

        case 2:
        case 3:
            mes = __(str.s584);
                //"なかなか面白い発明品です。みごとな工夫の跡があちこちに見られますな。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                    __(str.s585, personC.lastName);
                    //personC.lastName + "君はどう思うかね？";
            }
            break;

        case 1:
            mes = __(str.s586);
                //"あまり良く出来た道具とは言いがたいな。";
            mes = mes + "\n" + __(str.s587, society.jobName2);
                //society.jobName2 + "はどう思うかね？";
            break;

        case 0:
            mes = __(str.s588); //"こんなものを発明と呼んでいたら私の研究は発明であふれかえってしまうよ・・・。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (personId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 4;
        mes = __(str.s589, theme.name, society.name);
            //"この私の発明は" + theme.name + "研究の成果です。是非我らが" + society.name + "のご推薦をお願いしたいのですが。";
        goto("SettledC");
    }

    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        default:
        case 4:
            mes = __(str.s591); //"人類の英知はここまで来たかと感激します。最高の評価とともに公表させていただきましょう。";
            break;

        case 2:
        case 3:
            mes = __(str.s592, society.name); //"なかなか素晴らしい発明品と言えます。\n" + society.name + "から高い評価を与えましょう。";
            break;

        case 1:
            mes = __(str.s593); //"一応、このような論文は今まで出ていないので受理しない理由はありませんが・・・。あまり誉められたものではありませんね。";
            break;

        case 0:
            mes = __(str.s594); //"いやはや、誰もやっていないからと言って発表すれば良いわけではないと言う良い例ですね。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    //------------------------------

    // 意見が割れてる？
    if (((opA > 1 && opB <= 1) || (opB > 1 && opA <=1) ||
        (opB > 1 && opC <= 1) || (opC > 1 && opB <=1) ||
        (opC > 1 && opA <= 1) || (opA > 1 && opC <=1)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s595, society.name));
        //"意見が分かれたな。\n" + society.name + "としての支持率は半分程度ということですかな。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:
    //'3人のﾎﾟｲﾝﾄが2以上なら受理
    if (opA + opB + opC >= 2)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s596));
        //"・・・この論文は受理することにしよう。いいですね？");

AcceptedByA:
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s597, society.name));
        //"・・・では、この論文は" + society.name + "には相応しくないとして不受理としてくれ。いいですね？");

    accepted = false;

Exit:
    //'支持率決定
    backing = tm.imin(opA + opB + opC, 10) * 10;

DeclinedNotNew:

    return [accepted, backing];
};
