
stoIsReportAcceptedTheory = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var personId = report.personId;
    var person = pp.world.persons[personId];
    var society = pp.world.societies[societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    var prevBgm;
    var accepted;
    var backing = 50;

    cr = report.credibility;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opA += cr >= 90 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opB += cr >= 90 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opC += cr >= 90 ? 2 : cr >= 80 ? 1 : cr >= 70 ? 0 : cr >= 50 ? -1 : -2;
    if (pp.world.tutorialStage != pp.tuOff) opC += 2; //ニュートン・フック補正
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏

    if (personId == pp.mediator.personDId) {
        //'*** 自分の論文の場合
        mes =
            __(str.s530) +
            __(str.s531, society.name);
            //"本日は私の研究の成果を見ていただきます。" + society.name +
            //"としてのこの論文の評価を決定していただきたいと思います。";
    }
    else {
        mes =
            __(str.s532, society.name, person.fullName) +
            __(str.s533, society.name);
            //society.name + "宛に" + person.fullName + "氏から論文が送られてまいりました。" +
            //society.name + "としてこの論文を受理するか否かの判定を行いたいと思います。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s602, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'すでに同理論が協会に提出されていないか？
    var aReport;
    for (var i = 0; i < pp.world.reports.length; i++) {
        aReport = pp.world.reports[i];
        if (aReport.societyId == pp.idInvalid) continue;
        if (aReport.discoveryId != report.discoveryId) continue;
        goto("NotNew");
    }
    goto("New");
    
NotNew:
    //'*** すでにある発見であった
    var aPidx = personBId == aReport.personId ? pp.PIDX_JOB2 : pp.PIDX_JOB1;
    sto.wuiShowVoiceS(aPidx,
        __(str.s603, pp.world.persons[aReport.personId].lastName, tmi.titleize(disc.name))
        //"ちょっと待ってください。この論文の内容は、" + pp.world.persons[aReport.personId].lastName +  "氏の『" + disc.name + "』と同じことを述べているに過ぎないのではないですか？"
    );
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s604)
        //"確かにその通りだな。\nそれではこの論文は不受理とせざるを得ない。"
    );
    backing = 100;
    accepted = false;
    goto("DeclinedNotNew");

New:
    //'Ｂ氏
    if (personId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s605, theme.name, society.name);
            //"この私の論文は" + theme.name + "研究の輝かしい成果です。是非" + society.name + "からの公開をお願いしたい。";
        goto("SettledB");
    }

    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:

    switch (opB)
    {
        default:
        case 4:
            mes =
                __(str.s607, disc.name);
                //"どれどれ・・・。『" + disc.name + "』とは見事な観点だ。取り急ぎ公開の準備をしようではありませんか。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s608, tmi.titleize(disc.name));
                //"『" + disc.name + "』ですか。なるほど、面白い論文ですな。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s609, personA.lastName);
                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;

        case 1:
            mes =
                __(str.s610, tmi.titleize(disc.name));
                //"うーん。『" + disc.name + "』ですか・・・。少々信憑性に欠けるように思えますな。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s611, society.jobName0);
                    //society.jobName0 + "の意見はどうですか？";
            }
            break;

        case 0:
            mes = __(str.s612, tmi.titleize(disc.name));
                //"ふん。またろくでも無い論文に違いない。『" + disc.name + "』か。私は反対だ。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s613, personA.lastName);
                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;
    }

SettledB:
    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (personId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s614, theme.name, society.name);
            //"この私の論文は" + theme.name + "研究の成果だ。我らが" + society.name + "からの公開が妥当と考えている。";
        if (personCId != pp.prJob2DefaultPersonId) {
            mes = mes + CR +
                __(str.s615, personC.lastName);
            //personC.lastName + "君はどう思うかね？";
        }
        goto("SettledA");
    }

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:

    switch (opA)
    {
        default:
        case 4:
            mes =
                __(str.s617, person.lastName);
                //"す、すごい・・・。" + person.lastName + "氏はすばらしい洞察力をお持ちだ。\nこれでは議論の余地はありませんね。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s618);
                //"そうだな、私は良いと思う。それなりに信憑性もある。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + CR +
                        __(str.s619, personC.lastName);
                    //personC.lastName + "君はどう思うかね？";
            }
            break;

        case 1:
            mes =
                __(str.s620);
                //"あまり良く出来た理論とは言いがたいな。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + CR +
                    __(str.s621, society.jobName2);
                    //society.jobName2 + "はどう思うかね？";
            }
            break;

        case 0:
            mes =
                __(str.s622);
                //"くだらない論文だ。真剣に読んだのは時間の無駄であった。こんなものは受理できない。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (personId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 4;
        mes =
            __(str.s623, theme.name, society.name);
            //"この私の論文は" + theme.name + "研究の成果です。是非我が" + society.name + "からの公開をお願いしたいのですが。";
        goto("SettledC");
    }

    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        default:
        case 4:
            mes =
                __(str.s625);
                //"もちろん私は大賛成です。この理論は是非世に出すべきです。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s626);
                //"いいですね。私は賛成です。特に問題なども見受けられません。";
            break;

        case 1:
            mes =
                __(str.s627);
                //"あまり優れた理論とは思えません。個人的には受理すべきではないと思っています。";
            break;

        case 0:
            mes =
                __(str.s628, person.lastName);
                //"ひどい論文です。" + person.lastName + "氏の頭の程度が知れるというものです。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    // 意見が割れてる？
    if (((opA > 1 && opB <= 1) || (opB > 1 && opA <=1) ||
        (opB > 1 && opC <= 1) || (opC > 1 && opB <=1) ||
        (opC > 1 && opA <= 1) || (opA > 1 && opC <=1)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s629, society.name));
        //"意見が分かれたな。しかし" + society.name + "としての統一見解をまとめねば・・・。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:
    //'3人のﾎﾟｲﾝﾄが5以上なら受理
    if (opA + opB + opC >= 5)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s630)
        //"・・・・・・・それでは、この論文は受理することにしよう。"
    );

    sto.callTutorialFunc(this.stoTutSubmitReport3);

AcceptedByA:
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s631, society.name)
        //"・・・・・・・では、この論文は" + society.name + "には相応しくないとして不受理としてくれ"
    );

    accepted = false;

Exit:
    //'支持率決定
    backing = tm.imin(opA + opB + opC, 10) * 10;

DeclinedNotNew:

    return [accepted, backing];
};
