
stoIsReportAcceptedThing = function(reportId, societyId, forcedValues) {

    var isCheckingText = !cc.isUndefined(forcedValues);

    var im;
    var cr;
    var fr;
    var personA;
    var personB;
    var personC;
    var opA;
    var opB;
    var opC;
    var mes;
    var report = pp.world.reports[reportId];
    var personId = report.personId;
    var person = pp.world.persons[personId];
    var society = pp.world.societies[societyId];
    var disc = pp.world.discoveries[report.discoveryId];
    var theme = pp.world.themes[disc.themeId];

    var prevBgm;
    var accepted;
    var backing = 50;

    cr = report.credibility;
    im = disc.importance;

    //'審査委員を協会のトップ３にする
    var personAId = society.job0PersonId;
    var personBId = society.job1PersonId;
    var personCId = society.job2PersonId;
    if (personAId == pp.idInvalid) personAId = pp.prJob0DefaultPersonId;
    if (personBId == pp.idInvalid) personBId = pp.prJob1DefaultPersonId;
    if (personCId == pp.idInvalid) personCId = pp.prJob2DefaultPersonId;
    personA = pp.world.persons[personAId];
    personB = pp.world.persons[personBId];
    personC = pp.world.persons[personCId];

    //'******************************************************** 3人で審査
    //'Ａ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personAId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opA = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opA += im >= 60 ? 1 : im >= 30 ? 0 : -1;
    opA = tm.imax(0, opA);
    if (isCheckingText) opA = forcedValues[0];

    //'Ｂ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personBId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opB = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opB += im >= 60 ? 1 : im >= 30 ? 0 : -1;
    opB = tm.imax(0, opB);
    if (isCheckingText) opB = forcedValues[1];

    //'Ｃ氏推薦値ｾｯﾄ
    fr = person.friendlinesses[personCId];
    //'友好度と完成度で決定(友好度重視、完成度50は無いと減点)
    opC = fr >= 70 ? 3 : fr >= 50 ? 2 : fr >= 40 ? 1 : 0;
    opC += im >= 60 ? 1 : im >= 30 ? 0 : -1;
    opC = tm.imax(0, opC);
    if (isCheckingText) opC = forcedValues[2];

    //'*** 審査開始
    //'Ｃ氏

    if (personId == pp.mediator.personDId) {
        //'*** 自分の論文の場合
        mes =
            __(str.s632, society.name);
            //"本日は私の研究の成果を見ていただきます。" + society.name +
            //"としてのこの論文の評価を決定していただきたいと思います。";
    }
    else {
        mes =
            __(str.s634, society.name, person.fullName) +
            __(str.s635, society.name);
            //society.name + "宛に" + person.fullName + "氏から論文が送られてまいりました。" +
            //society.name + "としてこの発明の評価を決定したいと思います。";
    }

    sto.wuiShowVoiceS(pp.PIDX_PERSON_D, mes);
    sto.wuiShowVoiceS(pp.PIDX_PERSON_D,
        __(str.s636, society.jobName1),
        //society.jobName1 + "はどのようなご意見ですか？",
        true);

    //'すでに同理論が協会に提出されていないか？
    var aReport;
    for (var i = 0; i < pp.world.reports.length; i++) {
        aReport = pp.world.reports[i];
        if (aReport.societyId == pp.idInvalid) continue;
        if (aReport.discoveryId != report.discoveryId) continue;
        goto("NotNew");
    }
    goto("New");

NotNew:
    //'*** すでにある発見であった
    var aPidx = personBId == aReport.personId ? pp.PIDX_JOB2 : pp.PIDX_JOB1;
    sto.wuiShowVoiceS(aPidx,
        __(str.s637, pp.world.persons[aReport.personId].lastName, tmi.titleize(disc.name)));
        //"ちょっと待ってください。この論文が述べている発見は、" + pp.world.persons[aReport.personId].lastName +  "氏が『" + disc.name + "』と呼んでいるものですよ。");
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s638, person.lastName));
        //"残念だがその通りだな。良く調べてから提出するよう" + person.lastName + "氏に伝えておくように。");
    backing = 100;
    accepted = false;
    goto("DeclinedNotNew");

New:
    //'Ｂ氏
    if (personId == personBId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opB = 4;
        mes =
            __(str.s639, theme.name, society.name);
            //"この私の発見は" + theme.name + "研究の輝かしい成果です。是非" + society.name + "のご推薦をお願いしたい。";
        goto("SettledB");
    }

    //'*** B氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personB.isManual == false)
        goto("SetVoiceB");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opB = 4; break;
        case 1: opB = 2; break;
        case 2: opB = 1; break;
        case 3: opB = 0; break;
    }

SetVoiceB:

    switch (opB)
    {
        default:
        case 4:
            mes =
                __(str.s641, disc.name);
                //"なんと！これぞ人類の英知の輝かしい成果ですね。『" + disc.name + "』とは素晴らしい大発見です。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s642, tmi.titleize(disc.name));
                //"『" + disc.name + "』とは、これは大発見ですな。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                        __(str.s643, personA.lastName);
                    //personA.lastName + "さんの意見はどうですか？";
            }
            break;

        case 1:
            mes =
                __(str.s644, tmi.titleize(disc.name));
                //"うーん。『" + disc.name + "』ですか・・・。あまり意味のある発見とは思えませんな。";
            mes = mes + CR +
                __(str.s645, society.jobName0);
                //society.jobName0 + "の意見はどうですか？";
            break;

        case 0:
            mes =
                __(str.s646, tmi.titleize(disc.name));
                //"またくだらない論文に違いない。『" + disc.name + "』か。こんなものは誰でも気が付いているが、いちいち公表しないだけだ。";
            if (personAId != pp.prJob0DefaultPersonId) {
                mes = mes + CR +
                    __(str.s647, personA.lastName);
                    //personA.lastName + "さんの意見は？";
            }
            break;
    }

SettledB:
    sto.wuiShowVoiceS(pp.PIDX_JOB1, mes);

    //------------------------------

    //'Ａ氏
    if (personId == personAId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opA = 4;
        mes =
            __(str.s648, theme.name, society.name);
            //"この私の発見は" + theme.name + "研究の輝かしい成果だ。我らが" + society.name + "のご推薦をお願いする。";
        goto("SettledA");
    }

    //'*** A氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personA.isManual == false)
        goto("SetVoiceA");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opA = 4; break;
        case 1: opA = 2; break;
        case 2: opA = 1; break;
        case 3: opA = 0; break;
    }

SetVoiceA:

    switch (opA)
    {
        default:
        case 4:
            mes =
                __(str.s650, society);
                //"これは素晴らしい。このような大発見を我が" + society.name + "に提出してくれたことを感謝せずにはいられませんね。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s651, person.lastName);
                //"なるほど、これは大発見ですね。流石は" + person.lastName + "氏と言ったところかな。";
            if (personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                    __(str.s652, personC.lastName);
                    //personC.lastName + "君はどう思うかね？";
            }
            break;

        case 1:
            mes =
                __(str.s653);
                //"たしかに発見と言えるかもしれないが、それほど重要なものではないでしょう。";
            if (true || personCId != pp.prJob2DefaultPersonId) {
                mes = mes + "\n" +
                    __(str.s654, society.jobName2);
                    //society.jobName2 + "はどう思うかね？";
            }
            break;

        case 0:
            mes =
                __(str.s655);
                //"どうせいつもの程度の低い論文だろう。\n・・・やはりな。こんな事が続くなら考えないといけないようだ。";
            break;
    }

SettledA:
    sto.wuiShowVoiceS(pp.PIDX_JOB0, mes);

    //------------------------------

    //'Ｃ氏
    if (personId == personCId)
    {
        //'*** 自分の論文なら特別なｾﾘﾌ
        opC = 4;
        mes =
            __(str.s656, theme.name, society.name);
            //"この私の発見は" + theme.name + "研究の成果です。是非我らが" + society.name + "のご推薦をお願いしたいのですが。";
        goto("SettledC");
    }

    //'*** C氏がﾌﾟﾚｲﾔｰなら審査し直し
    if (personC.isManual == false)
        goto("SetVoiceC");

    var sel = sto.wuiSelectOptions([__("大賛成"), __("賛成"), __("反対"), __("大反対")], __("意見"));
    switch (sel)
    {
        case 0: opC = 4; break;
        case 1: opC = 2; break;
        case 2: opC = 1; break;
        case 3: opC = 0; break;
    }

SetVoiceC:

    switch (opC)
    {
        default:
        case 4:
            mes =
                __(str.s658);
                //"こ、これは極めて偉大な発見でしょう。\nこの論文が世に出た時の人々の驚きようが目に浮かぶようです。";
            break;

        case 2:
        case 3:
            mes =
                __(str.s659);
                //"こんなものが存在していたとは驚きましたね。\n実に見事な発見です。";
            break;

        case 1:
            mes =
                __(str.s660);
                //"・・・それほど意味がある発見とは思えませが、彼なりに良くやったのではないでしょうか。";
            break;

        case 0:
            mes =
                __(str.s661);
                //"ひどい論文です。彼のような人物が研究者を気取っているのは許せません。";
            break;
    }

SettledC:
    sto.wuiShowVoiceS(pp.PIDX_JOB2, mes);

    //------------------------------

    // 意見が割れてる？
    if (((opA > 0 && opB <= 0) || (opB > 0 && opA <= 0) ||
        (opB > 0 && opC <= 0) || (opC > 0 && opB <= 0) ||
        (opC > 0 && opA <= 0) || (opA > 0 && opC <= 0)) == false)
    {
        goto("NoConflict");
    }
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s662, society.name));
        //"評価が定まらないな。では私が総合的に見て" + society.name + "としての見解をまとめよう。");

    sto.wuiShowVoiceS(pp.PIDX_JOB0, __("・・・・・・。", "......"), true);

NoConflict:
    //'3人のﾎﾟｲﾝﾄが2以上なら受理
    if (opA + opB + opC >= 2)
        goto("Accepted");

    goto("Declined");

Accepted:
    //'受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s663));
        //"・・・この論文は受理することにする。よろしいな？");

AcceptedByA:
    accepted = true;
    goto("Exit");

Declined:
    //'不受理
    sto.wuiShowVoiceS(pp.PIDX_JOB0,
        __(str.s664));
        //"・・・この論文は" + society.name + "には相応しくないので不受理処分とする。");

    accepted = false;

Exit:
    //'支持率決定
    backing = tm.imin(opA + opB + opC, 10) * 10;

DeclinedNotNew:

    return [accepted, backing];
};
