
stoComTheory = function (preSelectedDiscId) {

    var done = false;

    var disc;
    var discId;

    if (pp.isIdValid(preSelectedDiscId)) {
        discId = preSelectedDiscId;
        goto("DidSelectDisc");
    }

    if (pp.mediator.person.getDiscoveriesWithType(pp.ttTheory).length > 0) {
        goto("SelTheory");
    }

    sto.wuiShowMessage(__(str.s671), __("理論検証"));
        //"選択可能な理論がありません。", "理論検証");
    goto("Exit");

SelTheory:
    if (pp.isIdValid(preSelectedDiscId)) {
        goto("Exit");
    }

    discId = sto.wuiSelectDiscovery([pp.fdPerson, pp.mediator.personId, pp.fdType, pp.ttTheory]);

    if (discId == pp.selCancel)
        goto("Exit");

DidSelectDisc:
    if (!pp.mediator.isCheckingText)
        goto("NotCheckingText");

    sto.callStoryFunc(this.stoCheck_ComTheory, discId);
    goto("Exit");

NotCheckingText:
    disc = pp.world.discoveries[discId];

    var okCancel = sto.wuiSelectOkCancel(
        __(str.s672, disc.name)
        //"理論『" + disc.name + "』の検証を行います。" + CR +
        //"よろしいですか？"
    );

    if (okCancel == pp.selCancel)
        goto("SelTheory");

    sto.callStoryFunc(this.stoExeVerifyTheory, disc.id);
    done = true;

Exit:
    return done;
};

stoExeVerifyTheory = function (discId, forcedVoiceIdx) {

    sto.callStoryFunc(this.stoBeforeExeCommand);

    var isCheckingText = !cc.isUndefined(forcedVoiceIdx);
    var voiceIdx;

    var person = pp.mediator.person;
    var disc = pp.world.discoveries[discId];
    var theme = pp.world.themes[disc.themeId];
    var fieldp = person.fieldPs[theme.fieldId];

    //--- シーン変更
    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    var mes0 = __(str.s673, disc.name);
        //disc.name + "はずだ。これがこうなれば・・・。";

    var p0;
    var p1;
    var up;

    //上昇値計算
    up = 15 + (fieldp.knowledge / 20) + tm.irand(-3, 3);
    up = tm.imax(up, 1);

    if (person.isManual) up *= Math.pow(10, tmd.researchBoost);
    if (pp.world.tutorialStage != pp.tuOff) up = 100;

    p0 = person.discCredibilities[discId];
    if (p0 + up > disc.credibility)
        up = disc.credibility - p0;
    p1 = p0 + up;
    person.discCredibilities[discId] = p1;

    pp.mediator.uiUpdate();

    var mes1;
    var voices = [
        __(str.s674), __(str.s675), __(str.s676),
        __(str.s677), __(str.s678), __(str.s679), __(str.s680)
    ];
    if (isCheckingText) {
        voiceIdx = forcedVoiceIdx;
    }
    else {
        if (up == 0) {
            voiceIdx = p1 < 20 ? 0 : p1 < 40 ? 1 : 2;

            //  p1 < 20 ? "困ったな。期待していたような結果が得られない・・・。" :
            //  p1 < 40 ? "この結果ではあまり思わしくないな。・・・・おかしい。" :
            //            "これ以上個人での検証は無理のようだ。論文を発表し、世に意見を問うか。";
        }
        else {
            voiceIdx = p1 < 20 ? 3 : p1 < 40 ? 4 : p1 < 60 ? 5 : 6;

            //p1 < 20 ? "とりあえずは間違っていないようだが、さらに詳しい検証が必要だな。" :
            //p1 < 40 ? "よし、いいぞ。この調子で検証を続けよう。" :
            //p1 < 60 ? "ほぼ間違い無い。先を越される前に発表するか・・・？" :
            //          "やはり私の理論の通りと言えそうだ。この事実は論文にして公表すべきだ。";
        }
    }
    mes1 = voices[voiceIdx];

    sto.wuiShowVoice(
        person.id,
        res.Img_CutStudy,
        [ mes0, mes1],
        __("理論検証"),
        true);

    if (isCheckingText)
        goto("Exit");

    //'ﾊﾟﾗﾒｰﾀ変化ﾒｯｾｰｼﾞ表示
    sto.wuiShowParamChange(__("完成度"), p0, p1, __("『" + tmi.titleize(disc.name) + "』", "'" + disc.name +"'"), true);

    sto.callTutorialFunc(this.stoTutTheory3);

    sleep(0.2);

    pp.mediator.uiClearOverlappedPopups();

    // Log
    pp.mediator.logPersonCommand(person.id,
        __(str.s683, disc.name)
        //"『" + disc.name + "』の理論検証をしています。"
    );

Exit:
    pp.mediator.uiClearOverlappedPopups();

    //--- シーン復帰
    sto.wuiPopScene(cc.TransitionFade, 2);
};
