
pp.csNone = 0;
pp.csPrepForResearch = 1;
pp.csPrepForTrial = 2;
pp.csPrepForFigure = 3;
pp.csPrepForTheme = 4;

stoCpuCommand = function () {

    //cc.log("stoCpuCommand called.");

    var person = pp.mediator.person;

    if ((tmd.toShowCpuTurn == pp.ctCheckAll || person.id == pp.world.interestedPersonId) && !pp.mediator.uiIsShownPersonWindow())
        pp.mediator.uiShowPersonWindow(true);

    if (person.cpuLevel == 0 || tmd.cpuBaseLevel == 0 || pp.world.tutorialStage != pp.tuOff || pp.mediator.isCheckingText)
        goto("DoNothing");

Normal:
    sto.callStoryFunc(this.stoCpuNormal);
    goto("Exit");

DoNothing:
    sto.callStoryFunc(this.stoExeRestMonth);
    goto("Exit");

Exit:
    if (person.id == pp.world.interestedPersonId && pp.mediator.uiIsShownPersonWindow())
        pp.mediator.uiHidePersonWindow(true);

    pp.mediator.uiBlinkPerson(pp.ID_INVALID);
};


stoCpuNormal = function () {

    var smartRate = 0.0;
    var person = pp.mediator.person;

    switch (person.cpuLevel + tmd.cpuBaseLevel) {
        case 2:
            smartRate = 0.2;
            break;
        case 3:
            smartRate = 0.5;
            break;
        case 4:
            smartRate = 0.8;
            break;
        case 5:
            smartRate = 0.9;
            break;
    }

    if (person.isGutless() || person.isDiscouraged())
        goto("Letter");

    if (smartRate < Math.random())
        goto("Letter");

Research:
    sto.callStoryFunc(this.stoCpuResearchS);
    goto("Exit");

Letter:
    sto.callStoryFunc(this.stoCpuLetterS);
    goto("Exit");

Exit:
    return;
};


/*
stoCpuNormal = function () {

    var feel = tm.irand(5);

    if (feel == 4)
        goto("Letter");

Research:
    sto.callStoryFunc(this.stoCpuResearch);
    goto("Exit");

Letter:
    sto.callStoryFunc(this.stoCpuLetter);
    goto("Exit");

Exit:
    return;
};
*/


stoCpuResearchS = function () {

    //cc.log("stoCpuResearchS called.");

    var person = pp.mediator.person;

    person.getPreferredThemes()[0].getReleasedReports(); //@@@

    var themep;
    var fieldId;
    var reportId;
    var discId;
    var themePIdx;
    var societyId;
    var toPersonId;
    var themeId;
    var itemId;
    var placeId;

    //*** 入会できそうか
    if (person.societyId == pp.idInvalid && person.fame >= pp.famJoinSociety) {
        var society = person.getPreferredSociety();
        var toPlace = pp.world.places[society.placeId];

        if (toPlace.id != person.placeId) {
            // 組織の場所へ移動
            var cost = toPlace.getCostToPlace(person.placeId);
            if (person.money >= cost) {
                placeId = toPlace.id;
                goto("Move");
            }
        }
        else {
            // 入会希望
            societyId = society.id;
            goto("JoinSociety");
        }
    }

    //'*** 提出可能な論文があるか
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];

        if (report.societyId != pp.idInvalid) continue;
        if (report.rejected) continue;

        //'他の人物が提出していないか？
        var isNew = true;
        for (var j = 0; j < pp.world.reports.length; j++) {
            var report2 = pp.world.reports[j];

            if (report.discoveryId == report2.discoveryId &&
                report2.societyId != pp.idInvalid) {
                isNew = false;
                break;
            }
        }
        if (!isNew) continue;

        //見込みがなかったらマーク
        if (report.discovery.type == pp.ttTheory && report.credibility < 70) {
            report.rejected = true;
            continue;
        }

        //提出先の役員との友好度が30以上50未満だったら資金援助
        var society = person.getPreferredSociety();
        if (person.money >= pp.monDonate) {
            var jobPersons = society.getJobPersons();
            for (var i = 0; i < jobPersons.length; i++) {
                var jobPerson = jobPersons[i];
                if (!jobPerson) continue;
                if (jobPerson.id == person.id) continue;

                var fr = jobPerson.friendlinesses[person.id];
                if (fr >= 30 && fr < 50) {
                    toPersonId = jobPerson.id;
                    goto("Donate");
                }
            }
        }

        // 提出
        reportId = report.id;
        societyId = society.id;
        goto("SubmitReport");
    }

    //*** 処理可能な発見があるか
    for (var i = 0; i < pp.world.discoveries.length; i++) {
        discId = i;
        var disc = pp.world.discoveries[i];

        if (person.discCredibilities[i] < 0) continue;
        var report = person.getReportForDisc(i);
        if (report) continue;

        //'*** できることがあるかどうか調べつつ、やっちゃう
        //'*** 理論検証、試作、図

        if (disc.type == pp.ttTheory) {
            if (person.discCredibilities[disc.id] < disc.credibility) {
                //'検証の余地があった、やる(理論検証)
                goto("VerifyTheory");
            }
        }
        else if (disc.type == pp.ttItem) {
            if (person.discCredibilities[disc.id] == pp.crPreMake) {
                //技術は十分か
                if (person.fieldPs[pp.fdEngineering].experience >= disc.engineering) {
                    //試作
                    goto("MakeTrial");
                }
                else {
                    //訓練
                    fieldId = pp.fdEngineering;
                    goto("Train");
                }
            }
        }
        else if (disc.type == pp.ttFigure) {

            if (person.discCredibilities[disc.id] == pp.crPreMake) {
                //技術は十分か
                if (person.fieldPs[pp.fdDrawing].experience >= disc.engineering) {
                    //'描く(図)
                    goto("DrawFigure");
                }
                else {
                    //訓練
                    fieldId = pp.fdDrawing;
                    goto("Train");
                }
            }
        }

        //*** できることがないので、あとは論文を書くだけのはず!
        goto("WriteReport");
    }

DoResearchIfPossible:
    //'*** 研究の余地のあるテーマは選ばれているか
    for (var io = 0; io < person.themePs.length; io++) {

        var i = (pp.world.month + io) % person.themePs.length; // shuffle by month :)

        var themep = person.themePs[i];
        if (themep.themeId == pp.idInvalid) continue;

        var theme = pp.world.themes[themep.themeId];
        var isDeducable = pp.world.fields[theme.fieldId].isDeducable && theme.getMaxDeduce() > themep.deduce;
        var isDatable = theme.getMaxData() > themep.data;

        themePIdx = i;

        // 半分自分が発見してたら研究打ち切る（権威ねらい）
        if (person.getDiscoveryCountWithThemeId(theme.id) > theme.getDiscoveries().length / 2) {
            goto("UnselectTheme");
        }

        if (isDeducable) {
            if (isDatable) {
                // 双方の余地あり
                if (tm.irand(2)) {
                    goto("PreResearchDeduce");
                }
                else {
                    goto("PreResearchData");
                }
            }
            else {
                // 推理の余地あり
                goto("PreResearchDeduce");
            }
        }
        else {
            if (isDatable) {
                // 実験の余地あり
                goto("PreResearchData");
            }
            else {
                // 研究の余地なし。選択解除
                goto("UnselectTheme");
            }
        }
    }

    //*** 研究の余地のあるテーマない。選択

    //最終テーマ選べるならそれ
    if (person.isFinalThemeUnlocked() && person.getDiscoveryCountWithThemeId(pp.tiFinal) == 0) {
        themeId = pp.tiFinal;
        themePIdx = 0;
        goto("SelectTheme");
    }

    var preferredThemes = person.getPreferredThemes();
    for (var i = 0; i < person.themePs.length; i++) {
        var themep = person.themePs[i];
        if (themep.themeId != pp.idInvalid) continue;

        // 1周目
        for (var j = 0; j < preferredThemes.length; j++) {
            var theme = preferredThemes[j];

            // 自分が１つでも発見していたらそのテーマは飛ばす
            if (person.getDiscoveryCountWithThemeId(theme.id) > 0)
                continue;

            // 他の科学者が３つ論文を出していたらそのテーマは飛ばす
            if (theme.getReleasedReports().length > 2)
                continue;

            // 知識が足りていなければ学習へ
            var fieldp = person.fieldPs[theme.fieldId];
            if (fieldp.knowledge < theme.knowledge) {
                fieldId = theme.fieldId;
                goto("Study");
            }

            // 選択実行
            themeId = theme.id;
            themePIdx = i;
            goto("SelectTheme");
        }

        cc.log("2nd round...");

        // 2周目
        for (var j = 0; j < preferredThemes.length; j++) {
            var theme = preferredThemes[j];

            // １つも発見が残っていなければそのテーマは飛ばす
            if (person.getDiscoveryCountWithThemeId(theme.id)
                == theme.getDiscoveries().length)
                continue;

            // 選択実行
            themeId = theme.id;
            themePIdx = i;
            goto("SelectTheme");
        }
    }

CpuDone:
    return;

CpuWait:
    return;

SelectTheme:
    sto.callStoryFunc(this.stoExeSelectTheme, themePIdx, themeId);
    goto("DoResearchIfPossible");

UnselectTheme:
    sto.callStoryFunc(this.stoExeUnselectTheme, themePIdx);
    goto("DoResearchIfPossible");

PreResearchData:
    // 器具がなければ購入 (最終テーマを除く)
    var themep = person.themePs[themePIdx];
    var theme = pp.world.themes[themep.themeId];

    var items = person.getItems(theme.fieldId);
    if (items.length == 0 && theme.fieldId != pp.fdImportant) {
        if (person.money >= 400) {
            itemId = pp.basicItemIds[theme.fieldId];
            goto("BuyAndData");
        }
        else {
            // これでは実験できない。
            goto("CpuWait");
        }
    }

DidBuy:
    // 器具を装備
    items = person.getItems(theme.fieldId, true);
    for (var i = 0; i < tm.imin(items.length, pp.maxNumItemsInThemeP); i++) {
        person.themePs[themePIdx].itemIds[i] = items[i].id;
    }

    // 熟練が低ければ訓練？
    // TBD

    // 実験実行
    goto("ResearchData");


PreResearchDeduce:
    // 知識が低ければ学習？
    // TBD

    // 推理実行
    goto("ResearchDeduce");

Study:
    // 資金があり、大学があれば講義受講
    if (person.money >= pp.monLecture && person.getUniversityId() != pp.idInvalid) {
        goto("Lecture");
    }
    goto("ReadBook");

VerifyTheory:
    //cc.log("stoExeVerifyTheory, " + disc.id);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId);
    goto("CpuDone");

MakeTrial:
    //cc.log("stoExeMakeTrial, " + disc.id);
    sto.callStoryFunc(this.stoExeMakeTrial, discId);
    goto("CpuDone");

DrawFigure:
    //cc.log("stoExeDrawFigure, " + disc.id);
    sto.callStoryFunc(this.stoExeDrawFigure, discId);
    goto("CpuDone");

WriteReport:
    //cc.log("stoExeMakeReport, " + disc.id);
    sto.callStoryFunc(this.stoExeWriteReport, discId);
    goto("CpuDone");

SubmitReport:
    //cc.log("stoExeSubmitReport, " + report.id);
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, societyId);
    goto("CpuDone");

Lecture:
    sto.callStoryFunc(this.stoExeLecture, fieldId);
    goto("CpuDone");


ReadBook:
    sto.callStoryFunc(this.stoExeReadBook, fieldId);
    goto("CpuDone");

Train:
    sto.callStoryFunc(this.stoExeTrain, fieldId);
    goto("CpuDone");

ResearchData:
    //cc.log("stoExeResearchData, " + tIdx);
    sto.callStoryFunc(this.stoExeResearchData, themePIdx);
    goto("CpuDone");

ResearchDeduce:
    //cc.log("stoExeResearchDeduce, " + tIdx);
    sto.callStoryFunc(this.stoExeResearchDeduce, themePIdx);
    goto("CpuDone");

RestMonth:
    //cc.log("stoExeRestMonth");
    sto.callStoryFunc(this.stoExeRestMonth);
    goto("CpuDone");





Donate:
    sto.callStoryFunc(this.stoExeDonate, toPersonId);
    goto("CpuDone");

Move:
    sto.callStoryFunc(this.stoExeMove, placeId);
    goto("CpuDone");

JoinSociety:
    sto.callStoryFunc(this.stoExeJoinSociety, societyId);
    goto("CpuDone");



BuyAndData:
    sto.callStoryFunc(this.stoExeBuy, itemId);
    items = person.getItems(theme.fieldId);
    goto("DidBuy");


};



// stoCpuLetterS
// CPUがよけいなことをする
stoCpuLetterS = function () {

    //cc.log("stoCpuDoSomething called.");

    var person = pp.mediator.person;
    var occup;


    if (tm.irand(4) == 0) {
        // 買い物してみる
        var itemId = tm.irand(pp.world.items.length);
        var item = pp.world.items[itemId];
        //'目をつけたｱｲﾃﾑの値段が所持金の半分以下なら買う
        if (item.isActive && item.price <= person.money / 2 && person.itemNums[item.id] == 0) {
            // 買っちゃう
            stol.callStoryFunc("EndIf", this.stoExeBuy, itemId);
        }
    }

EndIf:

    //-----

    // 所在地に交流できる人物がいたらする？
    // 近くなら移動もあり
    if (tm.irand(9) == 0 || tm.irand(9) == 0) {

        var persons = pp.world.getActivePersons();
        for (var i = 0; i < persons.length; i++) {
            var toPerson = persons[i];

            // 名声値が対象より300以上少なかったらあきらめる
            if (toPerson.fame > person.fame + pp.commuMinFameDiff) continue;

            // 友好度60未満 or 80以上ならやらない
            var fr = toPerson.friendlinesses[person.id];
            if (fr < 60 || fr >= 80) continue;

            // 所在地が同じなら交流実行
            if (person.placeId == toPerson.placeId) {
                stol.callStoryFunc("CpuDone", this.stoExeCommunicate, toPerson.id);
            }
        }
    }

    // 所在地にいい仕事があれば転職
    if (tm.irand(8) == 0 || tm.irand(8) == 0)
        for (var i = 0; i< pp.world.occupations.length; i++)
        {
            var occup = pp.world.occupations[i];

            if ((occup.personId == pp.idInvalid || occup.personId == person.ID) &&
                (occup.placeId == pp.idInvalid || occup.placeId == person.placeId) &&
                person.fame >= occup.fame &&
                occup.income > pp.world.occupations[person.occupationId].income)
            {
                //'これが天職だ
                stol.callStoryFunc("CpuDone", this.stoExeOccupation, i);
            }
        }

    // ぶらぶらする
    if (tm.irand(7) == 0 || tm.irand(7) == 0)
        do {
            // 定職があったら大体思いとどまる
            if (pp.world.occupations[person.occupationId].placeId != pp.idInvalid && tm.irand(10) != 0)
                break;

            var toPlaceId = tm.irand(pp.world.places.length);

            // たまに家に帰る
            if (person.homePlaceId != person.placeId && tm.irand(2) == 0)
                toPlaceId = person.homePlaceId;

            if (toPlaceId == person.placeId)
                break;

            var toPlace = pp.world.places[toPlaceId];
            var cost = toPlace.getCostToPlace(person.placeId);

            if (person.money < cost)
                break;

            // 移動しちゃう
            stol.callStoryFunc("CpuDone", this.stoExeMove, toPlaceId);

        } while (false);

    //'批判してみる
    if (tm.irand(6) == 0)
    {
        var reports = pp.world.reports;
        for (var i = 0; i < reports.length; i++)
        {
            var report = reports[i];

            if (report.societyId == pp.idInvalid)
                continue;

            if (pp.world.discoveries[report.discoveryId].type == pp.ttTheory &&
                report.personId != person.id)
            {
                //'批判できる論文があった
                //'友好度が低くて、運が悪いと（？）批判実行
                if (person.friendlinesses[report.personId] < 50 && tm.irand(4) == 0) {
                    stol.callStoryFunc("CpuDone", this.stoExeClaimReport, report.id);
                }
            }
        }
    }

    //'寄付してみる
    if (tm.irand(5) == 0 || tm.irand(5) == 0)
    {
        var toPersonId = tm.irand(pp.world.persons.length);
        var toPerson = pp.world.persons[toPersonId];

        if (toPerson.state == pp.pcActive && person.money >= pp.monDonate && person.id != toPersonId)
        {
            //'理由無く寄付（ありがたや）
            stol.callStoryFunc("CpuDone", this.stoExeDonate, toPersonId);
        }
    }

    // 誹謗中傷する
    if (tm.irand(4) == 0 && tm.irand(3) == 0) /*@@@*/
        do {
            // 一番仲の悪い人物を探す
            var toPerson = person.getPersonWithLeastAmity();

            var fr = person.friendlinesses[toPerson.id];
            if (fr >= 30) break;

            //'中傷
            stol.callStoryFunc("CpuDone", this.stoExeAbuse, toPerson.id);

        } while (false);

    // 読書かなあ
    if (tm.irand(3) == 0 || tm.irand(3) == 0) /*@@@*/
    {
        var fieldId = tm.irand(6);

        //'読書
        stol.callStoryFunc("CpuDone", this.stoExeReadBook, fieldId);
    }

    // 訓練かなあ
    if (tm.irand(2) == 0 || tm.irand(2) == 0) /*@@@*/
    {
        var fieldId = tm.irand(8);

        //'訓練
        stol.callStoryFunc("CpuDone", this.stoExeTrain, fieldId);
    }

    // たまには休みます
    if (true)
    {
        //'訓練
        stol.callStoryFunc("CpuDone", this.stoExeRestMonth);
    }

CpuDone:
    return true;
};









//'* CPUが研究活動する                                                *
stoCpuResearch = function () {
    //cc.log("stoCpuResearch called.");

    var i;
    var person = pp.mediator.person;
    var themep;

    //'全発見済み、またはﾃﾞｰﾀか推理が100以上の時1/2の率でﾃｰﾏを終了
    for (i = 0; i < pp.prThemeNumAPerson; i++)
    {
        themep = person.themePs[i];
        var theme;

        if (themep.themeId == pp.idInvalid)
            continue;
        theme = pp.world.themes[themep.themeId];
        if (person.getDiscoveryCountWithThemeId(themep.themeId) == theme.discoveryCount ||
            ((themep.data >= 100 || themep.deduce >= 100) && tm.irand(2)))
        {
            //'このﾃｰﾏ終了
            person.themePs[i].themeId = pp.idInvalid;
        }
    }

    //'何番のﾃｰﾏを研究するか決定
    var tIdx = pp.idxInvalid;
    for (i = 0; i < 5; i++)
    {
        tIdx = tm.irand(pp.prThemeNumAPerson);

        if (person.themePs[tIdx].themeId != pp.idInvalid)
        {
            themep = person.themePs[tIdx];
            break;
        }
    }

    //'その5回も指して当たらなかったら、そこにﾃｰﾏを選ぶ（かも）
    if (i == 5)
    {
        if (this.cpuChooseNewTheme(tIdx) == false)
            tIdx = pp.idxInvalid;
        else
            themep = person.themePs[tIdx];
    }

    //'*** できることがあるかどうか調べつつ、やっちゃう
    //'*** 理論検証、試作、図
    var disc;
    for (var i = 0; i < pp.world.discoveries.length; i++)
    {
        disc = pp.world.discoveries[i];

        if (person.discCredibilities[disc.id] == pp.crPreNotice)
            continue;

        if (disc.type == pp.ttTheory) {
            if (person.discCredibilities[disc.id] < disc.credibility
                && tm.irand(2) == 0) {
                //'検証の余地があった、やっちゃう(理論検証)
                goto("VerifyTheory");
            }
        }
        else if (disc.type == pp.ttItem) {

            if (person.discCredibilities[disc.id] == pp.crPreMake
                && tm.irand(10) == 0) {
                //'つくってみちゃう(試作)
                goto("MakeTrial");
            }
        }
        else if (disc.type == pp.ttFigure) {

            if (person.discCredibilities[disc.id] == pp.crPreMake
                && tm.irand(10) == 0) {
                //'描いてみちゃう(図)
                goto("DrawFigure");
            }
        }
    }

    //'*** 論文作成
    for (var i = 0; i < pp.world.discoveries.length; i++)
    {
        disc = pp.world.discoveries[i];

        if (person.discCredibilities[disc.id] == pp.crPreNotice ||
            person.discCredibilities[disc.id] == pp.crPreMake)
            continue;

        //'すでに自分で論文にしていないか
        var isWritten = false;
        for (var j = 0; j < person.reports.length; j++) {
            var report = person.reports[j];
            if (report.discoveryId == disc.id) {
                isWritten = true;
                break;
            }
        }
        if (isWritten)
            continue;

        //'論文書いちゃう
        if (tm.irand(2) == 0)
            goto("WriteReport");
    }

    //'*** 提出可能な論文があるか
    if (tm.irand(4) != 0)
        goto("NoSubmitReport");

    var disc;
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];

        //'他の人物が提出していないか？
        var isNew = true;
        for (var j = 0; j < pp.world.reports.length; j++) {
            var report2 = pp.world.reports[j];

            if (report.discoveryId == report2.discoveryId &&
                report2.societyId != pp.idInvalid) {
                isNew = false;
            }
        }

        if (isNew) {

            var isPossible = true;

            //'受理してもらえそうか？
            disc = pp.world.discoveries[report.id];
            switch (disc.type) {
                case pp.ttTheory:
                    if (report.credibility + tm.irand(30) < 50)
                        isPossible = false;
                    break;
                case pp.ttBook:
                case pp.ttThing:
                case pp.ttItem:
                    if (disc.importance / 20 < tm.irand(2))
                        isPossible = false;
                    break;
            }

            //'提出しちゃう
            if (isPossible && pp.world.tutorialStage == pp.tuOff)
                goto("SubmitReport");
        }
    }

NoSubmitReport:

    //'*** 学習でもする？
    var fId;
    if (tm.irand(4) == 0)
    {
        fId = tm.irand(pp.prFieldNum);

        //大学がある土地にいて、資金があれば講義受講
        var univId = person.getUniversityId();
        if (univId != pp.idInvalid && person.money >= pp.monLecture) {
            goto("Lecture");
        }

        //資金があれば訓練
        if (person.money >= pp.monTrain && tm.irand(2) == 0) {
            fId = tm.irand(pp.prTrainTypeNum);
            goto("Train");
        }

        // なければ読書
        goto("ReadBook");
    }

    //'*** やることないねえ、研究する？
    if (tIdx != pp.idxInvalid)
    {
        switch (tm.irand(2))
        {
            case 0:
                //'実験
                goto("ResearchData");

            default:
                //'できれば推理
                if (pp.world.fields[pp.world.themes[themep.themeId].fieldId].isDeducable)
                {
                    goto("ResearchDeduce");
                }

                //'結局実験
                goto("ResearchData");
        }
    }

    goto("RestMonth");

CpuDone:
    return;

VerifyTheory:
    //cc.log("stoExeVerifyTheory, " + disc.id);
    sto.callStoryFunc(this.stoExeVerifyTheory, disc.id);
    goto("CpuDone");

MakeTrial:
    //cc.log("stoExeMakeTrial, " + disc.id);
    sto.callStoryFunc(this.stoExeMakeTrial, disc.id);
    goto("CpuDone");

DrawFigure:
    //cc.log("stoExeDrawFigure, " + disc.id);
    sto.callStoryFunc(this.stoExeDrawFigure, disc.id);
    goto("CpuDone");

WriteReport:
    //cc.log("stoExeMakeReport, " + disc.id);
    sto.callStoryFunc(this.stoExeWriteReport, disc.id);
    goto("CpuDone");

SubmitReport:
    //cc.log("stoExeSubmitReport, " + report.id);
    sto.callStoryFunc(this.stoExeSubmitReport, report.id, tm.irand(2 /**/));
    goto("CpuDone");

Lecture:
    sto.callStoryFunc(this.stoExeLecture, fId);
    goto("CpuDone");


ReadBook:
    sto.callStoryFunc(this.stoExeReadBook, fId);
    goto("CpuDone");

Train:
    sto.callStoryFunc(this.stoExeTrain, fId);
    goto("CpuDone");

ResearchData:
    //cc.log("stoExeResearchData, " + tIdx);
    sto.callStoryFunc(this.stoExeResearchData, tIdx);
    goto("CpuDone");

ResearchDeduce:
    //cc.log("stoExeResearchDeduce, " + tIdx);
    sto.callStoryFunc(this.stoExeResearchDeduce, tIdx);
    goto("CpuDone");

RestMonth:
    //cc.log("stoExeRestMonth");
    sto.callStoryFunc(this.stoExeRestMonth);
    goto("CpuDone");
};


//'* CpuLetter                                                        *
//'* CPUが手紙を書くとか、よけいなことをする                          *
stoCpuLetter = function () {
    //cc.log("stoCpuLetter called.");

    var person = pp.mediator.person;
    var occup;


    //@@@ Debug '批判してみる
    var report;
    if (false)
    {
        for (var i = 0; i < pp.world.reports.length; i++)
        {
            report = pp.world.reports[i];
            if (pp.world.discoveries[report.discoveryId].type == pp.ttTheory &&
                report.personId != person.id &&
                report.societyId != pp.idInvalid)
            {
                //'批判できる論文があった
                //'友好度が低くて、運が悪いと（？）批判実行
                goto("ClaimReport");
            }
        }
    }

    //@@@ Debug ニュートンに寄付
    if (false)
    {
        var toPersonId = pp.piNewton;
        var toPerson = pp.world.persons[toPersonId];

        if (toPerson.state == pp.pcActive && person.money >= 100 && person.id != toPersonId)
        {
            //'理由無く寄付（ありがたや）
            goto("Donate");
        }
    }

    //@@@ Debug 買い物してしまう
    var item;
    {
        var iId = tm.irand(pp.world.items.length);
        item = pp.world.items[iId];
        //'目をつけたｱｲﾃﾑの値段が所持金の半分以下なら買う
        if (item.isActive && item.price <= person.money && person.itemNums[item.id] == 0)
        {
            goto("Buy");
        }
    }


    //'転職してみる
    for (var i = 0; i< pp.world.occupations.length; i++)
    {
        occup = pp.world.occupations[i];

        if ((occup.personId == pp.idInvalid || occup.personId == person.ID) &&
            (occup.placeId == pp.idInvalid || occup.placeId == person.placeId) &&
            person.fame >= occup.fame &&
            occup.income > pp.world.occupations[person.occupationId].income)
        {
            //'これが天職だ
            goto("Occupation");
        }
    }

    //'入会希望を出してみる
    var society;
    var plID;
    if (tm.irand(10) > 4)
    {
        if (person.societyId == pp.idInvalid)
        {
            for (var i = 0; i < 2 /*pp.world.societies.length*/; i++)
            {
                society = pp.world.societies[i];
                if (person.placeId == society.placeId)
                {
                    //'そこにいるなら出す
                    goto("JoinSociety");
                }
            }

            //'組織のあるところへ移動する？
            var sID = tm.irand(2);
            plID = pp.world.societies[sID].placeId;
            //'移動ｺｽﾄ計算  (ｺｽﾄ) = (x座標差 + y座標差) * const
            var cost = pp.world.places[person.placeId].getCostToPlace(plID);

            //'自分専用の定職があったら移動しない
            if ((pp.world.occupations[person.occupationId].personId == pp.idInvalid ||
                pp.world.occupations[person.occupationId].placeId == pp.idInvalid) && person.money >= cost)
            {
                //'移動しちゃう
                goto("Move");
            }
        }
        else
        {
            //'ちょっとぶらぶらしてみる
            plID = tm.irand(pp.world.places.length);

            //'移動ｺｽﾄ計算
            var cost = pp.world.places[person.placeId].getCostToPlace(plID);

            //'定職があったら移動しない
            if (pp.world.occupations[person.occupationId].placeId != pp.idInvalid && person.money >= cost)
            {
                //'移動しちゃう
                goto("Move");
            }
        }
    }

    //'批判してみる
    var report;
    if (tm.irand(10) == 0)
    {
        for (var i = 0; i < pp.world.reports.length; i++)
        {
            report = pp.world.reports[i];
            if (pp.world.discoveries[report.discoveryId].type == pp.ttTheory &&
                report.personId != person.id &&
                report.societyId != pp.idInvalid)
            {
                //'批判できる論文があった
                //'友好度が低くて、運が悪いと（？）批判実行
                if (person.friendlinesses[report.personId] < 70 && tm.irand(4) == 0)
                {
                    goto("ClaimReport");
                }
            }
        }
    }

    //'寄付してみる
    var toPersonId;
    if (tm.irand(4) == 0)
    {
        toPersonId = tm.irand(pp.world.persons.length);
        var toPerson = pp.world.persons[toPersonId];

        if (toPerson.state == pp.pcActive && person.money >= 100 && person.id != toPersonId)
        {
            //'理由無く寄付（ありがたや）
            goto("Donate");
        }
    }

    //'買い物してしまう
    var item;
    {
        var iId = tm.irand(pp.world.items.length);
        item = pp.world.items[iId];
        //'目をつけたｱｲﾃﾑの値段が所持金の半分以下なら買う
        if (item.isActive && item.price <= person.money/2 && person.itemNums[item.id] == 0)
        {
            goto("Buy");
        }
    }

    //???
    //cc.log("cpu???--?");
    goto("RestMonth");

CpuDone:
    return;

//------------

Occupation:
    sto.callStoryFunc(this.stoExeOccupation, occup.id);
    goto("CpuDone");

JoinSociety:
    sto.callStoryFunc(this.stoExeJoinSociety, society.id);
    goto("CpuDone");

Move:
    sto.callStoryFunc(this.stoExeMove, plID);
    goto("CpuDone");

ClaimReport:
    sto.callStoryFunc(this.stoExeClaimReport, report.id);
    goto("CpuDone");

Donate:
    sto.callStoryFunc(this.stoExeDonate, toPersonId);
    goto("CpuDone");

Buy:
    sto.callStoryFunc(this.stoExeBuy, item.id);
    goto("CpuDone");

RestMonth:
    sto.callStoryFunc(this.stoExeRestMonth);
    goto("CpuDone");
};





pp.PrStory.prototype.cpuChooseNewTheme = function (tIdx) {

    var person = pp.mediator.person;
    var fID;
    var tID = pp.idInvalid;

    //'最も得意な分野ｻｰﾁ

    //各自選びたいテーマのリストを作る
    var preferredThemes = person.getPreferredThemes();




    var bestApt = 0;
    var bestFID = pp.idInvalid;
    for (fID = 0; fID < pp.prFieldNum - 1; fID++)
    {
        if (person.fieldPs[fID].aptitude > bestApt)
        {
            bestApt = person.fieldPs[fID].aptitude;
            bestFID = fID;
        }
    }

    for (var i = 0; i < pp.world.themes.length && tID == pp.idInvalid; i++)
    {
        var theme = pp.world.themes[i];

        if (theme.fieldId != bestFID)
            continue;

        if (person.getDiscoveryCountWithThemeId(theme.id) == theme.discoveryCount && (tm.irand(2) == 0))
            continue;

        //'未発見のものがある
        tID = theme.id;
    }

    for (var i = 0; i < pp.world.themes.length && tID == pp.idInvalid; i++)
    {
        var theme = pp.world.themes[i];

        if (person.getDiscoveryCountWithThemeId(theme.id) == theme.discoveryCount && (tm.irand(2) == 0))
            continue;

        //'未発見のものがある
        tID = theme.id;
    }

    //'たまたま？次のﾃｰﾏが見つからなかった
    if (tID == pp.idInvalid)
        return false;

    //'すでにﾃｰﾏにしていないか？
    if (person.themePs[0].themeId == tID ||
        person.themePs[1].themeId == tID ||
        person.themePs[2].themeId == tID)
    {
        //'今回はあきらめる
        return false;
    }

    //'ﾃｰﾏIDｾｯﾄ
    person.themePs[tIdx].themeId = tID;
    person.themePs[tIdx].deduce = 0;
    person.themePs[tIdx].data = 0;

    return true;
};



pp.PrStory.prototype.cpuChooseNewTheme0 = function (tIdx) {

    var person = pp.mediator.person;
    var fID;
    var tID = pp.idInvalid;

    //'最も得意な分野ｻｰﾁ
    var bestApt = 0;
    var bestFID = pp.idInvalid;
    for (fID = 0; fID < pp.prFieldNum - 1; fID++)
    {
        if (person.fieldPs[fID].aptitude > bestApt)
        {
            bestApt = person.fieldPs[fID].aptitude;
            bestFID = fID;
        }
    }

    for (var i = 0; i < pp.world.themes.length && tID == pp.idInvalid; i++)
    {
        var theme = pp.world.themes[i];

        if (theme.fieldId != bestFID)
            continue;

        if (person.getDiscoveryCountWithThemeId(theme.id) == theme.discoveryCount && (tm.irand(2) == 0))
            continue;

        //'未発見のものがある
        tID = theme.id;
    }

    for (var i = 0; i < pp.world.themes.length && tID == pp.idInvalid; i++)
    {
        var theme = pp.world.themes[i];

        if (person.getDiscoveryCountWithThemeId(theme.id) == theme.discoveryCount && (tm.irand(2) == 0))
            continue;

        //'未発見のものがある
        tID = theme.id;
    }

    //'たまたま？次のﾃｰﾏが見つからなかった
    if (tID == pp.idInvalid)
        return false;

    //'すでにﾃｰﾏにしていないか？
    if (person.themePs[0].themeId == tID ||
        person.themePs[1].themeId == tID ||
        person.themePs[2].themeId == tID)
    {
        //'今回はあきらめる
        return false;
    }

    //'ﾃｰﾏIDｾｯﾄ
    person.themePs[tIdx].themeId = tID;
    person.themePs[tIdx].deduce = 0;
    person.themePs[tIdx].data = 0;

    return true;
};
