
stoManualCommand = function () {

    var person = pp.mediator.person;

    if (pp.mediator.getBgm() == res.Mus_Main) {
        goto("MusicNoChange");
    }
    pp.mediator.stopBgm();
    sleep(0.3);

MusicNoChange:

    var orgScale = pp.mediator.uiGetMapScale();
    pp.mediator.uiSetMapScale(2);

    pp.mediator.playSound(res.Snd_Notice);
    pp.mediator.setBgm(res.Mus_Main, 1);
    pp.mediator.uiShowCommandWindow(true);
    pp.mediator.uiShowPersonWindow(true);
    pp.mediator.uiSetEnabledPager(true);

Command:
    pp.mediator.uiUpdate();

    sto.callTutorialFunc(this.stoTutPages1);
    sto.callTutorialFunc(this.stoTutLast);

    var sel;
    if (person.preferredPage == pp.PG_RESEARCH) {
        //cc.log("nextPage is RESEARCH　(" + (person.preferedPage == pp.PG_RESEARCH) + ")");
        sel = pp.cmpResearch;
        goto("DidGetUserInput");
    }
    else if (person.preferredPage == pp.PG_THEME_MAP) {
        //cc.log("nextPage is THEME_MAP　(" + (person.preferedPage == pp.PG_THEME_MAP) + ")");
        sel = pp.cmpThemeMap;
        goto("DidGetUserInput");
    }
    else if (person.preferredPage == pp.PG_SYSTEM) {
        //cc.log("nextPage is SYSTEM　(" + (person.preferedPage == pp.PG_SYSTEM) + ")");
        sel = pp.cmpSystem;
        goto("DidGetUserInput");
    }

    sel = sto.wuiWaitUserInput();

    var ret = sto.callTutorialFunc(this.stoTutCheckSelection, sel);
    if (ret == false) {
        goto("Command");
    }

DidGetUserInput:
    var stoFuncToCall = null;
    var arg = null;
    var id;
    if (sel >= pp.cmPagerOffset) {
        switch (sel) {
            case pp.cmpMap: person.preferredPage = pp.PG_MAP; break;
            case pp.cmpResearch: person.preferredPage = pp.PG_RESEARCH; stoFuncToCall = this.stoComPagedResearch; break;
            case pp.cmpThemeMap: person.preferredPage = pp.PG_THEME_MAP; stoFuncToCall = this.stoComPagedThemeMap; break;
            case pp.cmpSystem: person.preferredPage = pp.PG_SYSTEM; stoFuncToCall = this.stoComPagedSystem; break;
        }
    }
    else if (sel >= pp.cmObservatoryOffset) {
        id = sel - pp.cmObservatoryOffset;
        stoFuncToCall = this.stoComObservatory;
        arg = id;
    }
    else if (sel >= pp.cmUniversityOffset) {
        id = sel - pp.cmUniversityOffset;
        stoFuncToCall = this.stoComUniversity;
        arg = id;
    }
    else if (sel >= pp.cmSocietyOffset) {
        id = sel - pp.cmSocietyOffset;
        stoFuncToCall = this.stoComSociety;
        arg = id;
    }
    else if (sel >= pp.cmPersonOffset) {
        id = sel - pp.cmPersonOffset;
        stoFuncToCall = this.stoComPerson;
        arg = id;
    }
    else if (sel >= pp.cmPlaceOffset) {
        id = sel - pp.cmPlaceOffset;
        stoFuncToCall = this.stoComPlace;
        arg = id;
    }
    else {
        switch (sel) {

            case pp.cmStudy: stoFuncToCall = this.stoComStudy; break;
            case pp.cmTheory: stoFuncToCall = this.stoComTheory; break;
            case pp.cmMake: stoFuncToCall = this.stoComMake; break;
            case pp.cmLetter: stoFuncToCall = this.stoComLetter; break;
            case pp.cmInfo: stoFuncToCall = this.stoComInfo; break;
            case pp.cmChange: stoFuncToCall = this.stoComChange; break;
            case pp.cmReport: stoFuncToCall = this.stoComReport; break;
            case pp.cmWrite: stoFuncToCall = this.stoComWrite; break;
            case pp.cmShop: stoFuncToCall = this.stoComShop; break;

            case pp.cmSystem: break; //stoFuncToCall = this.stoComSystem; break;
            case pp.cmResearch: break;

            case pp.cmMove:
            case pp.cmOccupation:
            case pp.cmRest:

                break;
        }
    }

    if (stoFuncToCall == null) goto("Command");

    sel = sto.callStoryFunc(stoFuncToCall, arg);

    if (sel == false) {
        goto("Command");
    }

    goto("Exit");
/*
InfoPlace:
    sto.wuiShowPlace(id, pp.MW_USER);

    goto("Command");
    */

Exit:
    if (pp.mediator.isCheckingText && pp.mediator.gameState == pp.gsTurn)
        goto("Command");

    pp.mediator.uiHidePersonWindow(true);
    pp.mediator.uiHideCommandWindow(true);
    pp.mediator.uiSetEnabledPager(false);

    pp.mediator.uiSetMapScale(orgScale);

    if (pp.mediator.toResetManualAfterThisTurn) {
        person.isManual = false;
        pp.mediator.updateIsDemo();
        pp.mediator.toResetManualAfterThisTurn = false;
    }

    return;
};
