
stoEveEnding = function (personId) {

    // Set BGM
    pp.mediator.setBgm(res.Mus_Ending);

    var person = pp.world.persons[personId];
    var society = person.societyId == pp.idInvalid ? null : pp.world.societies[person.societyId];
    var place = pp.world.places[person.placeId];

    //'*** ﾒｯｾｰｼﾞ作成開始
    var mes = "";

    if (pp.mediator.gameOverReason == pp.goDead)
    {
        //'死亡時
        mes += __(str.s690, pp.mediator.getDateString(), person.fullName, place.name);
            //pp.mediator.getDateString() + " " + person.fullName + "は" + place.name + "でその生涯を閉じた。";
    }
    else if (pp.mediator.gameOverReason == pp.goRetired)
    {
        //'引退時
        mes += __(str.s691, pp.mediator.getDateString(), person.fullName);
            //pp.mediator.getDateString() + " " + person.fullName + "は研究活動から身を引いた。";
    }
    else
    {
        //最終テーマクリア時
        mes += __(str.s1016, pp.mediator.getDateString(), person.fullName);
        /*
            pp.mediator.getDateString() + "、" + person.fullName +
            "は、後世に多大な影響をおよぼすことになる大著を出版し、" +
            "「近代科学の創始者」と言われるようになった。";
            */
    }

    mes += CR + CR + CR;

    //'*** 組織反映
    if (person.societyId == pp.idInvalid)
    {
        //'組織無所属
        mes += __(str.s692);
            //"組織に所属することなく行った独創的な研究は、";
    }
    else if (person.jobIdx == pp.idxInvalid)
    {
        //'一般会員
        mes += __(str.s693, society.name);
            //society.name + "の会員であった彼が行った独創的な研究は、";
    }
    else
    {
        //'役員
        mes += __(str.s694, society.name, person.jobName); // + "の高い地位である";
        //mes += (person.jobIdx == 0 ? society.jobName0 : person.jobIdx == 1 ? society.jobName1 : society.jobName2);
        //mes += "にまでなった彼が行った独創的な研究は、";
    }

    //'*** 名声値反映
    mes +=
        person.fame >= 1000 ? __(str.s696) :
        person.fame >= 600  ? __(str.s697) :
        person.fame >= 400  ? __(str.s698) :
        person.fame >= 200  ? __(str.s699) :
                              __(str.s700);
        /*
        person.fame >= 1000 ? "暗黒に包まれていた当時の科学に革命をもたらし１７〜１８世紀を通じてもっとも偉大な科学者とされている。" :
        person.fame >= 600  ? "数々のすばらしい成果を挙げ非常に高い評価を得ている。" :
        person.fame >= 400  ? "それなりの成果を挙げ一定の評価をされている。" :
        person.fame >= 200  ? "あまり成果は挙がらず評価もそれほど高くない。" :
                              "くだらない物ばかりで誰からも評価されてはいない。";
      */

    //////////////////////////////
    mes += "\n\n\n";

    //'*** この人物の発見を反映
    //'言及発見数初期化
    var discNum = 0;
    // mes = mes + "　"

    //'*** 理論を反映
    var maxIm = 0;
    var disc;
    var maxImDID = pp.idInvalid;
    //'この人物の理論の中で最も重要度の高いものをｻｰﾁ
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];

        if (report.societyId == pp.idInvalid) continue;

        disc = pp.world.discoveries[report.discoveryId];
        if (disc.type != pp.ttTheory)
            continue;

        if (disc.importance > maxIm)
        {
            maxIm = disc.importance;
            maxImDID = report.discoveryId;
        }
    }
    if (maxImDID != pp.idInvalid)
    {
        disc = pp.world.discoveries[maxImDID];
        //'*** この理論に言及
        mes += __(str.s701) + __(str.s702, disc.name);
            //"彼の新しい理論はとても優れていた。例えば";
            //mes += "『" + disc.name +  "』と言う彼の理論は当時から広く認められていた。";
        mes += "\n\n";
        discNum++;
    }

    //'*** 存在を反映
    maxIm = 0;
    maxImDID = pp.idInvalid;
    //'この人物の発見存在の中で最も重要度の高いものをｻｰﾁ
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];
        if (report.societyId == pp.idInvalid) continue;

        disc = pp.world.discoveries[report.discoveryId];
        if (disc.type != pp.ttThing)
            continue;

        if (disc.importance > maxIm)
        {
            maxIm = disc.importance;
            maxImDID = report.discoveryId;
        }
    }
    if (maxImDID != pp.idInvalid)
    {
        disc = pp.world.discoveries[maxImDID];
        //'*** この発見に言及
        mes += discNum == 0 ? __(str.s703) : __(str.s695);
            //"例えば" : "また";
        mes += __(str.s704, disc.thingName) +
            //disc.name + "を発見したのは他ならぬ彼である。" +
            "\n\n";
        discNum++;
    }

    //'*** 図を反映
    maxIm = 0;
    maxImDID = pp.idInvalid;
    //'この人物の図の中で最も重要度の高いものをｻｰﾁ
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];
        if (report.societyId == pp.idInvalid) continue;

        disc = pp.world.discoveries[report.discoveryId];
        if (disc.type != pp.ttFigure)
            continue;

        if (disc.importance > maxIm)
        {
            maxIm = disc.importance;
            maxImDID = report.discoveryId;
        }
    };
    if (maxImDID != pp.idInvalid)
    {
        disc = pp.world.discoveries[maxImDID];
        //'*** この図に言及
        mes += discNum == 0 ?
            __(str.s705) : __(str.s695);
            //"彼の仕事の中で目立ったものはスケッチであった。" : "また";
        mes +=
            __(str.s706, disc.name) +
            //"彼は図の描画に長けていたので、見事な" + disc.name + "を描きあげて当時の人々を驚かせた。" +
            "\n\n";
        discNum++;
    }

    //'*** 発明を反映
    maxIm = 0;
    maxImDID = pp.idInvalid;
    //'この人物の発明の中で最も重要度の高いものをｻｰﾁ
    for (var i = 0; i < person.reports.length; i++) {
        var report = person.reports[i];
        if (report.societyId == pp.idInvalid) continue;

        disc = pp.world.discoveries[report.discoveryId];

        if (disc.type != pp.ttItem)
            continue;

        if (disc.importance > maxIm)
        {
            maxIm = disc.importance;
            maxImDID = report.discoveryId;
        }
    };
    if (maxImDID != pp.idInvalid)
    {
        disc = pp.world.discoveries[maxImDID];
        //'*** この発明に言及
        mes += discNum == 0 ?
            "" : __(str.s707);
            //"彼は、" : "また、";
        mes +=
            __(str.s708, disc.name) +
            //"そのすぐれた洞察力で" + disc.name + "の可能性に気付き、実際にそれを製作することに成功した。" +
            "\n\n";
        discNum++;
    }

    //'*** 発見が1つも無い？
    if (discNum == 0)
    {
        mes += __(str.s709) +
            //"そもそも凡庸な彼が発見した事など何一つ存在しないのだ。" +
            "\n\n";
    }

    //////////////////////////////

    mes += "\n\n\n\n";

    //'*** また名声値反映
    mes +=
        __(str.s710) +
        //"後年、ある詩人は彼の業績を称えてこう言った。" +
        "\n\n\n" +
        __(str.s711) +
        //"『自然と自然の法則は、夜の闇の中にあった。" +
        "\n" +
        __(str.s712, person.lastName) +
        //"  神は言われた" +
        //"\n" +
        //"　「" + person.lastName +  "在れ！」と。" +
        "\n";

    mes +=
        person.fame >= 1000 ? __(str.s713) :
        person.fame >= 600 ?  __(str.s715) :
        person.fame >= 400 ?  __(str.s716) :
        person.fame >= 200 ?  __(str.s717) :
            __(str.s718);

        /*
        person.fame >= 1000 ? "  ・・・その時、全てが明るくなった！" :
        //person.fame >= 1000 ? "  ・・・すると、かなり明るくなった。" :
        person.fame >= 600 ?  "  ・・・すると、すこし明るくなった。" :
        person.fame >= 400 ?  "  ・・・しかし思ったほどは明るくならなかった。" :
        person.fame >= 200 ?  "  ・・・しかし大した変化はおこらなかった。" :
                             "  ・・・その時、真っ暗闇がおとずれた。";
         */

    mes += "\n";

    //mes = tm.insertNewLines(mes, __(40, 80), null, __(true, false));

    sto.wuiShowBigMessage(mes);
};
